/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.developer;

import java.io.File;
import java.io.IOException;
import org.moe.common.exec.ExecOutputCollector;
import org.moe.common.exec.SimpleExec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeSDKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NativeSDKUtil.class);
    public static final String PLATFORM_IOS = "iOS";
    public static final String PLATFORM_OSX = "OS X";
    public static final String PLATFORM_TVOS = "tvOS";
    public static final String PLATFORM_NDK = "NDK";

    private NativeSDKUtil() {
    }

    public static File getXcodeDeveloperPath() {
        String out;
        SimpleExec xcodeSelect = SimpleExec.getXcodeSelect();
        xcodeSelect.getArguments().add("-p");
        try {
            out = ExecOutputCollector.collect(xcodeSelect).trim();
        }
        catch (IOException e) {
            LOG.debug("Failed to get Xcode developer path", e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.debug("Failed to get Xcode developer path", e);
            return null;
        }
        File f = new File(out);
        return f.exists() ? f : null;
    }

    public static File getXcodePlatformPath(String sdk) {
        String out;
        SimpleExec xcodeSelect = SimpleExec.getExec("xcrun");
        xcodeSelect.getArguments().add("--sdk");
        xcodeSelect.getArguments().add(sdk);
        xcodeSelect.getArguments().add("--show-sdk-platform-path");
        try {
            out = ExecOutputCollector.collect(xcodeSelect).trim();
        }
        catch (IOException e) {
            LOG.debug("Failed to get Xcode developer path", e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.debug("Failed to get Xcode developer path", e);
            return null;
        }
        File f = new File(out);
        return f.exists() ? f : null;
    }

    public static File getXcodePlatformSDKsPath(String sdk) {
        File file;
        File path = NativeSDKUtil.getXcodePlatformPath(sdk);
        if (path != null && (file = new File(path, "Developer" + File.separator + "SDKs")).exists()) {
            return file;
        }
        return null;
    }

    public static File getXcodePath() {
        File path = NativeSDKUtil.getXcodeDeveloperPath();
        if (path == null) {
            LOG.debug("Failed to get Xcode.app path, developer path is null, falling back to /Applications/Xcode.app");
        } else if ("Developer".equals(path.getName()) && "Contents".equals((path = path.getParentFile()).getName())) {
            if (!(path = path.getParentFile()).getName().endsWith(".app")) {
                LOG.debug("Failed to get Xcode.app path, didn't find .app file");
            } else {
                return path;
            }
        }
        path = new File("/Applications/Xcode.app");
        return path.exists() ? path : null;
    }

    public static void openWithXcode(String file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        File xcodePath = NativeSDKUtil.getXcodePath();
        if (xcodePath == null) {
            throw new NullPointerException();
        }
        SimpleExec open = SimpleExec.getOpen(xcodePath.toString(), file);
        int exit = open.getRunner().run(null);
        if (exit != 0) {
            throw new IOException("exit code " + exit);
        }
    }

    public static File getPlatformSDKsPath(String platform) {
        if (platform.equalsIgnoreCase(PLATFORM_IOS)) {
            return NativeSDKUtil.getXcodePlatformSDKsPath("iphoneos");
        }
        if (platform.equalsIgnoreCase(PLATFORM_OSX)) {
            return NativeSDKUtil.getXcodePlatformSDKsPath("macosx");
        }
        if (platform.equalsIgnoreCase(PLATFORM_TVOS)) {
            return NativeSDKUtil.getXcodePlatformSDKsPath("appletvos");
        }
        if (platform.equalsIgnoreCase(PLATFORM_NDK)) {
            File ndkHome;
            String ndkHomeEnv = System.getenv("NDK_HOME");
            if (ndkHomeEnv != null && (ndkHome = new File(ndkHomeEnv, "platforms")).exists()) {
                return ndkHome;
            }
            String userHomeProp = System.getProperty("user.home");
            if (userHomeProp != null) {
                File userHome = new File(userHomeProp, "Library" + File.separator + "Android" + File.separator + "sdk" + File.separator + "ndk-bundle" + File.separator + "platforms");
                if (userHome.exists()) {
                    return userHome;
                }
                userHome = new File(userHomeProp, "AppData" + File.separator + "Local" + File.separator + "Android" + File.separator + "sdk" + File.separator + "ndk-bundle" + File.separator + "platforms");
                if (userHome.exists()) {
                    return userHome;
                }
            }
            return null;
        }
        return null;
    }
}

