/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.developer;

import com.dd.plist.NSArray;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.PropertyListParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.moe.common.exec.ExecOutputCollector;
import org.moe.common.exec.SimpleExec;

public class ProvisioningProfile
implements Serializable {
    private String uuid;
    private String name;
    private Type type;
    private File file;
    private String appIdName;
    private String appIdPrefix;
    private String appId;
    private Date creationDate;
    private Date expirationDate;
    private List<String> certFingerprints;
    private transient NSArray provisionedDevices;

    private ProvisioningProfile() {
    }

    public static String getPlistFromProfile(String filePath) throws Exception {
        SimpleExec exec = SimpleExec.getExec("security");
        ArrayList<String> execArgs = exec.getArguments();
        execArgs.add("cms");
        execArgs.add("-D");
        execArgs.add("-i");
        execArgs.add(filePath);
        return ExecOutputCollector.collect(exec);
    }

    public static List<ProvisioningProfile> getProfiles() {
        File dir = new File(new File(System.getProperty("user.home")), "Library/MobileDevice/Provisioning Profiles");
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<ProvisioningProfile> result = new ArrayList<ProvisioningProfile>();
        File[] files = dir.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            NSDictionary rootDict;
            String plistBody;
            if (!file.getName().endsWith(".mobileprovision")) continue;
            try {
                plistBody = ProvisioningProfile.getPlistFromProfile(file.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (plistBody == null || plistBody.isEmpty()) continue;
            plistBody = plistBody.substring(0, plistBody.length() - 1);
            plistBody = plistBody.replace("\n", "").replace("\t", "");
            byte[] bytes = plistBody.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            try {
                rootDict = (NSDictionary)PropertyListParser.parse(inputStream);
            }
            catch (Exception e) {
                continue;
            }
            ProvisioningProfile profile = new ProvisioningProfile();
            profile.file = file;
            profile.name = rootDict.objectForKey("Name").toString();
            profile.uuid = rootDict.objectForKey("UUID").toString();
            profile.appIdName = rootDict.objectForKey("AppIDName") != null ? rootDict.objectForKey("AppIDName").toString() : null;
            profile.appIdPrefix = ((NSArray)rootDict.objectForKey("ApplicationIdentifierPrefix")).objectAtIndex(0).toString();
            profile.creationDate = ((NSDate)rootDict.objectForKey("CreationDate")).getDate();
            profile.expirationDate = ((NSDate)rootDict.objectForKey("ExpirationDate")).getDate();
            NSDictionary entitlements = (NSDictionary)rootDict.objectForKey("Entitlements");
            boolean taskAllow = ((NSNumber)entitlements.objectForKey("get-task-allow")).boolValue();
            profile.provisionedDevices = (NSArray)rootDict.objectForKey("ProvisionedDevices");
            profile.type = taskAllow ? Type.Development : (profile.provisionedDevices != null ? Type.AdHoc : Type.AppStore);
            result.add(profile);
        }
        return result;
    }

    public static String getUUIDFromProfile(File file) throws Exception {
        String plistBody = ProvisioningProfile.getPlistFromProfile(file.getAbsolutePath());
        if (plistBody == null || plistBody.isEmpty()) {
            throw new Exception("Failed to get plist from provisioning profile: " + file.getAbsolutePath());
        }
        plistBody = plistBody.substring(0, plistBody.length() - 1);
        plistBody = plistBody.replace("\n", "").replace("\t", "");
        byte[] bytes = plistBody.getBytes();
        NSDictionary rootDict = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            rootDict = (NSDictionary)PropertyListParser.parse(inputStream);
        }
        catch (Exception e) {
            throw new Exception("Failed to parse provisioning profile: " + file.getAbsolutePath() + "\n" + e.getMessage(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        String result = rootDict.objectForKey("UUID").toString();
        if (result == null || result.isEmpty()) {
            throw new Exception("Failed to get UUID (null or empty) from profile: " + file.getAbsolutePath());
        }
        return result;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type.toString();
    }

    public File file() {
        return this.file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProvisioningProfile [");
        builder.append("type=" + (Object)((Object)this.type) + ",");
        builder.append("file=" + this.file + ",");
        builder.append("uuid=" + this.uuid + ",");
        builder.append("name=" + this.name + ",");
        builder.append("appIdName=" + this.appIdName + ",");
        builder.append("appIdPrefix=" + this.appIdPrefix + ",");
        builder.append("appId=" + this.appId + ",");
        builder.append("creationDate=" + this.creationDate + ",");
        builder.append("expirationDate=" + this.expirationDate + ",");
        builder.append("certFingerprints=" + this.certFingerprints);
        builder.append("]");
        return builder.toString();
    }

    public String uuid() {
        return this.uuid;
    }

    public static class ProvisioningProfileComboItem {
        public ProvisioningProfile provisioningProfile;

        public ProvisioningProfileComboItem(ProvisioningProfile Provisioning) {
            this.provisioningProfile = Provisioning;
        }

        public String toString() {
            return this.provisioningProfile.name() + " (" + this.provisioningProfile.uuid() + ")";
        }
    }

    public static enum Type {
        Development,
        AppStore,
        AdHoc;

    }
}

