/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.developer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.moe.common.exec.ExecOutputCollector;
import org.moe.common.exec.SimpleExec;

public class SigningIdentity
implements Comparable<SigningIdentity>,
Serializable {
    private static final String PATTERN = "^\\d+\\)\\s+([0-9A-F]+)\\s+\"([^\"]*)\"\\s*(.*)";
    private final String name;
    private final String fingerprint;

    public SigningIdentity(String name, String fingerprint) {
        this.name = name;
        this.fingerprint = fingerprint;
    }

    private static SigningIdentity parse(String line) {
        SigningIdentity identity = null;
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String name = matcher.group(2);
        String fingerprint = matcher.group(1);
        String flags = matcher.group(3);
        if (flags == null || !flags.contains("CSSMERR_TP_CERT_")) {
            identity = new SigningIdentity(name, fingerprint);
        }
        return identity;
    }

    public static List<SigningIdentity> getIdentities() throws Exception {
        String[] lines;
        ArrayList<SigningIdentity> list = new ArrayList<SigningIdentity>();
        SimpleExec exec = SimpleExec.getExec("security");
        ArrayList<String> execArgs = exec.getArguments();
        execArgs.add("find-identity");
        execArgs.add("-v");
        execArgs.add("-p");
        execArgs.add("codesigning");
        String output = ExecOutputCollector.collect(exec);
        if (output == null) {
            return Collections.emptyList();
        }
        for (String line : lines = output.split("\n")) {
            SigningIdentity identity = SigningIdentity.parse(line.trim());
            if (identity == null) continue;
            list.add(identity);
        }
        return list;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "SigningIdentity [name=" + this.name + ",fingerprint=" + this.fingerprint + "]";
    }

    @Override
    public int compareTo(SigningIdentity compareTo) {
        return this.name.compareToIgnoreCase(compareTo.name);
    }

    public String getFormattedOutput(int nIndex) {
        return String.valueOf(nIndex) + ") " + this.fingerprint + " \"" + this.name + '\"';
    }
}

