/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.moe.common.exec.ExecRunner;
import org.moe.common.utils.OsUtils;

public abstract class AbstractExec {
    private String name = null;
    private int returnCode;
    private final ArrayList<String> arguments = new ArrayList();
    protected File workingDir = null;

    public AbstractExec() {
    }

    public AbstractExec(String name, File workingDir) {
        this.name = name;
        this.workingDir = workingDir;
    }

    public ArrayList<String> getArguments() {
        return this.arguments;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected abstract String lookupExec();

    public String getExecPath() {
        if (this.name != null) {
            return this.name;
        }
        return this.lookupExec();
    }

    public ExecRunner getRunner() throws IOException {
        ArrayList<String> cmds = new ArrayList<String>(this.getArguments().size() + 1);
        String exec = this.getExecPath();
        if (exec == null) {
            throw new IOException("exec is null");
        }
        if (OsUtils.isMac()) {
            try {
                File execFile = new File(exec);
                if (execFile.exists() && !execFile.canExecute()) {
                    Runtime.getRuntime().exec("chmod 777 " + exec);
                }
            }
            catch (Exception execFile) {
                // empty catch block
            }
        }
        cmds.add(exec);
        this.applyArguments(cmds);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.directory(this.workingDir);
        return new ExecRunner(builder);
    }

    protected void applyArguments(ArrayList<String> cmds) {
        cmds.addAll(this.getArguments());
    }
}

