/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.moe.common.exec.AbstractExec;

public abstract class AbstractJarExec
extends AbstractExec {
    private final ArrayList<String> vmArguments = new ArrayList();
    private final File jar;

    protected AbstractJarExec(File jar, File workingDir) {
        super(AbstractJarExec.getDefaultJavaExec(), workingDir);
        if (jar == null) {
            throw new NullPointerException();
        }
        this.jar = jar;
    }

    public ArrayList<String> getVmArguments() {
        return this.vmArguments;
    }

    public static String getDefaultJavaExec() {
        return "java";
    }

    @Override
    protected String lookupExec() {
        return null;
    }

    @Override
    protected void applyArguments(ArrayList<String> cmds) {
        cmds.addAll(this.vmArguments);
        cmds.add("-jar");
        cmds.add(this.jar.getAbsolutePath());
        super.applyArguments(cmds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File copyToTmpFromResource(String inFilePath, String outFileName) throws IOException {
        File of = File.createTempFile(outFileName, ".jar");
        of.delete();
        of.createNewFile();
        of.deleteOnExit();
        try (InputStream is = AbstractJarExec.class.getResourceAsStream(inFilePath);
             FileOutputStream fos = new FileOutputStream(of);){
            int read;
            byte[] buffer = new byte[65536];
            while ((read = is.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        return of;
    }
}

