/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.moe.common.exec.AbstractExec;
import org.moe.common.exec.ExecRunner;

public class BindingExec
extends AbstractExec {
    private boolean test;

    public BindingExec(File projectFile, String sdkPath, File confFile, boolean test) throws IOException {
        super(null, new File(sdkPath + File.separator + "tools"));
        this.test = test;
        this.getArguments().add(projectFile.getParent());
        this.getArguments().add(projectFile.getName());
        this.getArguments().add(confFile.getCanonicalPath());
    }

    @Override
    public ExecRunner getRunner() throws IOException {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("java");
        if (this.test) {
            cmds.add("-Dmoe.natjgen.testrun=true");
        }
        cmds.add("-jar");
        cmds.add("wrapnatjgen.jar");
        this.applyArguments(cmds);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.directory(this.workingDir);
        return new ExecRunner(builder);
    }

    @Override
    protected String lookupExec() {
        return "";
    }
}

