/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.IOException;
import java.util.Map;
import org.moe.common.exec.AbstractExec;
import org.moe.common.exec.ExecRunner;
import org.moe.common.exec.ExecRunnerBase;

public class ExecOutputCollector {
    private ExecOutputCollector() {
    }

    public static String collect(AbstractExec exec) throws IOException, InterruptedException {
        return ExecOutputCollector.collect(exec, null);
    }

    public static String collect(AbstractExec exec, Map<String, String> env) throws IOException, InterruptedException {
        ExecRunner runner = exec.getRunner();
        String output = ExecOutputCollector.collect(runner, env);
        return output;
    }

    public static String collect(ExecRunner runner) throws IOException, InterruptedException {
        return ExecOutputCollector.collect(runner, null);
    }

    public static String collect(ExecRunner runner, Map<String, String> env) throws IOException, InterruptedException {
        int rc;
        final StringBuilder out = new StringBuilder();
        final StringBuilder err = new StringBuilder();
        runner.setListener(new ExecRunnerBase.ExecRunnerListener(){

            @Override
            public void stdout(String line) {
                out.append(line).append("\n");
            }

            @Override
            public void stderr(String line) {
                err.append(line).append("\n");
            }
        });
        if (env != null) {
            Map<String, String> environment = runner.getBuilder().environment();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                environment.put(entry.getKey(), entry.getValue());
            }
        }
        if ((rc = runner.run(null)) != 0) {
            if (runner.wasKilled()) {
                throw new IOException("Execution of command '" + runner.commandLine() + "' was canceled by the user.");
            }
            throw new IOException("Execution of command '" + runner.commandLine() + "' failed with error code " + rc + "\n" + err.toString());
        }
        return out.toString();
    }
}

