/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.IOException;
import org.moe.common.exec.ExecRunnerBase;
import org.moe.common.exec.IKillListener;

public class ExecRunner
extends ExecRunnerBase {
    private final ProcessBuilder builder;

    ExecRunner(ProcessBuilder builder) {
        if (builder == null) {
            throw new NullPointerException();
        }
        this.builder = builder;
    }

    public ProcessBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public synchronized int run(IKillListener killListener) throws IOException {
        Process process = this.execute();
        this.killChecker = new ExecRunnerBase.KillChecker(this, process, killListener);
        try {
            this.returnCode = process.waitFor();
            if (this.listener != null) {
                this.stdoutStreamListener.waitFor();
                this.stderrStreamListener.waitFor();
            }
            this.killChecker.waitFor();
            return this.returnCode;
        }
        catch (InterruptedException e) {
            throw new IOException("exec was interrupted", e);
        }
        catch (Exception e) {
            throw new IOException("Execution failure.", e);
        }
    }

    private Process execute() throws IOException {
        Process process = this.builder.start();
        if (this.listener != null) {
            this.stdoutStreamListener = new ExecRunnerBase.StdoutStreamListener(this, process.getInputStream(), this.listener);
            this.stderrStreamListener = new ExecRunnerBase.StderrStreamListener(this, process.getErrorStream(), this.listener);
        }
        return process;
    }

    public String commandLine() {
        String command = "";
        for (String arg : this.builder.command()) {
            command = command + arg + ' ';
        }
        if (command.endsWith(" ")) {
            command = command.substring(0, command.length() - 1);
        }
        return command;
    }
}

