/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.moe.common.exec.IKillListener;

public abstract class ExecRunnerBase {
    protected ExecRunnerListener listener;
    protected StdoutStreamListener stdoutStreamListener;
    protected StderrStreamListener stderrStreamListener;
    protected KillChecker killChecker;
    protected boolean wasKilled;
    protected int returnCode;

    public ExecRunnerListener getListener() {
        return this.listener;
    }

    public synchronized void setListener(ExecRunnerListener listener) {
        this.listener = listener;
    }

    public abstract int run(IKillListener var1) throws IOException;

    public boolean wasKilled() {
        return this.wasKilled;
    }

    public int returnCode() {
        return this.returnCode;
    }

    protected class KillChecker
    implements Runnable {
        private final Process process;
        private final IKillListener listener;
        private final Thread runner;

        public KillChecker(Process process, IKillListener listener) {
            this.process = process;
            this.listener = listener;
            this.runner = new Thread(this);
            this.runner.start();
        }

        @Override
        public void run() {
            if (this.listener == null || this.process == null) {
                return;
            }
            while (!Thread.currentThread().isInterrupted()) {
                if (this.listener.needsKill()) {
                    this.process.destroy();
                    ExecRunnerBase.this.wasKilled = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void waitFor() {
            this.runner.interrupt();
            try {
                this.runner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected abstract class OutputStreamListener
    implements Runnable {
        private final Thread runnerThread;
        private final InputStream stream;
        protected final ExecRunnerListener listener;

        public OutputStreamListener(InputStream stream, ExecRunnerListener listener) {
            this.stream = stream;
            this.listener = listener;
            this.runnerThread = new Thread(this);
            this.runnerThread.start();
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.notifyListener(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void notifyListener(String var1);

        public void waitFor() throws InterruptedException {
            this.runnerThread.interrupt();
            this.runnerThread.join();
        }
    }

    protected class StderrStreamListener
    extends OutputStreamListener {
        public StderrStreamListener(InputStream stream, ExecRunnerListener listener) {
            super(stream, listener);
        }

        @Override
        protected void notifyListener(String line) {
            this.listener.stderr(line);
        }
    }

    protected class StdoutStreamListener
    extends OutputStreamListener {
        public StdoutStreamListener(InputStream stream, ExecRunnerListener listener) {
            super(stream, listener);
        }

        @Override
        protected void notifyListener(String line) {
            this.listener.stdout(line);
        }
    }

    public static interface ExecRunnerListener {
        public void stdout(String var1);

        public void stderr(String var1);
    }
}

