/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.File;
import java.io.IOException;
import org.moe.common.exec.AbstractExec;
import org.moe.common.exec.ExecOutputCollector;
import org.moe.common.exec.SimpleExec;
import org.moe.common.utils.OsUtils;

public class GradleExec
extends AbstractExec {
    private static String gradlew;
    private final File project;

    public GradleExec(File project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    public GradleExec(File project, String name, File workingDir) {
        super(name, workingDir);
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    @Override
    protected String lookupExec() {
        File gradleWPath = null;
        for (File path = this.project; gradleWPath == null && path != null; path = path.getParentFile()) {
            gradleWPath = this.getGradleW(path);
        }
        if (gradleWPath != null) {
            return gradleWPath.getAbsolutePath();
        }
        String out = this.getGradleFromWhich();
        if (out != null) {
            return out;
        }
        throw new RuntimeException("Failed to locate 'gradle' executable!");
    }

    private String getGradleFromWhich() {
        String out;
        SimpleExec whichExec = SimpleExec.getWhich("gradle");
        try {
            out = ExecOutputCollector.collect(whichExec).trim();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
            return null;
        }
        return out.length() == 0 ? null : out;
    }

    private File getGradleW(File path) {
        if ((path = new File(path, gradlew)).exists() && path.isFile()) {
            return path;
        }
        return null;
    }

    static {
        if (OsUtils.isMac()) {
            gradlew = "gradlew";
        } else if (OsUtils.isWindows()) {
            gradlew = "gradlew.bat";
        }
    }
}

