/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.exec;

import java.io.File;
import org.moe.common.exec.AbstractExec;
import org.moe.common.utils.OsUtils;

public class SimpleExec
extends AbstractExec {
    private static String lookupCommand;

    private SimpleExec(String name) {
        super(name, null);
    }

    private SimpleExec(String name, File workingDir) {
        super(name, workingDir);
    }

    @Override
    protected String lookupExec() {
        return null;
    }

    public static SimpleExec getExec(String name) {
        return new SimpleExec(name);
    }

    public static SimpleExec getExec(String name, File workingDir) {
        return new SimpleExec(name, workingDir);
    }

    public static SimpleExec getXcodeSelect() {
        return SimpleExec.getExec("xcode-select");
    }

    public static SimpleExec getOpen(String app, String file) {
        SimpleExec exec = SimpleExec.getExec("open");
        if (app != null) {
            exec.getArguments().add("-a");
            exec.getArguments().add(app);
        }
        if (file != null) {
            exec.getArguments().add(file);
        }
        return exec;
    }

    public static SimpleExec getWhich(String app) {
        SimpleExec exec = SimpleExec.getExec(lookupCommand);
        if (app != null) {
            exec.getArguments().add(app);
        }
        return exec;
    }

    public static SimpleExec getRevealInFinder(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        SimpleExec exec = SimpleExec.getExec("osascript");
        exec.getArguments().add("-e");
        exec.getArguments().add("tell application \"Finder\" to reveal POSIX file \"" + path + "\" activate");
        return exec;
    }

    static {
        if (OsUtils.isMac()) {
            lookupCommand = "which";
        } else if (OsUtils.isWindows()) {
            lookupCommand = "where";
        }
    }
}

