/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.ios;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.moe.common.exec.ExecOutputCollector;
import org.moe.common.exec.GradleExec;
import org.moe.common.ios.DeviceInfo;

public class Device {
    public static List<DeviceInfo> getDevices(File projectFile) throws IOException {
        String[] lines;
        String output;
        ArrayList<DeviceInfo> result = new ArrayList<DeviceInfo>();
        if (projectFile == null) {
            return result;
        }
        GradleExec exec = new GradleExec(projectFile, null, projectFile);
        exec.getArguments().add("moeListDevices");
        exec.getArguments().add("-Dorg.gradle.daemon=true");
        exec.getArguments().add("-Dorg.gradle.configureondemand=true");
        try {
            output = ExecOutputCollector.collect(exec);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        for (String line : lines = output.split("\n")) {
            DeviceInfo device = Device.parseDeviceInfo(line);
            if (device == null) continue;
            result.add(device);
        }
        return result;
    }

    private static DeviceInfo parseDeviceInfo(String line) {
        DeviceInfo device = null;
        String devicePattern = "^\\-\\s(.*)$";
        Pattern pattern = Pattern.compile(devicePattern);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String name = "iOS Device";
        String uuid = matcher.group(1);
        device = new DeviceInfo(name, uuid);
        return device;
    }
}

