/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.junit;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.moe.common.junit.MOEITestRunListener;
import org.moe.common.junit.MOETestIdentifier;

public class MOETestResultParser {
    private MOEITestRunListener listener;
    public static final String TEST_IGNORED = "%IGNORED";
    public static final String TEST_RUN_DEFINE = "%TESTD  ";
    private String mUnfinishedLine = null;
    private final ArrayList<String> mArray = new ArrayList();
    private boolean mTrimLines = true;
    StringBuffer errorBuffer;
    MOETestIdentifier failTest = null;

    public MOETestResultParser(MOEITestRunListener l) {
        this.listener = l;
        this.errorBuffer = new StringBuffer();
        this.failTest = null;
    }

    public void addOutput(byte[] buffer, int i, int read) {
        try {
            this.addOutput(new String(buffer, 0, read, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.addOutput(new String(buffer, 0, read));
        }
    }

    public final void addOutput(String s) {
        if (!this.isCancelled() && s != null) {
            if (this.mUnfinishedLine != null) {
                s = this.mUnfinishedLine + s;
                this.mUnfinishedLine = null;
            }
            this.mArray.clear();
            int start = 0;
            while (true) {
                int index;
                if ((index = s.indexOf("\n", start)) == -1) break;
                String line = s.substring(start, index);
                if (this.mTrimLines) {
                    line = line.trim();
                }
                this.mArray.add(line);
                start = index + 1;
            }
            this.mUnfinishedLine = s.substring(start);
            if (this.mArray.size() > 0) {
                String[] lines = this.mArray.toArray(new String[this.mArray.size()]);
                this.processNewLines(lines);
            }
        }
    }

    private boolean isCancelled() {
        return false;
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.parse(this.normalizeLine(line));
        }
    }

    private void parse(String line) {
        if (line.startsWith("%TESTC  ")) {
            String num = line.substring(9, line.length());
            int testCount = Integer.valueOf(num);
            this.listener.testRunStarted("", testCount);
        } else if (line.startsWith("%TESTS  ")) {
            String test = line.substring(9, line.length());
            String testClass = test.substring(0, test.indexOf("-"));
            String testMethod = test.substring(test.indexOf("-") + 1, test.length());
            this.listener.testStarted(new MOETestIdentifier(testClass, testMethod));
        } else if (line.startsWith("%TESTE  ")) {
            if (this.failTest != null) {
                this.listener.testFailed(this.failTest, this.errorBuffer.toString());
                this.errorBuffer = new StringBuffer();
                this.failTest = null;
            }
            String test = line.substring(9, line.length());
            String testClass = test.substring(0, test.indexOf("-"));
            String testMethod = test.substring(test.indexOf("-") + 1, test.length());
            HashMap<String, String> runMetrics = new HashMap<String, String>();
            this.listener.testEnded(new MOETestIdentifier(testClass, testMethod), runMetrics);
        } else if (line.startsWith("%FAILED ")) {
            String test = line.substring(9, line.length());
            String testMethod = test.substring(0, test.indexOf("("));
            String testClass = test.substring(test.indexOf("(") + 1, test.indexOf(")"));
            String errorMsg = test.substring(test.indexOf(":") + 1, test.length());
            this.errorBuffer.append(errorMsg);
            this.failTest = new MOETestIdentifier(testClass, testMethod);
        } else if (line.startsWith("%RUNTIME")) {
            if (this.failTest != null) {
                this.listener.testFailed(this.failTest, this.errorBuffer.toString());
                this.errorBuffer = new StringBuffer();
                this.failTest = null;
            }
            String time = line.substring(9, line.length());
            HashMap<String, String> runMetrics = new HashMap<String, String>();
            this.listener.testRunEnded(Integer.valueOf(time).intValue(), runMetrics);
        } else if (line.startsWith(TEST_IGNORED)) {
            String test = line.substring(9, line.length());
            String testClass = test.substring(0, test.indexOf("-"));
            String testMethod = test.substring(test.indexOf("-") + 1, test.length());
            MOETestIdentifier ignoredTest = new MOETestIdentifier(testClass, testMethod);
            ignoredTest.setIgnored(true);
            this.listener.testStarted(ignoredTest);
            this.listener.testIgnored(ignoredTest);
        } else if (line.startsWith(TEST_RUN_DEFINE)) {
            String test = line.substring(9, line.length());
            String testClass = test.substring(0, test.indexOf("-"));
            String testMethod = test.substring(test.indexOf("-") + 1, test.length());
            this.listener.testDefined(new MOETestIdentifier(testClass, testMethod));
        } else if (this.failTest != null) {
            this.errorBuffer.append("\n");
            this.errorBuffer.append(line);
        }
    }

    private String normalizeLine(String s) {
        int index = 0;
        index = s.indexOf("%TESTC  ");
        if (index > 0) {
            s = s.substring(index, s.length());
        } else {
            index = s.indexOf("%TESTS  ");
            if (index > 0) {
                s = s.substring(index, s.length());
            } else {
                index = s.indexOf("%TESTE  ");
                if (index > 0) {
                    s = s.substring(index, s.length());
                } else {
                    index = s.indexOf("%FAILED ");
                    if (index > 0) {
                        s = s.substring(index, s.length());
                    } else {
                        index = s.indexOf("%RUNTIME");
                        if (index > 0) {
                            s = s.substring(index, s.length());
                        } else {
                            index = s.indexOf(TEST_IGNORED);
                            if (index > 0) {
                                s = s.substring(index, s.length());
                            } else {
                                index = s.indexOf(TEST_RUN_DEFINE);
                                if (index > 0) {
                                    s = s.substring(index, s.length());
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    public class MessageIds {
        public static final int MSG_HEADER_LENGTH = 8;
        public static final String TEST_RUN_START = "%TESTC  ";
        public static final String TEST_DEFINE = "%TESTD  ";
        public static final String TEST_START = "%TESTS  ";
        public static final String TEST_END = "%TESTE  ";
        public static final String TEST_ERROR = "%ERROR  ";
        public static final String TEST_FAILED = "%FAILED ";
        public static final String TEST_IGNORED = "%IGNORED";
        public static final String TEST_RUN_END = "%RUNTIME";
    }
}

