/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.macho;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MachoFile {
    public static final String CPU_NAME_ARM = "arm";
    public static final String CPU_NAME_ARM64 = "arm64";
    public static final String CPU_NAME_I386 = "i386";
    public static final String CPU_NAME_X86_64 = "x86_64";
    private static final int CPU_ARCH_ABI64 = 0x1000000;
    private static final int CPU_TYPE_ARM = 12;
    private static final int CPU_TYPE_ARM64 = 0x100000C;
    private static final int CPU_TYPE_I386 = 7;
    private static final int CPU_TYPE_X86_64 = 0x1000007;
    private final ArrayList<String> cpuTypes;

    private MachoFile(InputStream input) throws IOException {
        block9: {
            this.cpuTypes = new ArrayList();
            if (input == null) {
                throw new NullPointerException();
            }
            try (DataInputStream dis = new DataInputStream(input);){
                int magic = dis.readInt();
                if (magic == -889275714) {
                    this.readFromFat(dis);
                    break block9;
                }
                if (magic == MachoFile.swap(-17958194)) {
                    this.readFrom32(dis);
                    break block9;
                }
                if (magic == MachoFile.swap(-17958193)) {
                    this.readFrom64(dis);
                    break block9;
                }
                throw new IOException("Invalid magic");
            }
        }
    }

    public static List<String> getRecognizedCPUTypes(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("bad file");
        }
        return MachoFile.getRecognizedCPUTypes(new FileInputStream(file));
    }

    public static List<String> getRecognizedCPUTypes(InputStream stream) throws IOException {
        MachoFile machoFile = new MachoFile(stream);
        return new ArrayList<String>(machoFile.cpuTypes);
    }

    private void readFrom64(DataInputStream dis) throws IOException {
        int cpuType = dis.readInt();
        this.appendCPUType(MachoFile.swap(cpuType));
    }

    private void readFrom32(DataInputStream dis) throws IOException {
        int cpuType = dis.readInt();
        this.appendCPUType(MachoFile.swap(cpuType));
    }

    private void readFromFat(DataInputStream dis) throws IOException {
        int num = dis.readInt();
        for (int i = 0; i < num; ++i) {
            int cpuType = dis.readInt();
            this.appendCPUType(cpuType);
            if (dis.skip(16L) == 16L) continue;
            throw new IOException("Failed to skip 16 bytes");
        }
    }

    private void appendCPUType(int cpuType) {
        String name = MachoFile.getCPUName(cpuType);
        if (name != null) {
            this.cpuTypes.add(name);
        }
    }

    public static String getCPUName(int cpuType) {
        switch (cpuType) {
            case 12: {
                return CPU_NAME_ARM;
            }
            case 0x100000C: {
                return CPU_NAME_ARM64;
            }
            case 7: {
                return CPU_NAME_I386;
            }
            case 0x1000007: {
                return CPU_NAME_X86_64;
            }
        }
        return null;
    }

    public static int swap(int value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }
}

