/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T[] concatenate(T[] a, T[] b) {
        if (a == null && b == null) {
            return null;
        }
        if (b == null) {
            return (Object[])a.clone();
        }
        if (a == null) {
            return (Object[])b.clone();
        }
        int aLen = a.length;
        int bLen = b.length;
        Class<?> at = a.getClass().getComponentType();
        Object[] c = (Object[])Array.newInstance(at, aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static <T> boolean contains(T[] array, T value) {
        if (array == null) {
            return false;
        }
        for (T elem : array) {
            if (elem == null && value == null) {
                return true;
            }
            if (elem == null || !elem.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCaseInsensitive(String[] array, String value) {
        if (array == null) {
            return false;
        }
        for (String elem : array) {
            if (elem == null && value == null) {
                return true;
            }
            if (elem == null || !elem.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> String join(T[] values2, String separator) {
        if (values2 == null) {
            return null;
        }
        return ArrayUtil.join(Arrays.asList(values2), separator);
    }

    public static <T> String join(List<T> values2, String separator) {
        if (values2 == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values2.size(); ++i) {
            builder.append(values2.get(i));
            if (i + 1 >= values2.size()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }
}

