/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JavaUtil {
    private static final Set<String> KEYWORDS_BOOLLITERALS_NULLLITERAL = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null")));

    public static boolean isValidJavaPackage(String value) {
        String[] components;
        if (value == null) {
            throw new NullPointerException();
        }
        for (String component : components = value.split("\\.")) {
            int codepoint;
            int length = component.length();
            if (length == 0) {
                return false;
            }
            for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
                codepoint = component.codePointAt(offset);
                if (!(offset == 0 ? !Character.isJavaIdentifierStart(codepoint) : !Character.isJavaIdentifierPart(codepoint))) continue;
                return false;
            }
            if (!KEYWORDS_BOOLLITERALS_NULLLITERAL.contains(component)) continue;
            return false;
        }
        return true;
    }
}

