/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.moe.common.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeUtil {
    public static Class<?> LOADER_CLASS = NativeUtil.class;
    public static final String OS_NAME_MAC_OS_X = "Mac OS X";
    public static final String OS_NAME_WINDOWS = "Windows";
    public static final String OS_ARCH_X86_64 = "x86_64";
    private static final String[] OS_ARCH_X86_64_SYNS = new String[]{"x86_64", "amd64"};
    private static final Logger LOG = LoggerFactory.getLogger(NativeUtil.class);
    private static final ArrayList<ArchSpecLibs> registeredLibs = new ArrayList();
    private static boolean libsArePrepared = false;
    private static File temporaryDirectory = null;

    private NativeUtil() {
    }

    public static boolean initialize() {
        return NativeUtil.prepareNativeLibraries();
    }

    public static synchronized boolean isInitialized() {
        return libsArePrepared;
    }

    public static synchronized void register(String osName, String osArch, NativeLib[] nativeLibs, NativeLib[] preloadedNativeLibs) {
        if (NativeUtil.isInitialized()) {
            throw new IllegalStateException("already initialized");
        }
        if (osName == null || osArch == null) {
            throw new NullPointerException();
        }
        if (nativeLibs == null) {
            nativeLibs = new NativeLib[]{};
        }
        if (preloadedNativeLibs == null) {
            preloadedNativeLibs = new NativeLib[]{};
        }
        ArchSpecLibs spec = NativeUtil.getArchSpec(osName, osArch);
        spec.nativeLibs.addAll(Arrays.asList(nativeLibs));
        spec.preloadedNativeLibs.addAll(Arrays.asList(preloadedNativeLibs));
        registeredLibs.add(spec);
    }

    private static ArchSpecLibs getArchSpec(String osName, String osArch) {
        for (ArchSpecLibs lib : registeredLibs) {
            if (!lib.matches(osName, osArch)) continue;
            return lib;
        }
        return new ArchSpecLibs(new String[]{osName}, new String[]{osArch});
    }

    private static synchronized File getTempDir() {
        if (temporaryDirectory == null) {
            try {
                temporaryDirectory = File.createTempFile("temp", ".moe");
                if (!temporaryDirectory.delete()) {
                    LOG.error("Failed to remove temp file " + temporaryDirectory.getAbsolutePath());
                    return null;
                }
                if (!temporaryDirectory.mkdir()) {
                    LOG.error("Failed to create temp dir " + temporaryDirectory.getAbsolutePath());
                    return null;
                }
                temporaryDirectory.deleteOnExit();
            }
            catch (IOException e) {
                LOG.error("Failed to create temp dir for libraries.", e);
                return null;
            }
            String path_value = System.getProperty("java.library.path");
            if (path_value == null || path_value.length() == 0) {
                System.setProperty("java.library.path", temporaryDirectory.getAbsolutePath());
            } else {
                System.setProperty("java.library.path", temporaryDirectory.getAbsolutePath() + File.pathSeparator + path_value);
            }
        }
        return temporaryDirectory;
    }

    public static String getUnifiedSystemName() {
        String os_name = System.getProperty("os.name");
        if (!OS_NAME_WINDOWS.equals(os_name) && os_name.toLowerCase().contains(OS_NAME_WINDOWS.toLowerCase())) {
            os_name = OS_NAME_WINDOWS;
        }
        return os_name;
    }

    private static String getUnifiedArchitecture() {
        String os_arch = System.getProperty("os.arch");
        if (ArrayUtil.containsCaseInsensitive(OS_ARCH_X86_64_SYNS, os_arch)) {
            os_arch = OS_ARCH_X86_64;
        }
        return os_arch;
    }

    private static synchronized boolean prepareNativeLibraries() {
        if (!libsArePrepared) {
            String os_name = NativeUtil.getUnifiedSystemName();
            String os_arch = NativeUtil.getUnifiedArchitecture();
            ArchSpecLibs spec = NativeUtil.getArchSpec(os_name, os_arch);
            List<NativeLib> natives = spec.nativeLibs;
            List<NativeLib> natives_preload = spec.preloadedNativeLibs;
            if (natives.size() == 0 && natives_preload.size() == 0) {
                LOG.error("This OS/architecture is not supported! (" + os_name + "/" + os_arch + ")");
                return false;
            }
            File temp = NativeUtil.getTempDir();
            if (temp == null) {
                LOG.error("Failed to get temp directory");
                return false;
            }
            try {
                NativeUtil.copyToTemp(natives, temp);
            }
            catch (IOException e) {
                LOG.error("Failed to copy native libraries", e);
                return false;
            }
            try {
                NativeUtil.copyToTemp(natives_preload, temp);
            }
            catch (IOException e) {
                LOG.error("Failed to copy native libraries", e);
                return false;
            }
            NativeUtil.preload(natives_preload, temp);
            libsArePrepared = true;
        }
        return true;
    }

    private static void preload(List<NativeLib> natives, File temp) {
        for (NativeLib lib : natives) {
            String path = new File(temp, lib.getExternalName()).getAbsolutePath();
            System.load(path);
        }
    }

    private static void copyToTemp(List<NativeLib> natives, File temp) throws IOException {
        for (NativeLib lib : natives) {
            NativeUtil.copyToTemp(lib, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToTemp(NativeLib input, File temp) throws IOException {
        String inFilePath = input.getInternalPath();
        String outFileName = input.getExternalName();
        File of = new File(temp, outFileName);
        of.createNewFile();
        of.deleteOnExit();
        try (InputStream is = LOADER_CLASS.getResourceAsStream(inFilePath);
             FileOutputStream fos = new FileOutputStream(of);){
            int read;
            byte[] buffer = new byte[65536];
            while ((read = is.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        return of;
    }

    public static class NativeLib {
        final String internalPath;
        final String externalName;

        public NativeLib(String name) {
            this(name, null);
        }

        public NativeLib(String internalPath, String externalName) {
            if (internalPath == null) {
                throw new NullPointerException();
            }
            if (externalName == null) {
                externalName = new File(internalPath).getName();
            }
            this.internalPath = internalPath;
            this.externalName = externalName;
        }

        public String getInternalPath() {
            return this.internalPath;
        }

        public String getExternalName() {
            return this.externalName;
        }
    }

    private static class ArchSpecLibs {
        final List<NativeLib> nativeLibs;
        final List<NativeLib> preloadedNativeLibs;
        String[] osNames;
        String[] osArchitectures;

        private ArchSpecLibs(String[] osNames, String[] osArchs) {
            if (osNames == null || osArchs == null) {
                throw new NullPointerException();
            }
            this.osNames = osNames;
            this.osArchitectures = osArchs;
            this.nativeLibs = new ArrayList<NativeLib>();
            this.preloadedNativeLibs = new ArrayList<NativeLib>();
        }

        private boolean matches(String osName, String osArch) {
            return ArrayUtil.containsCaseInsensitive(this.osNames, osName) && ArrayUtil.containsCaseInsensitive(this.osArchitectures, osArch);
        }
    }
}

