/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.utils;

import java.io.File;

public class OsUtils {
    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return OsUtils.getOsName().startsWith("Windows");
    }

    public static boolean isMac() {
        return OsUtils.getOsName().startsWith("Mac");
    }

    public static String osNameAndVersion() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public static String concatenateToLocalPath(char[] ... args2) {
        StringBuffer buff = new StringBuffer(128);
        int cmp = args2.length - 1;
        for (int i = 0; i < args2.length; ++i) {
            char[] arg = args2[i];
            if (arg == null) continue;
            char lastChar = arg[arg.length - 1];
            if (lastChar == File.separatorChar) {
                buff.append(arg);
                continue;
            }
            if (lastChar == '/' || lastChar == '\\') {
                buff.append(arg, 0, arg.length - 1);
                buff.append(File.separatorChar);
                continue;
            }
            buff.append(arg);
            if (i == cmp) continue;
            buff.append(File.separatorChar);
        }
        return buff.toString();
    }

    public static String concatenateToLocalPath(String ... args2) {
        char[][] chArgs = new char[args2.length][];
        int i = 0;
        for (String arg : args2) {
            if (arg == null) continue;
            chArgs[i++] = arg.toCharArray();
        }
        return OsUtils.concatenateToLocalPath(chArgs);
    }
}

