/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.moe.common.ShutdownManager;
import org.moe.common.utils.CloseableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtil.class);
    private int localPort;
    private InputStream remoteOutput;
    private OutputStream remoteInput;
    private ServerSocket server;
    private final Lock serverLock = new ReentrantLock();
    private final Condition serverEnded = this.serverLock.newCondition();
    private Socket socket;
    private InputStream socketInput;
    private OutputStream socketOutput;
    private Thread proxyThread;
    private Thread local2remoteThread;
    private Thread remote2localThread;
    private boolean hasShutdownHookRegistered;

    private ProxyUtil(int localPort, InputStream remoteOutput, OutputStream remoteInput) {
        if (remoteOutput == null || remoteInput == null) {
            throw new IllegalArgumentException();
        }
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("Illegal port");
        }
        this.localPort = localPort;
        this.remoteOutput = remoteOutput;
        this.remoteInput = remoteInput;
    }

    public static ProxyUtil create(int localPort, InputStream remoteOutput, OutputStream remoteInput) {
        ProxyUtil proxy = new ProxyUtil(localPort, remoteOutput, remoteInput);
        proxy.start();
        return proxy;
    }

    private void start() {
        LOG.debug(this.localPort + ": Creating proxy server");
        this.proxyThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProxyUtil.this.server = new ServerSocket(ProxyUtil.this.localPort);
                }
                catch (IOException e) {
                    LOG.error(ProxyUtil.this.localPort + ": Creating server socket failed");
                    return;
                }
                this.accept();
                ProxyUtil.this.tryClose(ProxyUtil.this.server, "Closing server failed");
                if (ProxyUtil.this.local2remoteThread != null) {
                    try {
                        ProxyUtil.this.local2remoteThread.join();
                    }
                    catch (InterruptedException e) {
                        LOG.error(ProxyUtil.this.localPort + ": Joining local2remoteThread failed");
                    }
                }
                if (ProxyUtil.this.remote2localThread != null) {
                    try {
                        ProxyUtil.this.remote2localThread.join();
                    }
                    catch (InterruptedException e) {
                        LOG.error(ProxyUtil.this.localPort + ": Joining remote2localThread failed");
                    }
                }
            }

            private void accept() {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    ProxyUtil.this.socket = ProxyUtil.this.server.accept();
                    ProxyUtil.this.socketInput = ProxyUtil.this.socket.getInputStream();
                    ProxyUtil.this.socketOutput = ProxyUtil.this.socket.getOutputStream();
                }
                catch (IOException e) {
                    if (!Thread.currentThread().isInterrupted()) {
                        LOG.error(ProxyUtil.this.localPort + ": Server accept failed");
                    } else {
                        LOG.debug(ProxyUtil.this.localPort + ": Server accept interrupted");
                    }
                    return;
                }
                LOG.debug(ProxyUtil.this.localPort + ": Accepted connection");
                this.startup();
                ProxyUtil.this.tryClose(ProxyUtil.this.socket, "Closing socket failed");
                ProxyUtil.this.tryClose(ProxyUtil.this.socketInput, "Closing socket input stream");
                ProxyUtil.this.tryClose(ProxyUtil.this.socketOutput, "Closing socket output stream");
            }

            private void startup() {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ProxyUtil.this.local2remoteThread = this.createForwardingThread("local2remoteThread", ProxyUtil.this.socketInput, ProxyUtil.this.remoteInput);
                ProxyUtil.this.remote2localThread = this.createForwardingThread("remote2localThread", ProxyUtil.this.remoteOutput, ProxyUtil.this.socketOutput);
                LOG.debug(ProxyUtil.this.localPort + ": Starting forwarding");
                ProxyUtil.this.local2remoteThread.start();
                ProxyUtil.this.remote2localThread.start();
                ProxyUtil.this.serverLock.lock();
                try {
                    try {
                        ProxyUtil.this.serverEnded.await();
                    }
                    catch (InterruptedException e) {
                        LOG.debug(ProxyUtil.this.localPort + ": Proxy server was interrupted");
                    }
                }
                finally {
                    ProxyUtil.this.serverLock.unlock();
                }
                ProxyUtil.this.tryClose(ProxyUtil.this.remoteInput, "Closing remote input failed");
                ProxyUtil.this.tryClose(ProxyUtil.this.remoteOutput, "Closing remote output failed");
            }

            private Thread createForwardingThread(final String name, final InputStream is, final OutputStream os) {
                return new Thread(new Runnable(){
                    final int bufferSize = 16384;
                    final byte[] buffer = new byte[16384];

                    @Override
                    public void run() {
                        LOG.debug(ProxyUtil.this.localPort + ": Starting " + name);
                        while (!Thread.currentThread().isInterrupted()) {
                            try {
                                int count = is.read(this.buffer);
                                if (count == -1) break;
                                os.write(this.buffer, 0, count);
                            }
                            catch (IOException e) {
                                // empty catch block
                                break;
                            }
                        }
                        ProxyUtil.this.serverLock.lock();
                        try {
                            ProxyUtil.this.serverEnded.signal();
                        }
                        finally {
                            ProxyUtil.this.serverLock.unlock();
                        }
                    }
                });
            }
        });
        this.proxyThread.start();
    }

    private void tryClose(Closeable closeable, String failMessage) {
        if (closeable != null) {
            CloseableUtil.tryClose(closeable, LOG, this.localPort + ": " + failMessage);
        }
    }

    public synchronized void stop() {
        LOG.debug(this.localPort + ": Stopping proxy");
        this.tryClose(this.server, "Closing server failed");
        Thread.yield();
        this.tryClose(this.remoteOutput, "Closing remote output failed");
        this.tryClose(this.socketInput, "Closing remote input failed");
        Thread.yield();
        this.tryClose(this.socketOutput, "Closing remote output failed");
        this.tryClose(this.remoteInput, "Closing remote input failed");
        if (this.remote2localThread != null) {
            this.remote2localThread.interrupt();
        }
        if (this.local2remoteThread != null) {
            this.local2remoteThread.interrupt();
        }
        LOG.debug(this.localPort + ": Stopping proxy completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitFor() {
        LOG.debug(this.localPort + ": Waiting for proxy");
        this.proxyThread.interrupt();
        try {
            Thread thread2 = this.proxyThread;
            synchronized (thread2) {
                this.proxyThread.join(10000L);
            }
        }
        catch (InterruptedException e) {
            LOG.error(this.localPort + ": Proxy thread shut down interrupted");
        }
        LOG.debug(this.localPort + ": Proxy thread shut down");
    }

    public synchronized void registerShutdownHook() {
        if (!this.hasShutdownHookRegistered) {
            this.hasShutdownHookRegistered = true;
            ShutdownManager.register(new Runnable(){

                @Override
                public void run() {
                    ProxyUtil.this.stop();
                }
            });
            ShutdownManager.registerPost(new Runnable(){

                @Override
                public void run() {
                    ProxyUtil.this.waitFor();
                }
            });
        }
    }
}

