/*
 * Decompiled with CFR 0.152.
 */
package org.moe.common.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.moe.common.exec.ExecOutputCollector;
import org.moe.common.exec.SimpleExec;

public class SimCtl {
    private SimCtl() {
    }

    public static List<Device> getDevices() throws IOException, InterruptedException {
        SimpleExec exec = SimpleExec.getExec("xcrun");
        exec.getArguments().addAll(Arrays.asList("simctl", "list", "-j", "runtimes", "devices"));
        String json = ExecOutputCollector.collect(exec);
        JsonObject root = new JsonParser().parse(json).getAsJsonObject();
        HashMap<String, String> runtimesNI = new HashMap<String, String>();
        HashMap<String, String> runtimesIN = new HashMap<String, String>();
        String platformDisplayName = "ios";
        for (JsonElement _runtime : root.getAsJsonArray("runtimes")) {
            String identifier;
            String lastcomp;
            JsonObject runtime = _runtime.getAsJsonObject();
            if (!SimCtl.isAvailable(runtime) || !(lastcomp = (identifier = runtime.get("identifier").getAsString()).substring(identifier.lastIndexOf(46) + 1)).toLowerCase().startsWith("ios")) continue;
            String name = runtime.get("name").getAsString();
            runtimesNI.put(name, identifier);
            runtimesIN.put(identifier, name);
        }
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Map.Entry<String, JsonElement> e : root.getAsJsonObject("devices").entrySet()) {
            if (!runtimesIN.containsKey(e.getKey()) && !runtimesNI.containsKey(e.getKey())) continue;
            for (JsonElement _x : e.getValue().getAsJsonArray()) {
                Pair<String, JsonObject> x = new Pair<String, JsonObject>(e.getKey(), _x.getAsJsonObject());
                if (!SimCtl.isAvailable((JsonObject)x.right)) continue;
                String key = (String)x.left;
                String runtime = runtimesIN.containsKey(key) ? (String)runtimesIN.get(key) : key;
                JsonObject value = (JsonObject)x.right;
                devices.add(new Device(value.get("name").getAsString(), value.get("udid").getAsString(), runtime, value.get("state").getAsString()));
            }
        }
        return devices;
    }

    private static boolean isAvailable(JsonObject node) {
        boolean available = false;
        if (node.has("isAvailable")) {
            available = node.get("isAvailable").getAsBoolean();
        } else if (node.has("availability")) {
            available = node.get("availability").getAsString().equals("(available)");
        }
        return available;
    }

    public static class Device {
        public final String name;
        public final String udid;
        public final String runtime;
        public final String state;

        Device(String name, String udid, String runtime, String state) {
            this.name = name;
            this.udid = udid;
            this.runtime = runtime;
            this.state = state;
        }

        public String toString() {
            return this.udid + " - " + this.runtime + " - " + this.name + " - " + this.state;
        }
    }

    private static class Pair<L, R> {
        final L left;
        final R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }
    }
}

