/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device;

import org.libimobiledevice.c.Globals;
import org.libimobiledevice.opaque.debugserver_client_t;
import org.libimobiledevice.opaque.idevice_connection_t;
import org.moe.ios.device.ConnectionInputStream;
import org.moe.ios.device.ConnectionLock;
import org.moe.ios.device.ConnectionOutputStream;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.IntPtr;

public class ConnectionHelper {
    private ConnectionHelper() {
    }

    public static ConnectionInputStream<debugserver_client_t> getInputStream(debugserver_client_t client, final ConnectionLock usageLock) {
        if (client == null) {
            throw new NullPointerException();
        }
        return new ConnectionInputStream<debugserver_client_t>(client){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected int recvImpl(debugserver_client_t handle, BytePtr buffer, int len, IntPtr recvBytes, int timeout) {
                try {
                    if (usageLock.lockGetClosed()) {
                        int n = -1;
                        return n;
                    }
                    int result = Globals.debugserver_client_receive_with_timeout(handle, buffer, len, recvBytes, timeout);
                    if (result == -5) {
                        result = 0;
                    }
                    int n = result;
                    return n;
                }
                finally {
                    usageLock.unlock();
                }
            }
        };
    }

    public static ConnectionOutputStream<debugserver_client_t> getOutputStream(debugserver_client_t client, final ConnectionLock usageLock) {
        if (client == null) {
            throw new NullPointerException();
        }
        return new ConnectionOutputStream<debugserver_client_t>(client){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected int sendImpl(debugserver_client_t handle, BytePtr buffer, int len, IntPtr sentBytes) {
                try {
                    if (usageLock.lockGetClosed()) {
                        int n = -1;
                        return n;
                    }
                    int n = Globals.debugserver_client_send(handle, buffer, len, sentBytes);
                    return n;
                }
                finally {
                    usageLock.unlock();
                }
            }
        };
    }

    public static ConnectionInputStream<idevice_connection_t> getInputStream(idevice_connection_t connection, final ConnectionLock usageLock) {
        if (connection == null) {
            throw new NullPointerException();
        }
        return new ConnectionInputStream<idevice_connection_t>(connection){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected int recvImpl(idevice_connection_t handle, BytePtr buffer, int len, IntPtr recvBytes, int timeout) {
                try {
                    if (usageLock.lockGetClosed()) {
                        int n = -1;
                        return n;
                    }
                    int result = Globals.idevice_connection_receive_timeout(handle, buffer, len, recvBytes, timeout);
                    if (result == -7) {
                        result = 0;
                    }
                    int n = result;
                    return n;
                }
                finally {
                    usageLock.unlock();
                }
            }
        };
    }

    public static ConnectionOutputStream<idevice_connection_t> getOutputStream(idevice_connection_t connection, final ConnectionLock usageLock) {
        if (connection == null) {
            throw new NullPointerException();
        }
        return new ConnectionOutputStream<idevice_connection_t>(connection){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected int sendImpl(idevice_connection_t handle, BytePtr buffer, int len, IntPtr sentBytes) {
                try {
                    if (usageLock.lockGetClosed()) {
                        int n = -1;
                        return n;
                    }
                    int n = Globals.idevice_connection_send(handle, buffer, len, sentBytes);
                    return n;
                }
                finally {
                    usageLock.unlock();
                }
            }
        };
    }
}

