/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device;

import java.io.IOException;
import java.io.InputStream;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.impl.PtrFactory;

public abstract class ConnectionInputStream<T>
extends InputStream {
    private static final int BUFFER_SIZE = 0x100000;
    private final int bufferSize = 0x100000;
    private final BytePtr buffer = PtrFactory.newByteArray(0x100000);
    private final T handle;
    private final Object bufferLock = new Object();
    private final Object closeLock = new Object();
    private boolean isClosed = false;

    public ConnectionInputStream(T handle) {
        this.handle = handle;
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        int result = this.read(data, 0, 1);
        return result == -1 ? -1 : data[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._isClosed()) {
            return -1;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            BytePtr buffer = len <= 0x100000 ? this.buffer : PtrFactory.newByteArray(len);
            IntPtr recv_bytes = PtrFactory.newIntReference(0);
            do {
                int err;
                if ((err = this.recvImpl(this.handle, buffer, len, recv_bytes, 50)) == 0) continue;
                throw new IOException("failed to recv (" + err + ")");
            } while (!this._isClosed() && recv_bytes.getValue() == 0);
            if (this._isClosed()) {
                return -1;
            }
            buffer.copyTo(0, b, off, len);
            return recv_bytes.getValue();
        }
    }

    protected abstract int recvImpl(T var1, BytePtr var2, int var3, IntPtr var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            this.isClosed = true;
        }
    }
}

