/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device;

import java.io.IOException;
import java.io.OutputStream;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.impl.PtrFactory;

public abstract class ConnectionOutputStream<T>
extends OutputStream {
    private static final int BUFFER_SIZE = 0x100000;
    private final int bufferSize = 0x100000;
    private final BytePtr buffer = PtrFactory.newByteArray(0x100000);
    private final T handle;
    private final Object bufferLock = new Object();
    private final Object closeLock = new Object();
    private boolean isClosed = false;

    public ConnectionOutputStream(T handle) {
        this.handle = handle;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._isClosed()) {
            throw new IOException("stream is closed");
        }
        Object object = this.bufferLock;
        synchronized (object) {
            int err;
            BytePtr buffer = len <= 0x100000 ? this.buffer : PtrFactory.newByteArray(len);
            buffer.copyFrom(b, off, 0, len);
            IntPtr sent_bytes = PtrFactory.newIntReference();
            Object object2 = this.closeLock;
            synchronized (object2) {
                if (this._isClosed()) {
                    throw new IOException("stream is closed");
                }
                err = this.sendImpl(this.handle, buffer, len, sent_bytes);
            }
            if (err != 0) {
                if (this._isClosed()) {
                    throw new IOException("stream is closed");
                }
                throw new IOException("failed to send (" + err + ")");
            }
            if (len != sent_bytes.getValue()) {
                if (this._isClosed()) {
                    throw new IOException("stream is closed");
                }
                throw new IOException("idevice_connection_send failed, sent " + sent_bytes.getValue() + " bytes instead of " + len);
            }
        }
    }

    protected abstract int sendImpl(T var1, BytePtr var2, int var3, IntPtr var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            this.isClosed = true;
        }
    }
}

