/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.moe.common.Port;
import org.moe.common.ProxyPort;
import org.moe.common.configuration.AbstractConfiguration;
import org.moe.common.configuration.ConfigurationValidationException;
import org.moe.common.utils.ArrayUtil;

public class Configuration
extends AbstractConfiguration {
    public static final String DEVICE_UDID_PROPERTY_NAME = "Device UDID";
    public static final String APPLICATION_PATH_PROPERTY_NAME = "Application Path";
    public static final String LIST_DEVICES_PROPERTY_NAME = "List Devices";
    public static final String WAIT_FOR_DEVICE_PROPERTY_NAME = "Wait for Device";
    public static final String ADD_LAUNCH_ARG_PROPERTY_NAME = "Add Launch Argument";
    public static final String ADD_ENV_VAR_PROPERTY_NAME = "Add Env Variable";
    public static final String ADD_PROXY_PORT_PROPERTY_NAME = "Add Proxy Port";
    public static final String JDWP_PORT_PROPERTY_NAME = "JDWP Port";
    public static final String NATIVE_DEBUG_PORT_PROPERTY_NAME = "debugserver Port";
    public static final String INSTALL_MODE_PROPERTY_NAME = "Install Mode";
    public static final String STD_OUT_PROPERTY_NAME = "STD Out";
    public static final String STD_OUT_FILE_PROPERTY_NAME = "STD Out File";
    public static final String INSTALL_MODE_RUN_ONLY = "runonly";
    public static final String INSTALL_MODE_INSTALL_ONLY = "installonly";
    public static final String INSTALL_MODE_UPGRADE_ONLY = "upgradeonly";
    public static final String INSTALL_MODE_INSTALL = "install";
    public static final String INSTALL_MODE_UPGRADE = "upgrade";
    private String installMode = "upgrade";
    public static final String[] INSTALL_MODES = new String[]{"runonly", "install", "upgrade", "installonly", "upgradeonly"};
    private final ArrayList<String> launchArgs = new ArrayList();
    private final HashMap<String, String> envVars = new HashMap();
    private final ArrayList<ProxyPort> proxyPorts = new ArrayList();
    private String deviceUDID;
    private File applicationPath;
    private boolean listDevices;
    private boolean waitForDevice;
    private ProxyPort jdwpPort;
    private Port stdOutPort;
    private File stdOutFile;
    private ProxyPort debugserverPort = null;

    public String getDeviceUDID() {
        return this.deviceUDID;
    }

    public void setDeviceUDID(String deviceUDID) {
        this.requireOpen();
        this.deviceUDID = deviceUDID;
    }

    public File getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(File applicationPath) {
        this.requireOpen();
        this.applicationPath = applicationPath;
    }

    public boolean getListDevices() {
        return this.listDevices;
    }

    public void setListDevices(boolean listDevices) {
        this.requireOpen();
        this.listDevices = listDevices;
    }

    public boolean getWaitForDevice() {
        return this.waitForDevice;
    }

    public void setWaitForDevice(boolean waitForDevice) {
        this.requireOpen();
        this.waitForDevice = waitForDevice;
    }

    public ArrayList<String> getLaunchArgs() {
        return new ArrayList<String>(this.launchArgs);
    }

    public void addLaunchArg(String arg) {
        this.requireOpen();
        this.launchArgs.add(arg);
    }

    public HashMap<String, String> getEnvVars() {
        return new HashMap<String, String>(this.envVars);
    }

    public void addEnvVar(String key, String value) {
        this.requireOpen();
        this.envVars.put(key, value);
    }

    public ArrayList<ProxyPort> getProxyPorts() {
        return new ArrayList<ProxyPort>(this.proxyPorts);
    }

    public void addProxyPort(ProxyPort proxyPort) {
        this.requireOpen();
        this.proxyPorts.add(proxyPort);
    }

    public ProxyPort getJdwpPort() {
        return this.jdwpPort;
    }

    public void setJdwpPort(ProxyPort jdwpPort) {
        this.requireOpen();
        this.jdwpPort = jdwpPort;
    }

    public ProxyPort getDebugserverPort() {
        return this.debugserverPort;
    }

    public void setDebugserverPort(ProxyPort debugserverPort) {
        this.requireOpen();
        this.debugserverPort = debugserverPort;
    }

    public String getInstallMode() {
        return this.installMode;
    }

    public void setInstallMode(String installMode) {
        this.requireOpen();
        this.installMode = installMode;
    }

    public Port getStdOutPort() {
        return this.stdOutPort;
    }

    public void setStdOutPort(Port stdOutPort) {
        this.requireOpen();
        this.stdOutPort = stdOutPort;
    }

    public File getStdOutFile() {
        return this.stdOutFile;
    }

    public void setStdOutFile(File stdOutFile) {
        this.stdOutFile = stdOutFile;
    }

    @Override
    public void validate() throws ConfigurationValidationException {
        if (this.getDeviceUDID() != null) {
            this.assertNotEmpty(DEVICE_UDID_PROPERTY_NAME, this.deviceUDID);
        }
        if (!this.getListDevices() && this.getJdwpPort() == null && this.getProxyPorts().size() == 0 && this.getDebugserverPort() == null) {
            this.assertNotNull(APPLICATION_PATH_PROPERTY_NAME, this.applicationPath);
        }
        this.assertDirectoryExists(APPLICATION_PATH_PROPERTY_NAME, this.applicationPath);
        this.assertNotNull(INSTALL_MODE_PROPERTY_NAME, this.installMode);
        this.assertValueIsOneOf(INSTALL_MODE_PROPERTY_NAME, this.installMode, INSTALL_MODES);
    }

    @Override
    public Object getProperty(String key) {
        if (DEVICE_UDID_PROPERTY_NAME.equals(key)) {
            return this.getDeviceUDID();
        }
        if (APPLICATION_PATH_PROPERTY_NAME.equals(key)) {
            return this.getApplicationPath();
        }
        if (LIST_DEVICES_PROPERTY_NAME.equals(key)) {
            return this.getListDevices();
        }
        if (WAIT_FOR_DEVICE_PROPERTY_NAME.equals(key)) {
            return this.getWaitForDevice();
        }
        if (ADD_LAUNCH_ARG_PROPERTY_NAME.equals(key)) {
            throw new IllegalArgumentException("write only arg");
        }
        if (ADD_ENV_VAR_PROPERTY_NAME.equals(key)) {
            throw new IllegalArgumentException("write only arg");
        }
        if (ADD_PROXY_PORT_PROPERTY_NAME.equals(key)) {
            throw new IllegalArgumentException("write only arg");
        }
        if (JDWP_PORT_PROPERTY_NAME.equals(key)) {
            return this.getJdwpPort();
        }
        if (NATIVE_DEBUG_PORT_PROPERTY_NAME.equals(key)) {
            return this.getDebugserverPort();
        }
        if (INSTALL_MODE_PROPERTY_NAME.equals(key)) {
            return this.getInstallMode();
        }
        if (STD_OUT_PROPERTY_NAME.equals(key)) {
            return this.getStdOutPort();
        }
        if (STD_OUT_FILE_PROPERTY_NAME.equals(key)) {
            return this.getStdOutFile();
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (DEVICE_UDID_PROPERTY_NAME.equals(key)) {
            this.setDeviceUDID((String)value);
        } else if (APPLICATION_PATH_PROPERTY_NAME.equals(key)) {
            this.setApplicationPath((File)value);
        } else if (LIST_DEVICES_PROPERTY_NAME.equals(key)) {
            this.setListDevices((Boolean)value);
        } else if (WAIT_FOR_DEVICE_PROPERTY_NAME.equals(key)) {
            this.setWaitForDevice((Boolean)value);
        } else if (ADD_LAUNCH_ARG_PROPERTY_NAME.equals(key)) {
            this.addLaunchArg((String)value);
        } else if (ADD_ENV_VAR_PROPERTY_NAME.equals(key)) {
            String kv = (String)value;
            int idx = kv.indexOf(61);
            if (idx == -1) {
                this.addEnvVar(kv, "");
            } else {
                this.addEnvVar(kv.substring(0, idx), kv.substring(idx + 1));
            }
        } else if (ADD_PROXY_PORT_PROPERTY_NAME.equals(key)) {
            this.addProxyPort((ProxyPort)value);
        } else if (JDWP_PORT_PROPERTY_NAME.equals(key)) {
            this.setJdwpPort((ProxyPort)value);
        } else if (NATIVE_DEBUG_PORT_PROPERTY_NAME.equals(key)) {
            this.setDebugserverPort((ProxyPort)value);
        } else if (INSTALL_MODE_PROPERTY_NAME.equals(key)) {
            this.setInstallMode((String)value);
        } else if (STD_OUT_PROPERTY_NAME.equals(key)) {
            this.setStdOutPort((Port)value);
        } else if (STD_OUT_FILE_PROPERTY_NAME.equals(key)) {
            this.setStdOutFile((File)value);
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public Class<?> getPropertyClass(String key) {
        if (DEVICE_UDID_PROPERTY_NAME.equals(key)) {
            return String.class;
        }
        if (APPLICATION_PATH_PROPERTY_NAME.equals(key)) {
            return File.class;
        }
        if (LIST_DEVICES_PROPERTY_NAME.equals(key)) {
            return Boolean.class;
        }
        if (WAIT_FOR_DEVICE_PROPERTY_NAME.equals(key)) {
            return Boolean.class;
        }
        if (ADD_LAUNCH_ARG_PROPERTY_NAME.equals(key)) {
            return String.class;
        }
        if (ADD_ENV_VAR_PROPERTY_NAME.equals(key)) {
            return String.class;
        }
        if (ADD_PROXY_PORT_PROPERTY_NAME.equals(key)) {
            return ProxyPort.class;
        }
        if (JDWP_PORT_PROPERTY_NAME.equals(key)) {
            return ProxyPort.class;
        }
        if (NATIVE_DEBUG_PORT_PROPERTY_NAME.equals(key)) {
            return ProxyPort.class;
        }
        if (INSTALL_MODE_PROPERTY_NAME.equals(key)) {
            return String.class;
        }
        if (STD_OUT_PROPERTY_NAME.equals(key)) {
            return Port.class;
        }
        if (STD_OUT_FILE_PROPERTY_NAME.equals(key)) {
            return File.class;
        }
        return super.getPropertyClass(key);
    }

    @Override
    public String[] getAllPropertyNames() {
        return ArrayUtil.concatenate(super.getAllPropertyNames(), new String[]{DEVICE_UDID_PROPERTY_NAME, APPLICATION_PATH_PROPERTY_NAME, LIST_DEVICES_PROPERTY_NAME, WAIT_FOR_DEVICE_PROPERTY_NAME, ADD_LAUNCH_ARG_PROPERTY_NAME, ADD_ENV_VAR_PROPERTY_NAME, ADD_PROXY_PORT_PROPERTY_NAME, JDWP_PORT_PROPERTY_NAME, NATIVE_DEBUG_PORT_PROPERTY_NAME, INSTALL_MODE_PROPERTY_NAME, STD_OUT_PROPERTY_NAME, STD_OUT_FILE_PROPERTY_NAME});
    }
}

