/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.libimobiledevice.c.Globals;
import org.libimobiledevice.opaque.debugserver_client_t;
import org.moe.common.ShutdownManager;
import org.moe.common.utils.CloseableUtil;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.impl.PtrFactory;

public class DebugserverProxy {
    private int localPort;
    private ServerSocket server;
    private final Lock serverLock = new ReentrantLock();
    private final Condition serverEnded = this.serverLock.newCondition();
    private Thread proxyThread;
    private Socket socket;
    private boolean hasShutdownHookRegistered;
    private volatile boolean quit = false;
    private debugserver_client_t debugserver;

    private DebugserverProxy(int localPort, debugserver_client_t debugserver) {
        this.debugserver = debugserver;
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("Illegal port");
        }
        this.localPort = localPort;
    }

    public static DebugserverProxy create(debugserver_client_t debugserver, int localPort) {
        DebugserverProxy proxy = new DebugserverProxy(localPort, debugserver);
        proxy.start();
        return proxy;
    }

    private void start() {
        try {
            this.server = new ServerSocket(this.localPort);
            this.server.setReuseAddress(true);
            this.server.setSoTimeout(5000);
        }
        catch (IOException e) {
            System.out.println(this.localPort + ": Creating server socket failed");
            this.quit = true;
            return;
        }
        this.proxyThread = new Thread(new Runnable(){
            private Thread local2remoteThread;
            private Thread remote2localThread;
            private InputStream socketInput;
            private OutputStream socketOutput;

            @Override
            public void run() {
                this.accept();
                this.startup();
                if (this.local2remoteThread != null) {
                    try {
                        this.local2remoteThread.join();
                    }
                    catch (InterruptedException e) {
                        System.out.println(DebugserverProxy.this.localPort + ": Joining local2remoteThread failed");
                    }
                }
            }

            private void accept() {
                if (Thread.currentThread().isInterrupted()) {
                    DebugserverProxy.this.quit = true;
                }
                boolean isAccepted = false;
                while (!isAccepted) {
                    try {
                        DebugserverProxy.this.socket = DebugserverProxy.this.server.accept();
                        isAccepted = true;
                    }
                    catch (IOException e) {
                        if (!Thread.currentThread().isInterrupted()) {
                            isAccepted = false;
                            continue;
                        }
                        System.out.println(DebugserverProxy.this.localPort + ": Server accept interrupted");
                        DebugserverProxy.this.quit = true;
                    }
                }
            }

            private void startup() {
                if (Thread.currentThread().isInterrupted()) {
                    DebugserverProxy.this.quit = true;
                    return;
                }
                try {
                    this.socketInput = DebugserverProxy.this.socket.getInputStream();
                    this.socketOutput = DebugserverProxy.this.socket.getOutputStream();
                }
                catch (IOException e) {
                    if (!Thread.currentThread().isInterrupted()) {
                        System.out.println(DebugserverProxy.this.localPort + ": Server accept failed");
                    } else {
                        System.out.println(DebugserverProxy.this.localPort + ": Server accept interrupted");
                        DebugserverProxy.this.quit = true;
                    }
                    return;
                }
                this.local2remoteThread = this.createClientToServerThread("local2remoteThread", this.socketInput);
                this.local2remoteThread.start();
                DebugserverProxy.this.serverLock.lock();
                try {
                    try {
                        DebugserverProxy.this.serverEnded.await();
                    }
                    catch (InterruptedException e) {
                        System.out.println(DebugserverProxy.this.localPort + ": Proxy server was interrupted: " + e.toString());
                    }
                }
                finally {
                    DebugserverProxy.this.serverLock.unlock();
                }
            }

            private Thread createClientToServerThread(String name, final InputStream is) {
                return new Thread(new Runnable(){
                    final int bufferSize = 0x100000;
                    final BytePtr buffer = PtrFactory.newByteArray(0x100000);
                    final byte[] bufIn = new byte[0x100000];
                    int err = 0;

                    @Override
                    public void run() {
                        remote2localThread = this.createServerToClientThread("remote2localThread", socketOutput);
                        remote2localThread.start();
                        IntPtr countSent = PtrFactory.newIntReference(0);
                        while (!Thread.currentThread().isInterrupted() && !DebugserverProxy.this.quit) {
                            try {
                                int count = is.read(this.bufIn);
                                if (count == -1) break;
                                this.buffer.copyFrom(this.bufIn);
                                this.err = Globals.debugserver_client_send(DebugserverProxy.this.debugserver, this.buffer, count, countSent);
                                if (this.err != 0) {
                                    System.out.println("Debugserver send data failed!");
                                    break;
                                }
                                if (count == countSent.getValue()) continue;
                                System.out.println("Not all data sent count " + count + " countSent " + countSent);
                            }
                            catch (IOException e) {
                                System.out.println("sending data interrupted");
                                break;
                            }
                        }
                        if (remote2localThread != null) {
                            try {
                                remote2localThread.join();
                            }
                            catch (InterruptedException e) {
                                System.out.println(DebugserverProxy.this.localPort + ": Joining remote2localThread failed");
                            }
                        }
                        DebugserverProxy.this.serverLock.lock();
                        try {
                            DebugserverProxy.this.serverEnded.signal();
                        }
                        finally {
                            DebugserverProxy.this.serverLock.unlock();
                        }
                    }
                });
            }

            private Thread createServerToClientThread(String name, final OutputStream os) {
                return new Thread(new Runnable(){
                    final int bufferSize = 0x100000;
                    final BytePtr buffer = PtrFactory.newByteArray(0x100000);
                    final byte[] bufOut = new byte[0x100000];
                    int err = 0;

                    @Override
                    public void run() {
                        while (!Thread.currentThread().isInterrupted() && !DebugserverProxy.this.quit) {
                            IntPtr count = PtrFactory.newIntReference(0);
                            try {
                                this.err = Globals.debugserver_client_receive_with_timeout(DebugserverProxy.this.debugserver, this.buffer, 0x100000, count, 50);
                                if (this.err != 0) {
                                    System.out.println("Debugserver receive data failed!");
                                    break;
                                }
                                this.buffer.copyTo(this.bufOut);
                            }
                            catch (Exception e) {
                                System.out.println("receiving data interrupted1");
                                break;
                            }
                            try {
                                if (this.err != 0 || count.getValue() == 0) continue;
                                os.write(this.bufOut, 0, count.getValue());
                            }
                            catch (IOException e) {
                                System.out.println("receiving data interrupted: " + e.toString());
                                break;
                            }
                        }
                        DebugserverProxy.this.serverLock.lock();
                        try {
                            DebugserverProxy.this.serverEnded.signal();
                        }
                        finally {
                            DebugserverProxy.this.serverLock.unlock();
                        }
                    }
                });
            }

            public synchronized void stop() {
                System.out.println(DebugserverProxy.this.localPort + ": Stopping proxy");
                DebugserverProxy.this.quit = true;
                DebugserverProxy.this.tryClose(this.socketInput, "Closing remote output failed");
                Thread.yield();
                DebugserverProxy.this.tryClose(this.socketOutput, "Closing remote output failed");
                System.out.println(DebugserverProxy.this.localPort + ": Stopping socket completed");
            }
        });
        this.proxyThread.start();
    }

    private void tryClose(Closeable closeable, String failMessage) {
        if (closeable != null) {
            CloseableUtil.tryClose(closeable, null, this.localPort + ": " + failMessage);
        }
    }

    public synchronized void stop() {
        this.quit = true;
        this.tryClose(this.server, "Closing server failed");
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitFor() {
        this.quit = true;
        this.proxyThread.interrupt();
        try {
            Thread thread2 = this.proxyThread;
            synchronized (thread2) {
                this.proxyThread.join(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void registerShutdownHook() {
        if (!this.hasShutdownHookRegistered) {
            this.hasShutdownHookRegistered = true;
            ShutdownManager.register(new Runnable(){

                @Override
                public void run() {
                    DebugserverProxy.this.stop();
                }
            });
            ShutdownManager.registerPost(new Runnable(){

                @Override
                public void run() {
                    DebugserverProxy.this.waitFor();
                }
            });
        }
    }
}

