/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.libimobiledevice.c.Globals;
import org.libimobiledevice.opaque.idevice_t;
import org.libimobiledevice.struct.idevice_info;
import org.moe.common.ShutdownManager;
import org.moe.ios.device.launcher.Configuration;
import org.moe.ios.device.launcher.DeviceException;
import org.moe.ios.device.launcher.USBDeviceWatcher;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.PtrFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeviceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceHelper.class);
    private static final Lock W4D_LOCK = new ReentrantLock();
    private static final Condition W4D_ADDED = W4D_LOCK.newCondition();
    private static Thread W4D_WAITING_THREAD;
    private static boolean W4D_SHUTDOWN_HOOK_INSTALLED;

    private DeviceHelper() {
    }

    public static Set<String> getDevices() {
        HashSet<String> devices = new HashSet<String>();
        IntPtr countRef = PtrFactory.newIntReference();
        Ptr<Ptr<Ptr<idevice_info>>> listRef = PtrFactory.newPointerPtr(idevice_info.class, 3, 1, true, false);
        Globals.idevice_get_device_list_extended(listRef, countRef);
        int count = (Integer)countRef.get();
        Ptr list = (Ptr)listRef.get();
        for (int i = 0; i < count; ++i) {
            Ptr device = (Ptr)list.get(i);
            idevice_info d = (idevice_info)device.get();
            if (d.conn_type() != 1) continue;
            devices.add(d.udid().toASCIIString());
        }
        Globals.idevice_device_list_extended_free((Ptr)listRef.get());
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static idevice_t waitForDevice(final String udid) throws DeviceException {
        W4D_LOCK.lock();
        if (!W4D_SHUTDOWN_HOOK_INSTALLED) {
            W4D_SHUTDOWN_HOOK_INSTALLED = true;
            ShutdownManager.register(new Runnable(){

                @Override
                public void run() {
                    Thread tmp = W4D_WAITING_THREAD;
                    if (tmp != null) {
                        tmp.interrupt();
                        try {
                            tmp.join(2000L);
                        }
                        catch (InterruptedException e) {
                            LOG.error("Failed to join 'wait for device' thread");
                        }
                    }
                }
            });
        }
        W4D_WAITING_THREAD = Thread.currentThread();
        System.out.println("Waiting for iOS Device...");
        final StringBuilder udidBuilder = new StringBuilder();
        USBDeviceWatcher.IUSBDeviceListener listener = new USBDeviceWatcher.IUSBDeviceListener(){

            @Override
            public void handle(int event, String deviceUDID) {
                if (event != 1) {
                    return;
                }
                if (udid != null && !udid.equals(deviceUDID)) {
                    return;
                }
                W4D_LOCK.lock();
                try {
                    LOG.debug("Found device: " + deviceUDID);
                    if (udidBuilder.length() > 0) {
                        return;
                    }
                    udidBuilder.append(deviceUDID);
                    W4D_ADDED.signal();
                }
                finally {
                    W4D_LOCK.unlock();
                }
            }
        };
        USBDeviceWatcher.register(listener);
        try {
            try {
                W4D_ADDED.await();
            }
            catch (InterruptedException e) {
                LOG.debug("Waiting for device interrupted");
                idevice_t idevice_t2 = null;
                USBDeviceWatcher.unregister(listener);
                W4D_WAITING_THREAD = null;
                W4D_LOCK.unlock();
                return idevice_t2;
            }
        }
        finally {
            USBDeviceWatcher.unregister(listener);
            W4D_WAITING_THREAD = null;
            W4D_LOCK.unlock();
        }
        return DeviceHelper.newDeviceViaUSB(udidBuilder.toString());
    }

    public static idevice_t getDevice(Configuration config) throws DeviceException {
        if (config.getDeviceUDID() == null || config.getDeviceUDID().length() == 0) {
            return DeviceHelper.getFirstAvailableDevice(config.getWaitForDevice());
        }
        if (config.getWaitForDevice()) {
            return DeviceHelper.waitForDevice(config.getDeviceUDID());
        }
        return DeviceHelper.newDeviceViaUSB(config.getDeviceUDID());
    }

    private static idevice_t getFirstAvailableDevice(boolean w4d) throws DeviceException {
        if (w4d) {
            return DeviceHelper.waitForDevice(null);
        }
        Set<String> devices = DeviceHelper.getDevices();
        if (devices.size() == 0) {
            throw new DeviceException("There are no devices connected", null, 0);
        }
        return DeviceHelper.newDeviceViaUSB(devices.toArray(new String[devices.size()])[0]);
    }

    private static idevice_t newDeviceViaUSB(String udid) throws DeviceException {
        if (udid == null) {
            throw new NullPointerException();
        }
        LOG.debug("Creating new USB device for " + udid);
        Ptr<Class<idevice_t>> deviceRef = PtrFactory.newOpaquePtrReference(idevice_t.class);
        int error = Globals.idevice_new_with_options(deviceRef, udid, 2);
        if (error != 0) {
            throw new DeviceException("Failed to create device", "idevice_new_with_connection", error);
        }
        return (idevice_t)deviceRef.get();
    }
}

