/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.libimobiledevice.c.Globals;
import org.libimobiledevice.opaque.afc_client_t;
import org.libimobiledevice.opaque.idevice_t;
import org.libimobiledevice.opaque.instproxy_client_t;
import org.libplist.opaque.plist_t;
import org.moe.common.utils.CloseableUtil;
import org.moe.ios.device.launcher.Configuration;
import org.moe.ios.device.launcher.DeviceException;
import org.moe.ios.device.launcher.Main;
import org.moe.ios.device.launcher.PlistHelper;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.LongPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.general.ptr.impl.PtrFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InstallHelper {
    private static final Logger LOG = LoggerFactory.getLogger(InstallHelper.class);
    private static final String FILE_UPLOAD = "FileUpload";
    private static final String PKG_PATH = "PublicStaging";
    private final idevice_t device;
    private final File appPath;
    private final Lock installLock = new ReentrantLock();
    private final Condition installEnded = this.installLock.newCondition();
    private String installMode;
    private String errorMessage;
    private int numberOfFilesToUpload = 0;
    private int numberOfFilesUploaded = 0;

    private InstallHelper(idevice_t device, Configuration config) {
        if (device == null || config == null || config.getApplicationPath() == null || config.getInstallMode() == null) {
            throw new NullPointerException();
        }
        this.device = device;
        this.appPath = config.getApplicationPath();
        this.installMode = config.getInstallMode();
    }

    public static String uploadAndInstall(idevice_t device, Configuration config) throws DeviceException {
        InstallHelper installHelper = new InstallHelper(device, config);
        return installHelper.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String run() throws DeviceException {
        LOG.debug("Starting installation");
        instproxy_client_t ip = this.initInstProxy();
        try {
            String bundleid;
            afc_client_t afc = this.initAFCCient();
            try {
                if (!"runonly".equals(this.installMode)) {
                    this.createPkgPath(afc);
                    this.numberOfFilesToUpload = this.getFileCount(this.appPath.getAbsolutePath());
                    String target = "PublicStaging/" + this.appPath.getName();
                    Main.PRINT_CONTROL("Uploading:");
                    this.uploadDirectory(afc, this.appPath.getAbsolutePath(), target);
                    Main.PRINT_CONTROL("");
                    Main.PRINT_CONTROL("Installing:");
                    this.install(ip, target);
                    Main.PRINT_CONTROL("");
                    if (this.errorMessage != null) {
                        throw new DeviceException("Failed to " + this.installMode + " on device, " + this.errorMessage);
                    }
                }
            }
            finally {
                Globals.afc_client_free(afc);
            }
            try {
                HashMap<String, Object> plist = PlistHelper.readFromFile(new File(this.appPath, "Info.plist"));
                if (plist == null) {
                    throw new NullPointerException();
                }
                bundleid = (String)plist.get("CFBundleIdentifier");
            }
            catch (Exception ex) {
                throw new DeviceException("Failed to get bundle ID: " + ex.getMessage());
            }
            Ptr<BytePtr> pathRef = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
            int err = Globals.instproxy_client_get_path_for_bundle_identifier(ip, bundleid, pathRef);
            if (err != 0) {
                throw new DeviceException("Failed to get application path", "instproxy_client_get_path_for_bundle_identifier", err);
            }
            String string = ((BytePtr)pathRef.get()).toUTF8String();
            return string;
        }
        finally {
            Globals.instproxy_client_free(ip);
        }
    }

    private instproxy_client_t initInstProxy() throws DeviceException {
        LOG.debug("Creating installation proxy client");
        Ptr<Class<instproxy_client_t>> client_ptr = PtrFactory.newOpaquePtrReference(instproxy_client_t.class);
        int err = Globals.instproxy_client_start_service(this.device, client_ptr, null);
        if (err != 0) {
            throw new DeviceException("Failed to get installation proxy", "instproxy_client_start_service", err);
        }
        return (instproxy_client_t)client_ptr.get();
    }

    private afc_client_t initAFCCient() throws DeviceException {
        LOG.debug("Creating afc client");
        Ptr<Class<afc_client_t>> client_ptr = PtrFactory.newOpaquePtrReference(afc_client_t.class);
        int err = Globals.afc_client_start_service(this.device, client_ptr, null);
        if (err != 0) {
            throw new DeviceException("Failed to get installation proxy", "afc_client_start_service", err);
        }
        return (afc_client_t)client_ptr.get();
    }

    private void createPkgPath(afc_client_t afc) throws DeviceException {
        LOG.debug("Preparing staging directory");
        Ptr<Ptr<BytePtr>> infolist_ref = PtrFactory.newPointerPtr(Byte.class, 3, 1, true, false);
        int err = Globals.afc_get_file_info(afc, PKG_PATH, infolist_ref);
        Ptr infolist = (Ptr)infolist_ref.get();
        if (infolist != null) {
            BytePtr ptr;
            int idx = 0;
            while ((ptr = (BytePtr)infolist.get(idx++)) != null) {
                ptr.free();
            }
            infolist.free();
        }
        if (err == 8) {
            err = Globals.afc_make_directory(afc, PKG_PATH);
            if (err != 0) {
                throw new DeviceException("Failed to make directory on device", "afc_make_directory", err);
            }
            return;
        }
        if (err != 0) {
            throw new DeviceException("Failed to get file info", "afc_get_file_info", err);
        }
    }

    private int getFileCount(String source) {
        File local = new File(source);
        String[] contents = local.list();
        int count = 0;
        if (contents != null) {
            for (String content : contents) {
                File elem = new File(local, content);
                if (elem.isDirectory()) {
                    count += this.getFileCount(elem.getAbsolutePath());
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    private void uploadDirectory(afc_client_t afc, String source, String target) throws DeviceException {
        int err = Globals.afc_make_directory(afc, target);
        if (err != 0) {
            throw new DeviceException("Failed to make directory on device", "afc_make_directory", err);
        }
        File local = new File(source);
        String[] contents = local.list();
        if (contents != null) {
            for (String content : contents) {
                File elem = new File(local, content);
                if (elem.isDirectory()) {
                    this.uploadDirectory(afc, elem.getAbsolutePath(), target + "/" + elem.getName());
                    continue;
                }
                this.uploadFile(afc, elem.getAbsolutePath(), target + "/" + elem.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(afc_client_t afc, String source, String target) throws DeviceException {
        FileInputStream fis;
        int bufferSize = 0x100000;
        File local = new File(source);
        try {
            fis = new FileInputStream(local);
        }
        catch (FileNotFoundException e) {
            throw new DeviceException("failed to open file for upload " + source);
        }
        try {
            BufferedInputStream is = new BufferedInputStream(fis, 0x100000);
            LongPtr handle_ref = PtrFactory.newLongReference();
            int err = Globals.afc_file_open(afc, target, 3, handle_ref);
            if (err != 0) {
                CloseableUtil.tryClose(is, LOG, "Failed to close input stream for " + source);
                throw new DeviceException("Failed to open file on device", "afc_file_open", err);
            }
            long targetFileHandle = handle_ref.getValue();
            try {
                int read;
                byte[] jbuffer = new byte[0x100000];
                BytePtr nbuffer = PtrFactory.newByteArray(0x100000);
                IntPtr bytesWritten = PtrFactory.newIntReference();
                while ((read = ((InputStream)is).read(jbuffer)) != -1) {
                    nbuffer.copyFrom(jbuffer);
                    err = Globals.afc_file_write(afc, targetFileHandle, nbuffer, read, bytesWritten);
                    if (err != 0) {
                        throw new DeviceException("Failed to write file on device", "afc_file_write", err);
                    }
                    if (read == bytesWritten.getValue()) continue;
                    throw new DeviceException("file writing to device failed, wrote " + bytesWritten.getValue() + " bytes instead of " + read);
                }
            }
            catch (Exception e) {
                throw new DeviceException("Writing file to device failed", e);
            }
            finally {
                CloseableUtil.tryClose(is, LOG, "Failed to close input stream for " + source);
                Globals.afc_file_close(afc, targetFileHandle);
            }
            ++this.numberOfFilesUploaded;
            this.updateProgress(FILE_UPLOAD, local.getName(), this.numberOfFilesUploaded * 100 / this.numberOfFilesToUpload);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(instproxy_client_t ip, String target) {
        this.installLock.lock();
        plist_t options = Globals.instproxy_client_options_new();
        Globals.instproxy_client_option_add(options, "PackageType", "Developer");
        try {
            if ("install".equals(this.installMode) || "installonly".equals(this.installMode)) {
                Globals.Function_instproxy_install cb = new Globals.Function_instproxy_install(){

                    @Override
                    public void call_instproxy_install(plist_t operation, plist_t status, VoidPtr userdata) {
                        HashMap<String, Object> operationDict = PlistHelper.getDict(operation);
                        String operationCommand = operationDict == null ? null : (String)operationDict.get("Command");
                        InstallHelper.this.updateStatus(operationCommand, PlistHelper.getDict(status));
                    }
                };
                Globals.instproxy_install(ip, target, options, cb, null);
            } else if ("upgrade".equals(this.installMode) || "upgradeonly".equals(this.installMode)) {
                Globals.Function_instproxy_upgrade cb = new Globals.Function_instproxy_upgrade(){

                    @Override
                    public void call_instproxy_upgrade(plist_t operation, plist_t status, VoidPtr userdata) {
                        HashMap<String, Object> operationDict = PlistHelper.getDict(operation);
                        String operationCommand = operationDict == null ? null : (String)operationDict.get("Command");
                        InstallHelper.this.updateStatus(operationCommand, PlistHelper.getDict(status));
                    }
                };
                Globals.instproxy_upgrade(ip, target, options, cb, null);
            } else {
                throw new IllegalStateException();
            }
            try {
                this.installEnded.await();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug(this.installMode + " was interrupted");
            }
        }
        finally {
            Globals.instproxy_client_options_free(options);
            this.installLock.unlock();
        }
    }

    private void updateStatus(String operation, HashMap<String, Object> dict) {
        if (dict == null || operation == null) {
            this.updateProgress(operation == null ? "" : operation, "Unknown error", -1);
            this.signalInstallationEnded();
        } else {
            String status = (String)dict.get("Status");
            if (status == null) {
                String error = (String)dict.get("Error");
                Long code = (Long)dict.get("ErrorDetail");
                this.updateProgress(operation, error == null ? "Unknown error" : error + "(" + code + ")", -1);
                this.signalInstallationEnded();
            }
            if ("Complete".equals(status)) {
                this.updateProgress(operation, status, 100);
                this.signalInstallationEnded();
            } else {
                Long percentComplete = (Long)dict.get("PercentComplete");
                percentComplete = percentComplete == null ? 0L : percentComplete;
                this.updateProgress(operation, status, percentComplete.intValue());
            }
        }
    }

    private void signalInstallationEnded() {
        this.installLock.lock();
        try {
            this.installEnded.signal();
        }
        finally {
            this.installLock.unlock();
        }
    }

    private void updateProgress(String operation, String status, int prog) {
        if (prog == -1) {
            System.out.println("- " + operation + " failed " + status);
            this.errorMessage = status;
        } else {
            System.out.println("- " + operation + "@" + prog + "% " + status);
        }
    }
}

