/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.libimobiledevice.c.Globals;
import org.libimobiledevice.opaque.debugserver_client_t;
import org.libimobiledevice.opaque.idevice_t;
import org.moe.common.Port;
import org.moe.common.ProxyPort;
import org.moe.common.ShutdownManager;
import org.moe.common.macho.MachoFile;
import org.moe.common.utils.ProxyUtil;
import org.moe.ios.device.ConnectionHelper;
import org.moe.ios.device.ConnectionLock;
import org.moe.ios.device.launcher.Configuration;
import org.moe.ios.device.launcher.DebugserverProxy;
import org.moe.ios.device.launcher.DeviceException;
import org.moe.ios.device.launcher.Main;
import org.moe.ios.device.launcher.PlistHelper;
import org.moe.ios.device.launcher.ProxyHelper;
import org.moe.ios.device.launcher.USBDeviceWatcher;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.PtrFactory;
import org.moe.protocol.gdbremote.GDBRemoteProtocol;
import org.moe.protocol.gdbremote.IStopReplyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchHelper
implements IStopReplyListener {
    private static final Logger LOG = LoggerFactory.getLogger(LaunchHelper.class);
    private final String udid;
    private final idevice_t device;
    private final Configuration config;
    private final String appPath;
    private final ArrayList<String> launchArgs;
    private final ArrayList<ProxyPort> proxyPorts;
    private final ProxyPort debugPort;
    private final Lock processLock = new ReentrantLock();
    private final Condition processEnded = this.processLock.newCondition();
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private final Port stdOutPort;
    private final HashMap<String, String> envVars;
    private GDBRemoteProtocol protocol;
    private PipedOutputStream stdPipeOutput;
    private FileOutputStream stdFileOutput;

    private LaunchHelper(idevice_t device, String appPath, Configuration config) throws DeviceException {
        this.device = device;
        this.config = config;
        Ptr<BytePtr> udidRef = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
        if (Globals.idevice_get_udid(device, udidRef) != 0) {
            throw new DeviceException("Failed to get device UDID from device");
        }
        this.udid = ((BytePtr)udidRef.get()).toASCIIString();
        this.appPath = appPath;
        this.launchArgs = config.getLaunchArgs();
        this.envVars = config.getEnvVars();
        this.proxyPorts = config.getProxyPorts();
        this.debugPort = config.getJdwpPort();
        this.stdOutPort = config.getStdOutPort();
    }

    public static void launch(idevice_t device, String appPath, Configuration config) throws DeviceException {
        if ("installonly".equals(config.getInstallMode()) || "upgradeonly".equals(config.getInstallMode())) {
            return;
        }
        try {
            LaunchHelper runHelper;
            boolean isFirstTry = true;
            while ((runHelper = new LaunchHelper(device, appPath, config)).launch(isFirstTry)) {
                isFirstTry = false;
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted", e);
        }
    }

    private static debugserver_client_t getDebugServer(idevice_t device) throws DeviceException {
        Ptr<Class<debugserver_client_t>> client_ptr = PtrFactory.newOpaquePtrReference(debugserver_client_t.class);
        int err = Globals.debugserver_client_start_service(device, client_ptr, null);
        if (err != 0) {
            throw new DeviceException("Failed to get debug server", "debugserver_error_t", err);
        }
        return (debugserver_client_t)client_ptr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean launch(boolean isFirstTry) throws DeviceException {
        if (isFirstTry) {
            Main.PRINT_CONTROL("Launching:");
        }
        cpuTypes = null;
        try {
            file = this.config.getApplicationPath();
            filename = file.getName();
            if (filename.endsWith(".app")) {
                execName = null;
                try {
                    plist = new File(file, "Info.plist");
                    plistData = PlistHelper.readFromFile(plist);
                    if (plistData != null) {
                        execName = (String)plistData.get("CFBundleExecutable");
                    }
                }
                catch (Exception plist) {
                    // empty catch block
                }
                if (execName == null) {
                    execName = filename.substring(0, filename.length() - 4);
                }
                file = new File(file, execName);
            }
            cpuTypes = MachoFile.getRecognizedCPUTypes(file);
        }
        catch (Exception e) {
            throw new DeviceException("Failed to get CPU types from application", e);
        }
        if (this.config.getStdOutFile() != null) {
            try {
                this.stdFileOutput = new FileOutputStream(this.config.getStdOutFile());
                ShutdownManager.registerPost(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LaunchHelper.this.stdFileOutput.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to create standard stream forwarding", e);
            }
        }
        if (this.stdOutPort != null) {
            try {
                this.stdPipeOutput = new PipedOutputStream();
                pipedInputStream = new PipedInputStream(this.stdPipeOutput);
                proxy = ProxyUtil.create(this.stdOutPort.getPort(), pipedInputStream, new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }
                });
                proxy.registerShutdownHook();
                ShutdownManager.registerPost(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LaunchHelper.this.stdPipeOutput.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            LaunchHelper.this.stdPipeOutput.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            pipedInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new DeviceException("Failed to create standard stream forwarding", e);
            }
        }
        debugServer = LaunchHelper.getDebugServer(this.device);
        proxy = null;
        sockProxy = null;
        is = null;
        os = null;
        if (this.config.getDebugserverPort() != null) {
            proxy = DebugserverProxy.create(debugServer, this.config.getDebugserverPort().getLocalPort());
            try {
                sockProxy = new Socket("localhost", this.config.getDebugserverPort().getLocalPort());
                sockProxy.setReuseAddress(true);
                is = sockProxy.getInputStream();
                os = sockProxy.getOutputStream();
            }
            catch (Exception e) {
                System.out.println("SERVER----error on socket!");
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException var9_14) {
                    // empty catch block
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException var9_15) {
                    // empty catch block
                }
                try {
                    if (sockProxy != null) {
                        sockProxy.close();
                    }
                }
                catch (IOException var9_16) {
                    // empty catch block
                }
                if (proxy != null) {
                    proxy.waitFor();
                    proxy.stop();
                }
                return false;
            }
        }
        dscisLock = new ConnectionLock();
        dscosLock = new ConnectionLock();
        dscis = ConnectionHelper.getInputStream(debugServer, dscisLock);
        dscos = ConnectionHelper.getOutputStream(debugServer, dscosLock);
        try {
            if (this.config.getDebugserverPort() != null) {
                this.protocol = new GDBRemoteProtocol(is, os);
                this.protocol.addListener(this);
            } else {
                this.protocol = new GDBRemoteProtocol(dscis, dscos);
                this.protocol.addListener(this);
                this.protocol.set_StartNoAckMode();
            }
            cpuTypeString = this.protocol.query_HostInfo().get("cputype");
            if (cpuTypeString != null) {
                try {
                    cpuType = Integer.parseInt(cpuTypeString);
                    cpuName = MachoFile.getCPUName(cpuType);
                    if ("arm64".equals(cpuName) && !cpuTypes.contains(cpuName)) {
                        this.protocol.set_LaunchArch("arm");
                    }
                }
                catch (NumberFormatException cpuType) {
                    // empty catch block
                }
            }
            for (Map.Entry<String, String> next : this.envVars.entrySet()) {
                this.protocol.set_EnvironmentHexEncoded(next.getKey(), next.getValue());
            }
            _args = new ArrayList<String>();
            _args.add(this.appPath);
            if (this.debugPort != null) {
                _args.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + this.debugPort.getRemotePort());
            }
            _args.addAll(this.launchArgs);
            args_arr = new String[_args.size()];
            this.protocol.send_Arguments(_args.toArray(args_arr));
            query_launchSuccess = this.protocol.query_LaunchSuccess();
            if (query_launchSuccess == null) ** GOTO lbl149
            if ("Locked".equals(query_launchSuccess) || query_launchSuccess.contains("the device was not, or could not be, unlocked")) {
                if (isFirstTry) {
                    LaunchHelper.LOG.info("Please unlock your device");
                }
                var16_30 = true;
                return var16_30;
            }
            try {
                if (this.config.getDebugserverPort() != null) {
                    this.protocol.close();
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException var16_31) {
                        // empty catch block
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException var16_32) {
                        // empty catch block
                    }
                    try {
                        if (sockProxy != null) {
                            sockProxy.close();
                        }
                    }
                    catch (IOException var16_33) {
                        // empty catch block
                    }
                    if (proxy != null) {
                        proxy.waitFor();
                        proxy.stop();
                    }
                }
                throw new DeviceException("Failed to launch application on device: " + query_launchSuccess);
lbl149:
                // 1 sources

                if (this.config.getDebugserverPort() != null) {
                    this.protocol.close();
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException var16_34) {
                        // empty catch block
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException var16_35) {
                        // empty catch block
                    }
                    try {
                        if (sockProxy != null) {
                            sockProxy.close();
                        }
                    }
                    catch (IOException var16_37) {
                        // empty catch block
                    }
                    if (proxy != null) {
                        proxy.waitFor();
                        proxy.stop();
                    }
                    proxy = DebugserverProxy.create(debugServer, this.config.getDebugserverPort().getLocalPort());
                } else {
                    this.protocol.send_vCont((byte)99, 0);
                }
                if (this.debugPort != null) {
                    LaunchHelper.LOG.debug("Starting debug server: " + this.debugPort);
                    ProxyHelper.createProxyServer(this.debugPort, this.device, this.shuttingDown);
                }
                for (ProxyPort port : this.proxyPorts) {
                    LaunchHelper.LOG.debug("Starting proxy server: " + port);
                    ProxyHelper.createProxyServer(port, this.device, this.shuttingDown);
                }
                waitingThread = Thread.currentThread();
                ShutdownManager.register(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LaunchHelper.this.protocol.send_ctrl_C();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LaunchHelper.this.protocol.send_k();
                            try {
                                waitingThread.join(5000L);
                            }
                            catch (InterruptedException e) {
                                LOG.debug("Waiting for main thread failed");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                listener = new USBDeviceWatcher.IUSBDeviceListener(){

                    @Override
                    public void handle(int event, String deviceUDID) {
                        if (deviceUDID.equals(LaunchHelper.this.udid) && event == 2) {
                            LaunchHelper.this.signalProcessEnded(false);
                        }
                    }
                };
                USBDeviceWatcher.register(listener);
                LaunchHelper.LOG.debug("Waiting for process end");
                this.waitForProcessEnd();
                LaunchHelper.LOG.debug("Process ended");
                USBDeviceWatcher.unregister(listener);
            }
            catch (IOException e) {
                throw new DeviceException("An exception occurred during launch " + e.getMessage());
            }
        }
        finally {
            dscisLock.lockAndClose();
            dscosLock.lockAndClose();
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException var17_38) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException var17_39) {}
            try {
                if (sockProxy != null) {
                    sockProxy.close();
                }
            }
            catch (IOException var17_40) {}
            if (proxy != null) {
                proxy.waitFor();
                proxy.stop();
            }
            Globals.debugserver_client_free(debugServer);
            dscisLock.unlock();
            dscosLock.unlock();
        }
        return false;
    }

    @Override
    public void processSignaled(byte signal, Map<String, String> info) {
        LOG.debug("processSignaled");
        try {
            this.protocol.send_k();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processExited(byte status) {
        LOG.debug("processExited");
        this.signalProcessEnded(true);
    }

    @Override
    public void processTerminated(byte status) {
        LOG.debug("processTerminated");
        this.signalProcessEnded(false);
    }

    @Override
    public void processOutput(String output) {
        LOG.debug("processOutput");
        if (this.stdPipeOutput != null) {
            try {
                this.stdPipeOutput.write(output.getBytes());
            }
            catch (IOException e) {
                LOG.error("Failed to pipe std output " + output);
            }
        }
        if (this.stdFileOutput != null) {
            try {
                this.stdFileOutput.write(output.getBytes());
            }
            catch (IOException e) {
                LOG.error("Failed to write standard stream");
            }
        }
        System.out.print(output);
    }

    private void signalProcessEnded(boolean exited) {
        this.processLock.lock();
        try {
            this.processEnded.signal();
            this.shuttingDown.set(true);
        }
        finally {
            this.processLock.unlock();
        }
    }

    private void waitForProcessEnd() {
        this.processLock.lock();
        try {
            try {
                this.processEnded.await();
            }
            catch (InterruptedException e) {
                try {
                    this.protocol.send_ctrl_C();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    this.protocol.send_k();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOG.debug("wait for process end interrupted");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.processLock.unlock();
        }
    }
}

