/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.libimobiledevice.opaque.idevice_t;
import org.moe.common.ShutdownManager;
import org.moe.common.configuration.ConfigurationValidationException;
import org.moe.common.utils.NativeUtil;
import org.moe.ios.device.launcher.Configuration;
import org.moe.ios.device.launcher.ConfigurationAppender;
import org.moe.ios.device.launcher.DeviceException;
import org.moe.ios.device.launcher.DeviceHelper;
import org.moe.ios.device.launcher.InstallHelper;
import org.moe.ios.device.launcher.LaunchHelper;
import org.moe.ios.device.launcher.ProxyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private final Configuration config;

    private static void loadNativeLibraries() throws IOException {
        String current = new File(".").getCanonicalPath();
        String osName = NativeUtil.getUnifiedSystemName();
        if (osName.equals("Mac OS X")) {
            System.load(current + "/macosx/libnatj.dylib");
            System.load(current + "/macosx/libimobiledevice.dylib");
        } else if (osName.equals("Windows")) {
            System.load(current + "/windows/x86_64/natj.dll");
            System.load(current + "/windows/x86_64/libimobiledevice.dll");
        } else {
            throw new RuntimeException("Unsupported OS");
        }
    }

    private Main(Configuration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    public static void main(String[] args2) throws IOException {
        Configuration config = ConfigurationAppender.read(args2);
        try {
            config.validate();
            config.close();
        }
        catch (ConfigurationValidationException ex) {
            Main.PRINT_ERROR("Invalid property (" + ex.getPropertyName() + ") - " + ex.getErrorMessage());
            System.exit(1);
        }
        Main.loadNativeLibraries();
        Main main = new Main(config);
        try {
            main.run();
        }
        catch (DeviceException e) {
            if (e.getCall() != null) {
                Main.PRINT_ERROR(e.getMessage() + " (" + e.getCall() + " returned " + e.getCode() + ")");
            } else {
                Main.PRINT_ERROR(e.getMessage());
            }
            LOG.debug("Launching failed", e);
            System.exit(1);
        }
    }

    private void run() throws DeviceException {
        idevice_t device;
        if (this.config.getListDevices()) {
            this.printDevices();
        }
        if ((device = DeviceHelper.getDevice(this.config)) == null) {
            throw new DeviceException("Failed to connect to device, device is null");
        }
        try {
            if (this.config.getApplicationPath() != null) {
                String appPath = InstallHelper.uploadAndInstall(device, this.config);
                LaunchHelper.launch(device, appPath, this.config);
            } else {
                ProxyHelper.launch(device, this.config);
            }
        }
        finally {
            ShutdownManager.shutdown();
        }
    }

    private void printDevices() {
        Set<String> devices = DeviceHelper.getDevices();
        Main.PRINT_CONTROL("Connected iOS Devices:");
        for (String device : devices) {
            System.out.println("- " + device);
        }
        Main.PRINT_CONTROL("");
    }

    public static void PRINT_CONTROL(String ctrlString) {
        if (ctrlString == null) {
            ctrlString = "";
        }
        System.out.println(ctrlString);
        System.out.flush();
    }

    public static void PRINT_ERROR(String errString) {
        if (errString == null) {
            errString = "";
        }
        errString = "ERROR: " + errString;
        System.err.println(errString);
        System.err.flush();
    }
}

