/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.libplist.c.Globals;
import org.libplist.opaque.plist_dict_iter;
import org.libplist.opaque.plist_t;
import org.moe.common.utils.CloseableUtil;
import org.moe.natj.general.ptr.BytePtr;
import org.moe.natj.general.ptr.DoublePtr;
import org.moe.natj.general.ptr.IntPtr;
import org.moe.natj.general.ptr.LongPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.PtrFactory;

public class PlistHelper {
    private PlistHelper() {
    }

    public static Object getObject(plist_t node) {
        if (node == null) {
            return null;
        }
        switch (Globals.plist_get_node_type(node)) {
            case 3: {
                Ptr<BytePtr> ptr = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
                Globals.plist_get_string_val(node, ptr);
                return ((BytePtr)ptr.get()).toUTF8String();
            }
            case 4: {
                return PlistHelper.getArray(node);
            }
            case 5: {
                return PlistHelper.getDict(node);
            }
            case 0: {
                BytePtr ptr = PtrFactory.newByteReference();
                Globals.plist_get_bool_val(node, ptr);
                return (Byte)ptr.get() > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                LongPtr ptr = PtrFactory.newLongReference();
                Globals.plist_get_uint_val(node, ptr);
                return ptr.get();
            }
            case 2: {
                DoublePtr ptr = PtrFactory.newDoubleReference();
                Globals.plist_get_real_val(node, ptr);
                return ptr.get();
            }
            case 6: {
                IntPtr sec = PtrFactory.newIntReference();
                IntPtr usec = PtrFactory.newIntReference();
                Globals.plist_get_date_val(node, sec, usec);
                return new Date((long)sec.getValue() * 1000L + (long)usec.getValue() / 1000L);
            }
            case 7: {
                Ptr<BytePtr> val = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
                LongPtr length = PtrFactory.newLongReference();
                Globals.plist_get_data_val(node, val, length);
                return length.getValue() == 0L ? new byte[]{} : ((BytePtr)val.get()).toByteArray((int)length.getValue());
            }
            case 8: {
                Ptr<BytePtr> ptr = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
                Globals.plist_get_key_val(node, ptr);
                return ((BytePtr)ptr.get()).toUTF8String();
            }
        }
        return null;
    }

    public static ArrayList<Object> getArray(plist_t node) {
        if (node == null) {
            return null;
        }
        int size = Globals.plist_array_get_size(node);
        ArrayList<Object> array = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object o = PlistHelper.getObject(Globals.plist_array_get_item(node, i));
            array.add(i, o);
        }
        return array;
    }

    public static HashMap<String, Object> getDict(plist_t node) {
        if (node == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(Globals.plist_dict_get_size(node));
        Ptr<Class<plist_dict_iter>> iter_ptr = PtrFactory.newOpaquePtrReference(plist_dict_iter.class);
        Globals.plist_dict_new_iter(node, iter_ptr);
        Ptr<BytePtr> key_ = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
        Ptr<Class<plist_t>> val_ = PtrFactory.newOpaquePtrReference(plist_t.class);
        plist_dict_iter iter = (plist_dict_iter)iter_ptr.get();
        Globals.plist_dict_next_item(node, iter, key_, val_);
        while (val_.get() != null) {
            String key = ((BytePtr)key_.get()).toUTF8String();
            Object value = PlistHelper.getObject((plist_t)val_.get());
            map.put(key, value);
            Globals.plist_dict_next_item(node, iter, key_, val_);
        }
        return map;
    }

    public static ArrayList<String> getDictKeys(plist_t node) {
        ArrayList<String> keys2 = new ArrayList<String>();
        Ptr<Class<plist_dict_iter>> iter_ptr = PtrFactory.newOpaquePtrReference(plist_dict_iter.class);
        Globals.plist_dict_new_iter(node, iter_ptr);
        Ptr<BytePtr> key_ = PtrFactory.newPointerPtr(Byte.class, 2, 1, true, false);
        Ptr<Class<plist_t>> val_ = PtrFactory.newOpaquePtrReference(plist_t.class);
        plist_dict_iter iter = (plist_dict_iter)iter_ptr.get();
        Globals.plist_dict_next_item(node, iter, key_, val_);
        while (val_.get() != null) {
            keys2.add(((BytePtr)key_.get()).toUTF8String());
            Globals.plist_dict_next_item(node, iter, key_, val_);
        }
        return keys2;
    }

    public static HashMap<String, Object> readFromFile(File file) {
        byte[] bytes;
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                bytes = IOUtils.toByteArray(fis);
            }
            finally {
                CloseableUtil.tryClose(fis, null, null);
            }
        }
        catch (IOException e) {
            return null;
        }
        BytePtr bytePtr = PtrFactory.newByteArray(bytes);
        Ptr<Class<plist_t>> pPtr = PtrFactory.newOpaquePtrReference(plist_t.class);
        Globals.plist_from_bin(bytePtr, bytes.length, pPtr);
        if (pPtr.get() == null) {
            Globals.plist_from_xml(bytePtr, bytes.length, pPtr);
        }
        if (pPtr.get() == null) {
            return null;
        }
        HashMap<String, Object> dict = PlistHelper.getDict((plist_t)pPtr.get());
        Globals.plist_free((plist_t)pPtr.get());
        return dict;
    }
}

