/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.libimobiledevice.c.Globals;
import org.libimobiledevice.opaque.idevice_connection_t;
import org.libimobiledevice.opaque.idevice_t;
import org.moe.common.ProxyPort;
import org.moe.common.ShutdownManager;
import org.moe.common.utils.ProxyUtil;
import org.moe.ios.device.ConnectionHelper;
import org.moe.ios.device.ConnectionInputStream;
import org.moe.ios.device.ConnectionLock;
import org.moe.ios.device.ConnectionOutputStream;
import org.moe.ios.device.launcher.Configuration;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.PtrFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHelper.class);

    public static void launch(idevice_t device, Configuration configuration) {
        if (configuration.getJdwpPort() == null && configuration.getProxyPorts().size() == 0) {
            return;
        }
        ProxyPort debugPort = configuration.getJdwpPort();
        AtomicBoolean shuttingDown = new AtomicBoolean(false);
        if (debugPort != null) {
            LOG.debug("Starting debug server: " + debugPort);
            ProxyHelper.createProxyServer(debugPort, device, shuttingDown);
        }
        ArrayList<ProxyPort> proxyPorts = configuration.getProxyPorts();
        for (ProxyPort port : proxyPorts) {
            LOG.debug("Starting proxy server: " + port);
            ProxyHelper.createProxyServer(port, device, shuttingDown);
        }
    }

    static void createProxyServer(final ProxyPort port, final idevice_t device, final AtomicBoolean isInShutdown) {
        final Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.debug(port.getRemotePort() + ": Trying to connect to remote");
                Ptr<Class<idevice_connection_t>> conn_ptr = PtrFactory.newOpaquePtrReference(idevice_connection_t.class);
                int err = 0;
                do {
                    if (err != 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    err = Globals.idevice_connect(device, (char)(port.getShortRemotePort() & 0xFFFF), conn_ptr);
                } while (!Thread.currentThread().isInterrupted() && err != 0 && !isInShutdown.get());
                final idevice_connection_t conn = (idevice_connection_t)conn_ptr.get();
                if (Thread.currentThread().isInterrupted() || err != 0) {
                    if (err == 0) {
                        Globals.idevice_disconnect(conn);
                    }
                    return;
                }
                LOG.debug(port.getRemotePort() + ": Connected to remote");
                final ConnectionLock dscisLock = new ConnectionLock();
                final ConnectionLock dscosLock = new ConnectionLock();
                ConnectionInputStream<idevice_connection_t> dscis = ConnectionHelper.getInputStream(conn, dscisLock);
                ConnectionOutputStream<idevice_connection_t> dscos = ConnectionHelper.getOutputStream(conn, dscosLock);
                Runnable disconnectHook = new Runnable(){

                    @Override
                    public void run() {
                        dscisLock.lockAndClose();
                        dscosLock.lockAndClose();
                        Globals.idevice_disconnect(conn);
                        dscisLock.unlock();
                        dscosLock.unlock();
                    }
                };
                ShutdownManager.register(disconnectHook);
                ProxyUtil proxyUtil = ProxyUtil.create(port.getLocalPort(), dscis, dscos);
                proxyUtil.registerShutdownHook();
            }
        });
        thread2.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                thread2.interrupt();
                try {
                    thread2.join(10000L);
                }
                catch (InterruptedException e) {
                    LOG.debug(port.getRemotePort() + ": Failed to join remote connect thread");
                }
            }
        }));
    }
}

