/*
 * Decompiled with CFR 0.152.
 */
package org.moe.ios.device.launcher;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.libimobiledevice.c.Globals;
import org.libimobiledevice.struct.idevice_event_t;
import org.moe.natj.general.ptr.VoidPtr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USBDeviceWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(USBDeviceWatcher.class);
    private final Lock lock = new ReentrantLock();
    private final ArrayList<IUSBDeviceListener> listeners = new ArrayList();
    private final ConcurrentLinkedQueue<IUSBDeviceListener> initializingListeners = new ConcurrentLinkedQueue();
    private final ArrayList<String> connectedDevices = new ArrayList();

    private USBDeviceWatcher() {
        Globals.idevice_event_subscribe(new Globals.Function_idevice_event_subscribe(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call_idevice_event_subscribe(idevice_event_t event, VoidPtr context) {
                LOG.debug("Event: " + event.event() + ", conn_type: " + event.conn_type());
                if (event.conn_type() != 1) {
                    return;
                }
                while (!USBDeviceWatcher.this.initializingListeners.isEmpty()) {
                    Thread.yield();
                }
                USBDeviceWatcher.this.lock.lock();
                int eventType = event.event();
                String eventUDID = event.udid();
                if (eventType == 1) {
                    if (!USBDeviceWatcher.this.connectedDevices.contains(eventUDID)) {
                        USBDeviceWatcher.this.connectedDevices.add(eventUDID);
                    }
                } else if (USBDeviceWatcher.this.connectedDevices.contains(eventUDID)) {
                    USBDeviceWatcher.this.connectedDevices.remove(eventUDID);
                }
                try {
                    for (IUSBDeviceListener listener : USBDeviceWatcher.this.listeners) {
                        try {
                            listener.handle(eventType, eventUDID);
                        }
                        catch (Exception e) {
                            LOG.error("Exception in idevice_event_subscribe listener", e);
                        }
                    }
                }
                finally {
                    USBDeviceWatcher.this.lock.unlock();
                }
            }
        }, null);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Globals.idevice_event_unsubscribe();
            }
        }));
    }

    public static void register(IUSBDeviceListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Holder.INSTANCE.registerListener(listener);
    }

    public static void unregister(IUSBDeviceListener listener) {
        if (listener == null) {
            return;
        }
        Holder.INSTANCE.unregisterListener(listener);
    }

    private void registerListener(final IUSBDeviceListener listener) {
        this.lock.lock();
        try {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
            this.initializingListeners.add(listener);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    USBDeviceWatcher.this.lock.lock();
                    try {
                        for (String device : USBDeviceWatcher.this.connectedDevices) {
                            listener.handle(1, device);
                        }
                    }
                    finally {
                        USBDeviceWatcher.this.initializingListeners.remove(listener);
                        USBDeviceWatcher.this.lock.unlock();
                    }
                }
            }).start();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unregisterListener(IUSBDeviceListener listener) {
        this.lock.lock();
        try {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Holder {
        public static final USBDeviceWatcher INSTANCE = new USBDeviceWatcher();

        private Holder() {
        }
    }

    public static interface IUSBDeviceListener {
        public void handle(int var1, String var2);
    }
}

