/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.DoublePtr;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class DoublePtrImpl
extends VoidPtrImpl
implements DoublePtr {
    protected static final int ELEM_SIZE = 8;

    protected DoublePtrImpl(Pointer peer) {
        super(peer);
    }

    protected DoublePtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    DoublePtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocDouble(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Double get() {
        return this.getValue(0);
    }

    @Override
    public final Double get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final double getValue() {
        return this.getValue(0);
    }

    @Override
    public double getValue(int idx) {
        return CRuntime.loadDouble(this.getRoot(), idx);
    }

    public final Double[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Double[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Double[] array = new Double[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final double[] toDoubleArray(int length) {
        return this.toDoubleArray(0, length);
    }

    @Override
    public double[] toDoubleArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createDoubleArray(this.getRoot() + (long)(fromIndex * 8), toIndex - fromIndex);
    }

    public final void copyTo(Double[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Double[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Double[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = CRuntime.loadDouble(root, srcOffset);
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(double[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(double[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, double[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeDoubleArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Double obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Double obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(double value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, double value) {
        CRuntime.storeDouble(this.getRoot(), idx, value);
    }

    public void copyFrom(Double[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Double[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Double[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Double[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeDouble(root, destOffset, src[srcOffset]);
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(double[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(double[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(double[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(double[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyDoubleArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public DoublePtr ofs(int elemOffset) {
        return new DoublePtrImpl(this.getRoot() + (long)(elemOffset * 8), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final DoublePtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public DoublePtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedDoublePtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    private static class GuardedConstDoublePtrImpl
    extends GuardedDoublePtrImpl {
        public GuardedConstDoublePtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Double obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Double obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Double[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Double[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Double[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Double[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoublePtr ofs(int elemOffset) {
            return new GuardedConstDoublePtrImpl(this.getRoot() + (long)(elemOffset * 8), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public DoublePtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstDoublePtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedDoublePtrImpl
    extends DoublePtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedDoublePtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public double getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Double[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public double[] toDoubleArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toDoubleArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Double[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, double[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, double value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Double[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(double[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public DoublePtr ofs(int elemOffset) {
            return new GuardedDoublePtrImpl(this.getRoot() + (long)(elemOffset * 8), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public DoublePtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedDoublePtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstDoublePtrImpl
    extends DoublePtrImpl {
        protected ConstDoublePtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstDoublePtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstDoublePtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Double obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Double obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Double[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Double[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Double[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Double[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(double[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(double[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoublePtr ofs(int elemOffset) {
            return new ConstDoublePtrImpl(this.getRoot() + (long)(elemOffset * 8), this);
        }

        @Override
        public DoublePtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstDoublePtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

