/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.FloatPtr;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class FloatPtrImpl
extends VoidPtrImpl
implements FloatPtr {
    protected static final int ELEM_SIZE = 4;

    protected FloatPtrImpl(Pointer peer) {
        super(peer);
    }

    protected FloatPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    FloatPtrImpl(int capacity, boolean owned) {
        super(CRuntime.allocFloat(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Float get() {
        return Float.valueOf(this.getValue(0));
    }

    @Override
    public final Float get(int idx) {
        return Float.valueOf(this.getValue(idx));
    }

    @Override
    public final float getValue() {
        return this.getValue(0);
    }

    @Override
    public float getValue(int idx) {
        return CRuntime.loadFloat(this.getRoot(), idx);
    }

    public final Float[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Float[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Float[] array = new Float[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final float[] toFloatArray(int length) {
        return this.toFloatArray(0, length);
    }

    @Override
    public float[] toFloatArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return CRuntime.createFloatArray(this.getRoot() + (long)(fromIndex * 4), toIndex - fromIndex);
    }

    public final void copyTo(Float[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Float[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Float[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = Float.valueOf(CRuntime.loadFloat(root, srcOffset));
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public final void copyTo(float[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(float[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, float[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFromNativeFloatArray(dest, destOffset, this.getRoot(), srcOffset, length);
    }

    @Override
    public void set(Float obj) {
        this.setValue(obj.floatValue());
    }

    @Override
    public void set(int idx, Float obj) {
        this.setValue(idx, obj.floatValue());
    }

    @Override
    public void setValue(float value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, float value) {
        CRuntime.storeFloat(this.getRoot(), idx, value);
    }

    public void copyFrom(Float[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Float[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Float[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Float[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        int i = 0;
        while (i < length) {
            CRuntime.storeFloat(root, destOffset, src[srcOffset].floatValue());
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public void copyFrom(float[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(float[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(float[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(float[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        CRuntime.copyFloatArray(this.getRoot(), destOffset, src, srcOffset, length);
    }

    @Override
    public FloatPtr ofs(int elemOffset) {
        return new FloatPtrImpl(this.getRoot() + (long)(elemOffset * 4), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final FloatPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public FloatPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedFloatPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    private static class GuardedConstFloatPtrImpl
    extends GuardedFloatPtrImpl {
        public GuardedConstFloatPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Float obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Float obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Float[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Float[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Float[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Float[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FloatPtr ofs(int elemOffset) {
            return new GuardedConstFloatPtrImpl(this.getRoot() + (long)(elemOffset * 4), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public FloatPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstFloatPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedFloatPtrImpl
    extends FloatPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedFloatPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public float getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx).floatValue();
        }

        @Override
        public Float[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public float[] toFloatArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toFloatArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Float[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, float[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, float value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, Float.valueOf(value));
        }

        @Override
        public void copyFrom(Float[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(float[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public FloatPtr ofs(int elemOffset) {
            return new GuardedFloatPtrImpl(this.getRoot() + (long)(elemOffset * 4), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public FloatPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedFloatPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstFloatPtrImpl
    extends FloatPtrImpl {
        protected ConstFloatPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstFloatPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstFloatPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Float obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Float obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Float[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Float[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Float[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Float[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(float[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(float[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final FloatPtr ofs(int elemOffset) {
            return new ConstFloatPtrImpl(this.getRoot() + (long)(elemOffset * 4), this);
        }

        @Override
        public FloatPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstFloatPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

