/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.c.StructObject;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.AbstractNativeObjectPtr;

class StructPtrImpl<T extends StructObject>
extends AbstractNativeObjectPtr<T> {
    protected final long sizeof;

    protected StructPtrImpl(Class<T> type, Pointer peer) {
        super(type, NatJ.getOrCreateInstanceOfRuntimeClass(CRuntime.class), peer);
        this.sizeof = CRuntime.sizeOfNativeObject(type);
    }

    private StructPtrImpl(Class<T> type, long peer, Object bufferOwner) {
        super(type, NatJ.getOrCreateInstanceOfRuntimeClass(CRuntime.class), peer, bufferOwner);
        this.sizeof = CRuntime.sizeOfNativeObject(type);
    }

    StructPtrImpl(Class<T> type, int capacity, boolean owned) {
        super(type, NatJ.getOrCreateInstanceOfRuntimeClass(CRuntime.class), CRuntime.allocNativeObject(type, capacity), owned);
        this.sizeof = CRuntime.sizeOfNativeObject(type);
    }

    private final long getPointer(int idx) {
        return this.getRoot() + this.sizeof * (long)idx;
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public T get(int idx) {
        long ptr = CRuntime.allocNativeObject(this.type, 1);
        CRuntime.copyNativeObject(this.type, ptr, this.getPointer(idx));
        return (T)((StructObject)this.getJavaValue(ptr, true));
    }

    final T getRef(int idx) {
        return (T)((StructObject)this.getJavaValue(this.getPointer(idx)));
    }

    @Override
    public void set(int idx, T obj) {
        CRuntime.copyNativeObject(this.type, this.getPointer(idx), this.getNativeValue(obj));
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public Ptr<T> getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedStructPtrImpl(this.type, this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public Ptr<T> ofs(int elemOffset) {
        return new StructPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, (Object)this);
    }

    private static class GuardedConstStructPtrImpl<T extends StructObject>
    extends GuardedStructPtrImpl<T> {
        public GuardedConstStructPtrImpl(Class<T> type, long peer, Object bufferOwner, int low, int hi) {
            super(type, peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(T[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<T> ofs(int elemOffset) {
            return new GuardedConstStructPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstStructPtrImpl<T>(this.type, this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedStructPtrImpl<T extends StructObject>
    extends StructPtrImpl<T>
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedStructPtrImpl(Class<T> type, long peer, Object bufferOwner, int low, int hi) {
            super(type, peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public T get(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return (T)super.get(idx);
        }

        @Override
        public void copyTo(int srcOffset, T[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, (E[])dest, destOffset, length);
        }

        @Override
        public void set(int idx, T value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom((E[])src, srcOffset, destOffset, length);
        }

        @Override
        public Ptr<T> ofs(int elemOffset) {
            return new GuardedStructPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedStructPtrImpl<T>(this.type, this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstStructPtrImpl<T extends StructObject>
    extends StructPtrImpl<T> {
        protected ConstStructPtrImpl(Class<T> type, Pointer peer) {
            super(type, peer);
        }

        private ConstStructPtrImpl(Class<T> type, long peer, Object bufferOwner) {
            super(type, peer, bufferOwner);
        }

        ConstStructPtrImpl(Class<T> type, int capacity, boolean owned) {
            super(type, capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public final void set(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int idx, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(T[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(T[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Ptr<T> ofs(int elemOffset) {
            return new ConstStructPtrImpl<T>(this.type, this.getRoot() + (long)elemOffset * this.sizeof, (Object)this);
        }

        @Override
        public Ptr<T> getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstStructPtrImpl(this.type, this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

