/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.objc.map;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.moe.natj.general.Mapper;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.WeakReference;
import org.moe.natj.objc.ann.ObjCBlock;

@Runtime(value=ObjCRuntime.class)
public class ObjCCallbackMapper
implements Mapper {
    public Map<Object, WeakReference[]> instance2callbacks = new WeakHashMap<Object, WeakReference[]>();
    public Map<Class<?>, Long> class2data = new HashMap();
    public Map<Class<?>, NativeBlockInfo> block2blockInfo = new HashMap();
    private static Pointer.Releaser strongBlockBindingReleaser = new Pointer.Releaser(){

        @Override
        public void release(long peer) {
            ObjCRuntime.lockObject(peer);
            Object instance = ObjCRuntime.getJavaReferenceOfBindingObject(peer);
            if (instance == null) {
                ObjCRuntime.setJavaReferenceOfBindingObject(peer, null);
            }
            ObjCRuntime.unlockObject(peer);
            ObjCRuntime.releaseObject(peer);
        }

        @Override
        public boolean ifFinalizedExternally() {
            return false;
        }
    };

    public static Pointer createStrongBlockBindingPointer(long peer, boolean owned) {
        if (!owned) {
            ObjCRuntime.retainObject(peer);
        }
        return new Pointer(peer, strongBlockBindingReleaser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupObjCBlock(Object instance, Method method) {
        WeakReference[] cache;
        Map<Object, WeakReference[]> map = instance;
        synchronized (map) {
            cache = (WeakReference[])NatJ.getObjectCacheForRuntime(ObjCRuntime.class, instance);
        }
        if (cache == null) {
            map = this.instance2callbacks;
            synchronized (map) {
                cache = this.instance2callbacks.get(instance);
            }
        }
        if (cache == null) {
            throw new RuntimeException("No cached value fount in ObjC callback Mapper");
        }
        int idx = NatJ.getMethodIndex(method);
        WeakReference[] weakReferenceArray = cache;
        synchronized (cache) {
            WeakReference reference = cache[idx];
            if (reference != null && reference.getPeer() == null) {
                cache[idx] = null;
            }
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return;
        }
    }

    public Pointer getNativeBlockPeer(Object instance) {
        if (Proxy.isProxyClass(instance.getClass())) {
            try {
                InvocationHandler handler = Proxy.getInvocationHandler(instance);
                if (handler != null && handler instanceof BlockInvocationHandler) {
                    return ((BlockInvocationHandler)Proxy.getInvocationHandler((Object)instance)).peer;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public Pointer getJavaBlockPeer(Object instance, String name, Class<?>[] argTypes) {
        long peer;
        if (!(Proxy.isProxyClass(instance.getClass()) && Proxy.getInvocationHandler(instance) != null && Proxy.getInvocationHandler(instance) instanceof BlockInvocationHandler || (peer = this.getNativeCallback(instance, name, argTypes, false)) == 0L)) {
            return ObjCRuntime.createStrongPointer(peer, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private long getNativeCallback(Object instance, String name, Class<?>[] argTypes, boolean toCreate) {
        Object countRef22;
        int[] idxRef;
        if (instance == null) {
            return 0L;
        }
        Class<?> cls = instance.getClass();
        Method method = NatJ.getMethod(cls, name, argTypes, idxRef = new int[1], countRef22 = new int[1]);
        if (method == null) {
            return 0L;
        }
        int idx = idxRef[0];
        int count = countRef22[0];
        WeakReference[] cache = null;
        try {
            Object object = instance;
            countRef22 = object;
            // MONITORENTER : object
            cache = (WeakReference[])NatJ.getOrCreateObjectCacheForRuntime(ObjCRuntime.class, instance, new ObjCCallbackCacheConstructor(count));
            // MONITOREXIT : countRef22
        }
        catch (Exception countRef22) {
            // empty catch block
        }
        if (cache == null) {
            Map<Object, WeakReference[]> map = this.instance2callbacks;
            countRef22 = map;
            // MONITORENTER : map
            cache = this.instance2callbacks.get(instance);
            if (cache == null) {
                cache = new WeakReference[count];
                this.instance2callbacks.put(instance, cache);
            }
            // MONITOREXIT : countRef22
        }
        long peer = 0L;
        WeakReference[] weakReferenceArray = cache;
        // MONITORENTER : cache
        WeakReference reference = cache[idx];
        if (reference != null) {
            peer = reference.getNativePeer();
        }
        if (peer == 0L && toCreate) {
            Map<Class<?>, Long> map = this.class2data;
            // MONITORENTER : map
            Long data = this.class2data.get(cls);
            if (data == null) {
                data = new Long(ObjCRuntime.createDataForJavaBlock(method));
                this.class2data.put(cls, data);
            }
            // MONITOREXIT : map
            peer = ObjCRuntime.createNativeCallbackFromJavaInstance(instance, data);
            cache[idx] = reference = ObjCRuntime.createWeakReference(peer);
        }
        // MONITOREXIT : weakReferenceArray
        return peer;
    }

    public boolean dispose(Object object) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(object.getClass()) && (handler = Proxy.getInvocationHandler(object)) instanceof BlockInvocationHandler) {
            Pointer peer = ((BlockInvocationHandler)handler).peer;
            long pointer = peer.getPeer();
            ObjCRuntime.lockObject(pointer);
            ObjCRuntime.setJavaReferenceOfBindingObject(pointer, null);
            peer.setPeer(0L);
            ObjCRuntime.unlockObject(pointer);
            ObjCRuntime.releaseObject(pointer);
            return true;
        }
        return false;
    }

    @Override
    public long toNative(Object instance, NatJ.NativeObjectConstructionInfo info) {
        long peer;
        if (instance == null) {
            return 0L;
        }
        if (info.callback == null) {
            throw new RuntimeException("Invalid callback construction info!");
        }
        Pointer pointer = this.getNativeBlockPeer(instance);
        if (pointer == null) {
            ObjCBlock blck = (ObjCBlock)info.callback;
            peer = this.getNativeCallback(instance, blck.name(), blck.argTypes(), true);
        } else {
            peer = pointer.getPeer();
            ObjCRuntime.retainObject(peer);
        }
        if (peer == 0L) {
            return 0L;
        }
        if (!info.owned) {
            ObjCRuntime.autoreleaseObject(peer);
        }
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object objectToJava(long peer, NatJ.JavaObjectConstructionInfo info) {
        Object instance;
        block24: {
            boolean isStackBlock;
            instance = null;
            boolean bl = isStackBlock = info.arg && ObjCRuntime.isStackBlock(peer);
            if (isStackBlock) {
                peer = ObjCRuntime.copyBlock(peer);
            } else {
                ObjCRuntime.lockObject(peer);
            }
            try {
                if (!isStackBlock) {
                    instance = ObjCRuntime.getJavaReferenceOfBindingObject(peer);
                }
                if (instance == null) {
                    Pointer pointer = ObjCCallbackMapper.createStrongBlockBindingPointer(peer, info.arg ? isStackBlock : info.owned);
                    NativeBlockInfo blockInfo = null;
                    NatJ.JavaObjectConstructionInfo javaObjectConstructionInfo = info;
                    synchronized (javaObjectConstructionInfo) {
                        Object[] cache;
                        if (info.data == null) {
                            cache = new Object[]{null, null, null};
                            info.data = cache;
                        } else {
                            cache = (Object[])info.data;
                            blockInfo = (NativeBlockInfo)cache[0];
                        }
                        if (blockInfo == null) {
                            Map<Class<?>, NativeBlockInfo> map = this.block2blockInfo;
                            synchronized (map) {
                                blockInfo = this.block2blockInfo.get(info.type);
                                if (blockInfo == null) {
                                    blockInfo = new NativeBlockInfo();
                                    ObjCBlock block = (ObjCBlock)info.callback;
                                    int[] idxRef = new int[1];
                                    int[] countRef = new int[1];
                                    Method method = NatJ.getMethod(info.type, block.name(), block.argTypes(), idxRef, countRef);
                                    if (method == null) {
                                        throw new RuntimeException("Could not find Java method for native callback!");
                                    }
                                    blockInfo.data = ObjCRuntime.createDataForNativeBlock(method);
                                    Class<?> returnType = method.getReturnType();
                                    Class handler = returnType == Boolean.TYPE ? BooleanInvocationHandler.class : (returnType == Byte.TYPE ? ByteInvocationHandler.class : (returnType == Character.TYPE ? CharacterInvocationHandler.class : (returnType == Short.TYPE ? ShortInvocationHandler.class : (returnType == Integer.TYPE ? IntegerInvocationHandler.class : (returnType == Long.TYPE ? LongInvocationHandler.class : (returnType == Float.TYPE ? FloatInvocationHandler.class : (returnType == Double.TYPE ? DoubleInvocationHandler.class : (returnType == Void.TYPE ? VoidInvocationHandler.class : ObjectInvocationHandler.class))))))));
                                    try {
                                        blockInfo.handlerConstructor = handler.getConstructor(String.class, Pointer.class, Long.TYPE);
                                        blockInfo.proxyConstructor = Proxy.getProxyClass(info.type.getClassLoader(), info.type).getConstructor(InvocationHandler.class);
                                    }
                                    catch (NoSuchMethodException e) {
                                        throw new RuntimeException("Could not find proxy for native block!", e);
                                    }
                                    this.block2blockInfo.put(info.type, blockInfo);
                                }
                            }
                            cache[0] = blockInfo;
                        }
                    }
                    try {
                        instance = blockInfo.proxyConstructor.newInstance(blockInfo.handlerConstructor.newInstance(info.type.getName(), pointer, blockInfo.data));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Java object construction error!", e);
                    }
                    ObjCRuntime.setJavaReferenceOfBindingObject(peer, instance);
                    break block24;
                }
                if (!info.arg && info.owned) {
                    ObjCRuntime.releaseObject(peer);
                }
            }
            finally {
                if (!isStackBlock) {
                    ObjCRuntime.unlockObject(peer);
                }
            }
        }
        return instance;
    }

    @Override
    public Object toJava(long peer, NatJ.JavaObjectConstructionInfo info) {
        if (peer == 0L) {
            return null;
        }
        Object instance = ObjCRuntime.getInstanceForJavaBlock(peer);
        if (instance == null && info.type.isInterface()) {
            return this.objectToJava(peer, info);
        }
        if (!info.arg && info.owned) {
            ObjCRuntime.releaseObject(peer);
        }
        return instance;
    }

    private static class ObjectInvocationHandler
    extends BlockInvocationHandler {
        public ObjectInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return ObjCRuntime.forwardObjectBlockCall(this.peer.getPeer(), this.data, args2);
        }
    }

    private static class VoidInvocationHandler
    extends BlockInvocationHandler {
        public VoidInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            ObjCRuntime.forwardVoidBlockCall(this.peer.getPeer(), this.data, args2);
            return null;
        }
    }

    private static class DoubleInvocationHandler
    extends BlockInvocationHandler {
        public DoubleInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Double(ObjCRuntime.forwardDoubleBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class FloatInvocationHandler
    extends BlockInvocationHandler {
        public FloatInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Float(ObjCRuntime.forwardFloatBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class LongInvocationHandler
    extends BlockInvocationHandler {
        public LongInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Long(ObjCRuntime.forwardLongBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class IntegerInvocationHandler
    extends BlockInvocationHandler {
        public IntegerInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Integer(ObjCRuntime.forwardIntBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class ShortInvocationHandler
    extends BlockInvocationHandler {
        public ShortInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Short(ObjCRuntime.forwardShortBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class CharacterInvocationHandler
    extends BlockInvocationHandler {
        public CharacterInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Character(ObjCRuntime.forwardCharBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class ByteInvocationHandler
    extends BlockInvocationHandler {
        public ByteInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Byte(ObjCRuntime.forwardByteBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static class BooleanInvocationHandler
    extends BlockInvocationHandler {
        public BooleanInvocationHandler(String name, Pointer peer, long data) {
            super(name, peer, data);
        }

        @Override
        public Object invoke0(Object proxy, Method method, Object[] args2) {
            return new Boolean(ObjCRuntime.forwardBooleanBlockCall(this.peer.getPeer(), this.data, args2));
        }
    }

    private static abstract class BlockInvocationHandler
    implements InvocationHandler {
        private static Method hashCodeMethod;
        private static Method equalsMethod;
        private static Method toStringMethod;
        private final String name;
        public Pointer peer;
        public long data;

        protected BlockInvocationHandler(String name, Pointer peer, long data) {
            this.name = name;
            this.peer = peer;
            this.data = data;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) {
                if (method.equals(hashCodeMethod)) {
                    return this.proxyHashCode(proxy);
                }
                if (method.equals(equalsMethod)) {
                    return this.proxyEquals(proxy, args2[0]);
                }
                if (method.equals(toStringMethod)) {
                    return this.proxyToString(proxy);
                }
                throw new InternalError("unexpected Object method dispatched: " + method);
            }
            return this.invoke0(proxy, method, args2);
        }

        protected Integer proxyHashCode(Object proxy) {
            return new Integer(System.identityHashCode(proxy));
        }

        protected Boolean proxyEquals(Object proxy, Object other) {
            return proxy == other ? Boolean.TRUE : Boolean.FALSE;
        }

        protected String proxyToString(Object proxy) {
            return this.name + '@' + Integer.toHexString(proxy.hashCode());
        }

        protected abstract Object invoke0(Object var1, Method var2, Object[] var3);

        static {
            try {
                hashCodeMethod = Object.class.getMethod("hashCode", null);
                equalsMethod = Object.class.getMethod("equals", Object.class);
                toStringMethod = Object.class.getMethod("toString", null);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }
    }

    private static class NativeBlockInfo {
        public Constructor<?> proxyConstructor;
        public Constructor<?> handlerConstructor;
        public long data;

        private NativeBlockInfo() {
        }
    }

    private class ObjCCallbackCacheConstructor
    implements NatJ.CacheConstructor {
        int size;

        public ObjCCallbackCacheConstructor(int size) {
            this.size = size;
        }

        @Override
        public Object constructCache() {
            return new WeakReference[this.size];
        }
    }
}

