/*
 * Decompiled with CFR 0.152.
 */
package org.moe.protocol.gdbremote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.moe.protocol.gdbremote.IStopReplyListener;
import org.moe.protocol.gdbremote.PacketOutputStream;
import org.moe.protocol.gdbremote.Util;

final class Communication {
    private static final String ACK_OK = "+";
    private static final String ACK_NOK = "-";
    private final DataInputStream dis;
    private final DataOutputStream dos;
    private boolean noAckMode = false;
    private final ArrayList<IStopReplyListener> listeners = new ArrayList();
    private Thread inputProcessingThread;
    private final ConcurrentLinkedQueue<String> ackQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<String> responsePacketQueue = new ConcurrentLinkedQueue();

    Communication(InputStream is, OutputStream os) throws IOException {
        if (is == null || os == null) {
            throw new NullPointerException();
        }
        this.dis = new DataInputStream(new BufferedInputStream(is, 8192));
        this.dos = new DataOutputStream(new BufferedOutputStream(os, 8192));
        this._startInputProcessing();
        this._send_acknowledgment(true);
    }

    private void _startInputProcessing() {
        this.inputProcessingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(2112);
                    while (!Thread.currentThread().isInterrupted()) {
                        int _byte = Communication.this.dis.read();
                        if (_byte == 43) {
                            Communication.this.ackQueue.add(Communication.ACK_OK);
                            continue;
                        }
                        if (_byte == 45) {
                            Communication.this.ackQueue.add(Communication.ACK_NOK);
                            continue;
                        }
                        if (_byte == 36) {
                            _byte = Communication.this.dis.readByte();
                            int calc_hash = 0;
                            while (_byte != 35) {
                                calc_hash += _byte;
                                baos.write(_byte);
                                _byte = Communication.this.dis.readByte();
                            }
                            int pkt_hash = Communication.getValueOfHex((char)Communication.this.dis.readByte());
                            pkt_hash <<= 4;
                            if (Communication.this.isInNoAckMode() || (pkt_hash += Communication.getValueOfHex((char)Communication.this.dis.readByte())) == (calc_hash %= 256)) {
                                Communication.this._dispatchPacket(baos.toString("ASCII"));
                                Communication.this._send_acknowledgment(true);
                            } else {
                                Communication.this._send_acknowledgment(false);
                            }
                            baos.reset();
                            continue;
                        }
                        if (_byte == -1) break;
                        throw new IOException("unrecognized packet");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.inputProcessingThread.start();
    }

    private void _dispatchPacket(String packet) {
        if (!this._forwardToListeners(packet)) {
            this.responsePacketQueue.add(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(IStopReplyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<IStopReplyListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeListener(IStopReplyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<IStopReplyListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _forwardToListeners(String packet) {
        if (packet.startsWith("S")) {
            if (!packet.matches("T\\d\\d")) {
                return false;
            }
            int code = Integer.parseInt(packet.substring(1, 3), 16);
            ArrayList<IStopReplyListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (IStopReplyListener listener : this.listeners) {
                    listener.processSignaled((byte)code, null);
                }
            }
            return true;
        }
        if (packet.startsWith("T")) {
            if (!packet.matches("T\\d\\d([\\w\\d]+\\:[\\w\\d=]+;)*")) {
                return false;
            }
            int code = Integer.parseInt(packet.substring(1, 3), 16);
            Map<String, String> info = Util.converToMap(packet.substring(3), ";", ":");
            ArrayList<IStopReplyListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (IStopReplyListener listener : this.listeners) {
                    listener.processSignaled((byte)code, info);
                }
            }
            return true;
        }
        if (packet.startsWith("W")) {
            if (!packet.matches("W\\d\\d(process\\:[\\w\\d]+;)?")) {
                return false;
            }
            int code = Integer.parseInt(packet.substring(1, 3), 16);
            ArrayList<IStopReplyListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (IStopReplyListener listener : this.listeners) {
                    listener.processExited((byte)code);
                }
            }
            return true;
        }
        if (packet.startsWith("X")) {
            if (!packet.matches("X\\d\\d(process\\:[\\w\\d]+;)?")) {
                return false;
            }
            int code = Integer.parseInt(packet.substring(1, 3), 16);
            ArrayList<IStopReplyListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (IStopReplyListener listener : this.listeners) {
                    listener.processTerminated((byte)code);
                }
            }
            return true;
        }
        if (packet.startsWith("O")) {
            if (packet.length() % 2 != 1) {
                return false;
            }
            if (!packet.matches("O([a-fA-F0-9][a-fA-F0-9])*")) {
                return false;
            }
            String msg = Communication.decodeHex(packet, 1, packet.length());
            ArrayList<IStopReplyListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (IStopReplyListener listener : this.listeners) {
                    listener.processOutput(msg);
                }
            }
            return true;
        }
        return false;
    }

    static String decodeHex(String packet, int start, int end) {
        if ((end - start) % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] chars = new byte[(end - start) / 2];
        for (int idx = start; idx < end; idx += 2) {
            byte c = 0;
            c = (byte)(c + Communication.getValueOfHex(packet.charAt(idx + 0)));
            c = (byte)(c << 4);
            chars[(idx - start) / 2] = c = (byte)(c + Communication.getValueOfHex(packet.charAt(idx + 1)));
        }
        return new String(chars);
    }

    static byte getValueOfHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(ch - 55);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(ch - 87);
        }
        return -1;
    }

    private void _send_acknowledgment(boolean ack) throws IOException {
        if (!this.isInNoAckMode()) {
            if (ack) {
                this.dos.write(43);
                this.dos.flush();
            } else {
                this.dos.write(45);
                this.dos.flush();
            }
        }
    }

    PacketOutputStream newPacket() throws IOException {
        return new PacketOutputStream(this, this.dos);
    }

    boolean getAck() throws IOException {
        if (this.isInNoAckMode()) {
            return true;
        }
        while (this.ackQueue.size() == 0) {
            if (this.inputProcessingThread == null || !this.inputProcessingThread.isAlive()) {
                throw new IOException("waiting for ack failed, connection closed");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException("waiting for ack interrupted");
            }
        }
        return this.ackQueue.poll() == ACK_OK;
    }

    boolean isInNoAckMode() {
        return this.noAckMode;
    }

    void setNoAckMode(boolean noAckMode) {
        this.noAckMode = noAckMode;
    }

    boolean sendASCIIPacket(String string) throws IOException {
        PacketOutputStream pos = this.newPacket();
        pos.writeASCII(string);
        return pos.send();
    }

    String nextResponse() throws IOException {
        while (this.responsePacketQueue.size() == 0) {
            if (this.inputProcessingThread == null || !this.inputProcessingThread.isAlive()) {
                throw new IOException("waiting for response failed, connection closed");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException("waiting for response interrupted");
            }
        }
        return this.responsePacketQueue.poll();
    }

    void close() {
        try {
            if (this.inputProcessingThread != null && !this.inputProcessingThread.isAlive()) {
                this.inputProcessingThread.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

