/*
 * Decompiled with CFR 0.152.
 */
package org.moe.protocol.gdbremote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.moe.protocol.gdbremote.Communication;
import org.moe.protocol.gdbremote.IStopReplyListener;
import org.moe.protocol.gdbremote.PacketOutputStream;
import org.moe.protocol.gdbremote.Util;

public final class GDBRemoteProtocol {
    private final Communication comm;
    public static final int THREAD_ID_ANY = 0;
    public static final int THREAD_ID_ALL = -1;
    public static final byte VCONT_ACTION_CONTINUE = 99;
    public static final byte VCONT_ACTION_STEP = 115;
    public static final byte VCONT_ACTION_STOP = 116;
    public static final String LAUNCH_ARCH_I386 = "i386";
    public static final String LAUNCH_ARCH_X86_64 = "x86_64";
    public static final String LAUNCH_ARCH_ARM64 = "arm64";
    public static final String LAUNCH_ARCH_ARM = "arm";

    public GDBRemoteProtocol(InputStream is, OutputStream os) throws IOException {
        this.comm = new Communication(is, os);
    }

    public void addListener(IStopReplyListener listener) {
        this.comm.addListener(listener);
    }

    public boolean removeListener(IStopReplyListener listener) {
        return this.comm.removeListener(listener);
    }

    private int _get_OK_ENN_Response() throws IOException {
        String resp = this.comm.nextResponse();
        if ("OK".equals(resp)) {
            return 0;
        }
        if (resp != null && resp.matches("E[0-9a-fA-F][0-9a-fA-F]")) {
            return Integer.parseInt(resp.substring(1), 16);
        }
        return -1;
    }

    private String _get_OK_EMSG_Response() throws IOException {
        String resp = this.comm.nextResponse();
        if ("OK".equals(resp)) {
            return null;
        }
        if (resp != null && resp.startsWith("E")) {
            return resp.substring(1);
        }
        return "Unknown error";
    }

    private boolean _get_OK_NOTSUPPORTED_Response() throws IOException {
        String resp = this.comm.nextResponse();
        return "OK".equals(resp);
    }

    public int send_Arguments(String ... args2) throws IOException {
        PacketOutputStream pos = this.comm.newPacket();
        pos.write(65);
        if (args2 != null && args2.length != 0) {
            int arg_idx = 0;
            String last_arg = args2[args2.length - 1];
            for (String arg : args2) {
                byte[] bytes = arg.getBytes("UTF-8");
                pos.writeInteger(bytes.length * 2);
                pos.write(44);
                pos.writeInteger(arg_idx++);
                pos.write(44);
                pos.writeHex(bytes);
                if (arg == last_arg) continue;
                pos.write(44);
            }
        }
        if (!pos.send()) {
            return -1;
        }
        return this._get_OK_ENN_Response();
    }

    public List<String> send_vCont_Q() throws IOException {
        if (!this.comm.sendASCIIPacket("vCont?")) {
            return null;
        }
        String resp = this.comm.nextResponse();
        if (resp.length() == 0) {
            return null;
        }
        List<String> list = Util.convertToList(resp, ";");
        list.remove("vCont");
        return list;
    }

    public boolean send_vCont(byte action, int thread_id) throws IOException {
        PacketOutputStream pos = this.comm.newPacket();
        pos.writeASCII("vCont;");
        pos.write(action & 0xFF);
        pos.write(58);
        pos.writeInteger(thread_id);
        return pos.send();
    }

    public boolean send_vAttach(int pid) throws IOException {
        PacketOutputStream pos = this.comm.newPacket();
        pos.writeASCII("vAttach;");
        pos.writeHexInteger(pid);
        return pos.send();
    }

    public int send_H(byte action, int thread_id) throws IOException {
        PacketOutputStream pos = this.comm.newPacket();
        pos.writeASCII("H");
        pos.write(action);
        pos.writeInteger(thread_id);
        if (!pos.send()) {
            return -1;
        }
        return this._get_OK_ENN_Response();
    }

    public boolean send_c() throws IOException {
        return this.comm.sendASCIIPacket("c");
    }

    public boolean send_k() throws IOException {
        return this.comm.sendASCIIPacket("k");
    }

    public boolean send_ctrl_C() throws IOException {
        return this.comm.sendASCIIPacket("\u0003");
    }

    public int send_D() throws IOException {
        if (!this.comm.sendASCIIPacket("D")) {
            return -1;
        }
        return this._get_OK_ENN_Response();
    }

    public boolean set_StartNoAckMode() throws IOException {
        if (!this.comm.sendASCIIPacket("QStartNoAckMode")) {
            return false;
        }
        boolean noackmode = this._get_OK_NOTSUPPORTED_Response();
        this.comm.setNoAckMode(noackmode);
        return noackmode;
    }

    public boolean set_EnvironmentHexEncoded(String variable, String value) throws IOException {
        PacketOutputStream pos = this.comm.newPacket();
        pos.writeASCII("QEnvironmentHexEncoded:");
        pos.writeHexASCII(variable);
        pos.writeHexASCII("=");
        pos.writeHexUTF8(value);
        if (!pos.send()) {
            return false;
        }
        return this._get_OK_NOTSUPPORTED_Response();
    }

    public int set_LaunchArch(String arch) throws IOException {
        PacketOutputStream pos = this.comm.newPacket();
        pos.writeASCII("QLaunchArch:");
        pos.writeASCII(arch);
        if (!pos.send()) {
            return -1;
        }
        return this._get_OK_ENN_Response();
    }

    public Map<String, String> query_HostInfo() throws IOException {
        if (!this.comm.sendASCIIPacket("qHostInfo")) {
            return null;
        }
        String resp = this.comm.nextResponse();
        return Util.converToMap(resp, ";", ":");
    }

    public String query_LaunchSuccess() throws IOException {
        if (!this.comm.sendASCIIPacket("qLaunchSuccess")) {
            return "Unknown error";
        }
        return this._get_OK_EMSG_Response();
    }

    public Map<String, String> query_ProcessInfo() throws IOException {
        if (!this.comm.sendASCIIPacket("qProcessInfo")) {
            return null;
        }
        String resp = this.comm.nextResponse();
        return Util.converToMap(resp, ";", ":");
    }

    public Map<String, String> query_RegisterInfo(int register_id) throws IOException {
        if (!this.comm.sendASCIIPacket("qRegisterInfo" + Integer.toHexString(register_id))) {
            return null;
        }
        String resp = this.comm.nextResponse();
        if (resp.length() == 3 && resp.startsWith("E")) {
            return null;
        }
        return Util.converToMap(resp, ";", ":");
    }

    public void close() {
        this.comm.close();
    }
}

