/*
 * Decompiled with CFR 0.152.
 */
package org.moe.protocol.gdbremote;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.moe.protocol.gdbremote.Communication;

final class PacketOutputStream
extends OutputStream {
    private final Communication comm;
    private final DataOutputStream target;
    private int hash = 0;

    PacketOutputStream(Communication comm, DataOutputStream target) throws IOException {
        this.comm = comm;
        this.target = target;
        this.target.write(36);
    }

    @Override
    public void write(int b) throws IOException {
        this.hash += b;
        this.target.write(b);
    }

    @Override
    public void close() throws IOException {
        throw new RuntimeException("don't call 'close' on PacketOutputStream directly, call 'send' instead!");
    }

    void writeInteger(int number) throws IOException {
        this.writeASCII(Integer.toString(number));
    }

    void writeASCII(String string) throws IOException {
        this.write(string.getBytes("ASCII"));
    }

    void writeHexASCII(String string) throws IOException {
        this.writeHex(string.getBytes("ASCII"));
    }

    void writeHexUTF8(String string) throws IOException {
        this.writeHex(string.getBytes("UTF-8"));
    }

    void writeHex(byte[] bytes) throws IOException {
        int count = bytes.length;
        for (int i = 0; i < count; ++i) {
            this.writeHexByte(bytes[i]);
        }
    }

    void writeHexByte(int b) throws IOException {
        this.writeHexHalfByte((b & 0xF0) >> 4);
        this.writeHexHalfByte((b & 0xF) >> 0);
    }

    private void writeHexHalfByte(int half) throws IOException {
        if (half < 10) {
            this.write(48 + half);
        } else {
            this.write(87 + half);
        }
    }

    void writeHexInteger(int number) throws IOException {
        int part = number >> 24 & 0xFF;
        boolean hasWritten = false;
        if (part > 0) {
            hasWritten = true;
            this.writeHexByte(part);
        }
        if ((part = number >> 16 & 0xFF) > 0 || hasWritten) {
            hasWritten = true;
            this.writeHexByte(part);
        }
        if ((part = number >> 8 & 0xFF) > 0 || hasWritten) {
            hasWritten = true;
            this.writeHexByte(part);
        }
        if ((part = number >> 0 & 0xFF) > 0 || hasWritten) {
            hasWritten = true;
            this.writeHexByte(part);
        }
    }

    private final void _close() throws IOException {
        this.target.write(35);
        int hsh = this.hash % 256;
        this.target.write(String.format("%02x", hsh).getBytes());
        this.target.flush();
    }

    boolean send() throws IOException {
        this._close();
        return this.comm.getAck();
    }
}

