/*
 * Decompiled with CFR 0.152.
 */
package org.moe.protocol.gdbremote;

public final class Signal {
    private final byte code;
    private final String name;
    public static final Signal EXC_BAD_ACCESS = new Signal(-111, "EXC_BAD_ACCESS");
    public static final Signal EXC_BAD_INSTRUCTION = new Signal(-110, "EXC_BAD_INSTRUCTION");
    public static final Signal EXC_ARITHMETIC = new Signal(-109, "EXC_ARITHMETIC");
    private static final Signal[] signals = new Signal[]{EXC_BAD_ACCESS, EXC_BAD_INSTRUCTION, EXC_ARITHMETIC};

    private Signal(byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getSignal(byte code) {
        for (Signal s : signals) {
            if (s.getCode() != code) continue;
            return s.getName();
        }
        return "" + (code & 0xFF);
    }

    public byte getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

