/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.audiotoolbox.struct;

import org.moe.natj.c.StructObject;
import org.moe.natj.c.ann.Structure;
import org.moe.natj.c.ann.StructureField;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Generated;

@Generated
@Structure()
public final class AURecordedParameterEvent extends StructObject {
    private static long __natjCache;

    static {
        NatJ.register();
    }

    @Generated
    public AURecordedParameterEvent() {
        super(AURecordedParameterEvent.class);
    }

    @Generated
    protected AURecordedParameterEvent(Pointer peer) {
        super(peer);
    }

    @Generated
    public AURecordedParameterEvent(long hostTime, long address, float value) {
        super(AURecordedParameterEvent.class);
        setHostTime(hostTime);
        setAddress(address);
        setValue(value);
    }

    /**
     * < The host time at which the event occurred.
     */
    @Generated
    @StructureField(order = 0, isGetter = true)
    public native long hostTime();

    /**
     * < The host time at which the event occurred.
     */
    @Generated
    @StructureField(order = 0, isGetter = false)
    public native void setHostTime(long value);

    /**
     * < The address of the parameter whose value changed.
     */
    @Generated
    @StructureField(order = 1, isGetter = true)
    public native long address();

    /**
     * < The address of the parameter whose value changed.
     */
    @Generated
    @StructureField(order = 1, isGetter = false)
    public native void setAddress(long value);

    /**
     * < The value of the parameter at that time.
     */
    @Generated
    @StructureField(order = 2, isGetter = true)
    public native float value();

    /**
     * < The value of the parameter at that time.
     */
    @Generated
    @StructureField(order = 2, isGetter = false)
    public native void setValue(float value);
}
