/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.corefoundation.enums;

import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.NInt;

/**
 * [@typedef] CFStringNormalizationForm
 * This is the type of Unicode normalization forms as described in
 * Unicode Technical Report #15. To normalize for use with file
 * system calls, use CFStringGetFileSystemRepresentation().
 */
@Generated
public final class CFStringNormalizationForm {
    /**
     * Canonical Decomposition
     */
    @Generated @NInt public static final long D = 0x0000000000000000L;
    /**
     * Compatibility Decomposition
     */
    @Generated @NInt public static final long KD = 0x0000000000000001L;
    /**
     * Canonical Decomposition followed by Canonical Composition
     */
    @Generated @NInt public static final long C = 0x0000000000000002L;
    /**
     * Compatibility Decomposition followed by Canonical Composition
     */
    @Generated @NInt public static final long KC = 0x0000000000000003L;

    @Generated
    private CFStringNormalizationForm() {
    }
}
