/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.coretext.enums;

import org.moe.natj.general.ann.Generated;

/**
 * [@enum]       UI Type constants
 * 
 * These constants represent the specific user interface purpose to specify for font creation.
 * 
 * Use these constants with CTFontCreateUIFontForLanguage to indicate the intended user interface usage of the font reference to be created.
 */
@Generated
public final class CTFontUIFontType {
    @Generated public static final int UIFontNone = 0xFFFFFFFF;
    @Generated public static final int UIFontUser = 0x00000000;
    @Generated public static final int UIFontUserFixedPitch = 0x00000001;
    @Generated public static final int UIFontSystem = 0x00000002;
    @Generated public static final int UIFontEmphasizedSystem = 0x00000003;
    @Generated public static final int UIFontSmallSystem = 0x00000004;
    @Generated public static final int UIFontSmallEmphasizedSystem = 0x00000005;
    @Generated public static final int UIFontMiniSystem = 0x00000006;
    @Generated public static final int UIFontMiniEmphasizedSystem = 0x00000007;
    @Generated public static final int UIFontViews = 0x00000008;
    @Generated public static final int UIFontApplication = 0x00000009;
    @Generated public static final int UIFontLabel = 0x0000000A;
    @Generated public static final int UIFontMenuTitle = 0x0000000B;
    @Generated public static final int UIFontMenuItem = 0x0000000C;
    @Generated public static final int UIFontMenuItemMark = 0x0000000D;
    @Generated public static final int UIFontMenuItemCmdKey = 0x0000000E;
    @Generated public static final int UIFontWindowTitle = 0x0000000F;
    @Generated public static final int UIFontPushButton = 0x00000010;
    @Generated public static final int UIFontUtilityWindowTitle = 0x00000011;
    @Generated public static final int UIFontAlertHeader = 0x00000012;
    @Generated public static final int UIFontSystemDetail = 0x00000013;
    @Generated public static final int UIFontEmphasizedSystemDetail = 0x00000014;
    @Generated public static final int UIFontToolbar = 0x00000015;
    @Generated public static final int UIFontSmallToolbar = 0x00000016;
    @Generated public static final int UIFontMessage = 0x00000017;
    @Generated public static final int UIFontPalette = 0x00000018;
    @Generated public static final int UIFontToolTip = 0x00000019;
    @Generated public static final int UIFontControlContent = 0x0000001A;
    @Generated public static final int NoFontType = 0xFFFFFFFF;
    @Generated public static final int UserFontType = 0x00000000;
    @Generated public static final int UserFixedPitchFontType = 0x00000001;
    @Generated public static final int SystemFontType = 0x00000002;
    @Generated public static final int EmphasizedSystemFontType = 0x00000003;
    @Generated public static final int SmallSystemFontType = 0x00000004;
    @Generated public static final int SmallEmphasizedSystemFontType = 0x00000005;
    @Generated public static final int MiniSystemFontType = 0x00000006;
    @Generated public static final int MiniEmphasizedSystemFontType = 0x00000007;
    @Generated public static final int ViewsFontType = 0x00000008;
    @Generated public static final int ApplicationFontType = 0x00000009;
    @Generated public static final int LabelFontType = 0x0000000A;
    @Generated public static final int MenuTitleFontType = 0x0000000B;
    @Generated public static final int MenuItemFontType = 0x0000000C;
    @Generated public static final int MenuItemMarkFontType = 0x0000000D;
    @Generated public static final int MenuItemCmdKeyFontType = 0x0000000E;
    @Generated public static final int WindowTitleFontType = 0x0000000F;
    @Generated public static final int PushButtonFontType = 0x00000010;
    @Generated public static final int UtilityWindowTitleFontType = 0x00000011;
    @Generated public static final int AlertHeaderFontType = 0x00000012;
    @Generated public static final int SystemDetailFontType = 0x00000013;
    @Generated public static final int EmphasizedSystemDetailFontType = 0x00000014;
    @Generated public static final int ToolbarFontType = 0x00000015;
    @Generated public static final int SmallToolbarFontType = 0x00000016;
    @Generated public static final int MessageFontType = 0x00000017;
    @Generated public static final int PaletteFontType = 0x00000018;
    @Generated public static final int ToolTipFontType = 0x00000019;
    @Generated public static final int ControlContentFontType = 0x0000001A;

    @Generated
    private CTFontUIFontType() {
    }
}
