/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.coretext.enums;

import org.moe.natj.general.ann.Generated;

@Generated
public final class Enums {
    /**
     * ordered list of kerning pairs
     */
    @Generated public static final int kKERNOrderedList = 0x00000000;
    /**
     * state table for n-way contextual kerning
     */
    @Generated public static final int kKERNStateTable = 0x00000001;
    /**
     * simple n X m array of kerning values
     */
    @Generated public static final int kKERNSimpleArray = 0x00000002;
    /**
     * modified version of SimpleArray
     */
    @Generated public static final int kKERNIndexArray = 0x00000003;
    @Generated public static final int kJUSTOverridePriority = 0x00008000;
    @Generated public static final int kJUSTOverrideLimits = 0x00004000;
    @Generated public static final int kJUSTOverrideUnlimited = 0x00002000;
    @Generated public static final int kJUSTUnlimited = 0x00001000;
    @Generated public static final int kJUSTPriorityMask = 0x00000003;
    @Generated public static final int kFontEnglishLanguage = 0x00000000;
    @Generated public static final int kFontFrenchLanguage = 0x00000001;
    @Generated public static final int kFontGermanLanguage = 0x00000002;
    @Generated public static final int kFontItalianLanguage = 0x00000003;
    @Generated public static final int kFontDutchLanguage = 0x00000004;
    @Generated public static final int kFontSwedishLanguage = 0x00000005;
    @Generated public static final int kFontSpanishLanguage = 0x00000006;
    @Generated public static final int kFontDanishLanguage = 0x00000007;
    @Generated public static final int kFontPortugueseLanguage = 0x00000008;
    @Generated public static final int kFontNorwegianLanguage = 0x00000009;
    @Generated public static final int kFontHebrewLanguage = 0x0000000A;
    @Generated public static final int kFontJapaneseLanguage = 0x0000000B;
    @Generated public static final int kFontArabicLanguage = 0x0000000C;
    @Generated public static final int kFontFinnishLanguage = 0x0000000D;
    @Generated public static final int kFontGreekLanguage = 0x0000000E;
    @Generated public static final int kFontIcelandicLanguage = 0x0000000F;
    @Generated public static final int kFontMalteseLanguage = 0x00000010;
    @Generated public static final int kFontTurkishLanguage = 0x00000011;
    @Generated public static final int kFontCroatianLanguage = 0x00000012;
    @Generated public static final int kFontTradChineseLanguage = 0x00000013;
    @Generated public static final int kFontUrduLanguage = 0x00000014;
    @Generated public static final int kFontHindiLanguage = 0x00000015;
    @Generated public static final int kFontThaiLanguage = 0x00000016;
    @Generated public static final int kFontKoreanLanguage = 0x00000017;
    @Generated public static final int kFontLithuanianLanguage = 0x00000018;
    @Generated public static final int kFontPolishLanguage = 0x00000019;
    @Generated public static final int kFontHungarianLanguage = 0x0000001A;
    @Generated public static final int kFontEstonianLanguage = 0x0000001B;
    @Generated public static final int kFontLettishLanguage = 0x0000001C;
    @Generated public static final int kFontLatvianLanguage = 0x0000001C;
    @Generated public static final int kFontSaamiskLanguage = 0x0000001D;
    @Generated public static final int kFontLappishLanguage = 0x0000001D;
    @Generated public static final int kFontFaeroeseLanguage = 0x0000001E;
    @Generated public static final int kFontFarsiLanguage = 0x0000001F;
    @Generated public static final int kFontPersianLanguage = 0x0000001F;
    @Generated public static final int kFontRussianLanguage = 0x00000020;
    @Generated public static final int kFontSimpChineseLanguage = 0x00000021;
    @Generated public static final int kFontFlemishLanguage = 0x00000022;
    @Generated public static final int kFontIrishLanguage = 0x00000023;
    @Generated public static final int kFontAlbanianLanguage = 0x00000024;
    @Generated public static final int kFontRomanianLanguage = 0x00000025;
    @Generated public static final int kFontCzechLanguage = 0x00000026;
    @Generated public static final int kFontSlovakLanguage = 0x00000027;
    @Generated public static final int kFontSlovenianLanguage = 0x00000028;
    @Generated public static final int kFontYiddishLanguage = 0x00000029;
    @Generated public static final int kFontSerbianLanguage = 0x0000002A;
    @Generated public static final int kFontMacedonianLanguage = 0x0000002B;
    @Generated public static final int kFontBulgarianLanguage = 0x0000002C;
    @Generated public static final int kFontUkrainianLanguage = 0x0000002D;
    @Generated public static final int kFontByelorussianLanguage = 0x0000002E;
    @Generated public static final int kFontUzbekLanguage = 0x0000002F;
    @Generated public static final int kFontKazakhLanguage = 0x00000030;
    @Generated public static final int kFontAzerbaijaniLanguage = 0x00000031;
    @Generated public static final int kFontAzerbaijanArLanguage = 0x00000032;
    @Generated public static final int kFontArmenianLanguage = 0x00000033;
    @Generated public static final int kFontGeorgianLanguage = 0x00000034;
    @Generated public static final int kFontMoldavianLanguage = 0x00000035;
    @Generated public static final int kFontKirghizLanguage = 0x00000036;
    @Generated public static final int kFontTajikiLanguage = 0x00000037;
    @Generated public static final int kFontTurkmenLanguage = 0x00000038;
    @Generated public static final int kFontMongolianLanguage = 0x00000039;
    @Generated public static final int kFontMongolianCyrLanguage = 0x0000003A;
    @Generated public static final int kFontPashtoLanguage = 0x0000003B;
    @Generated public static final int kFontKurdishLanguage = 0x0000003C;
    @Generated public static final int kFontKashmiriLanguage = 0x0000003D;
    @Generated public static final int kFontSindhiLanguage = 0x0000003E;
    @Generated public static final int kFontTibetanLanguage = 0x0000003F;
    @Generated public static final int kFontNepaliLanguage = 0x00000040;
    @Generated public static final int kFontSanskritLanguage = 0x00000041;
    @Generated public static final int kFontMarathiLanguage = 0x00000042;
    @Generated public static final int kFontBengaliLanguage = 0x00000043;
    @Generated public static final int kFontAssameseLanguage = 0x00000044;
    @Generated public static final int kFontGujaratiLanguage = 0x00000045;
    @Generated public static final int kFontPunjabiLanguage = 0x00000046;
    @Generated public static final int kFontOriyaLanguage = 0x00000047;
    @Generated public static final int kFontMalayalamLanguage = 0x00000048;
    @Generated public static final int kFontKannadaLanguage = 0x00000049;
    @Generated public static final int kFontTamilLanguage = 0x0000004A;
    @Generated public static final int kFontTeluguLanguage = 0x0000004B;
    @Generated public static final int kFontSinhaleseLanguage = 0x0000004C;
    @Generated public static final int kFontBurmeseLanguage = 0x0000004D;
    @Generated public static final int kFontKhmerLanguage = 0x0000004E;
    @Generated public static final int kFontLaoLanguage = 0x0000004F;
    @Generated public static final int kFontVietnameseLanguage = 0x00000050;
    @Generated public static final int kFontIndonesianLanguage = 0x00000051;
    @Generated public static final int kFontTagalogLanguage = 0x00000052;
    @Generated public static final int kFontMalayRomanLanguage = 0x00000053;
    @Generated public static final int kFontMalayArabicLanguage = 0x00000054;
    @Generated public static final int kFontAmharicLanguage = 0x00000055;
    @Generated public static final int kFontTigrinyaLanguage = 0x00000056;
    @Generated public static final int kFontGallaLanguage = 0x00000057;
    @Generated public static final int kFontOromoLanguage = 0x00000057;
    @Generated public static final int kFontSomaliLanguage = 0x00000058;
    @Generated public static final int kFontSwahiliLanguage = 0x00000059;
    @Generated public static final int kFontRuandaLanguage = 0x0000005A;
    @Generated public static final int kFontRundiLanguage = 0x0000005B;
    @Generated public static final int kFontChewaLanguage = 0x0000005C;
    @Generated public static final int kFontMalagasyLanguage = 0x0000005D;
    @Generated public static final int kFontEsperantoLanguage = 0x0000005E;
    @Generated public static final int kFontWelshLanguage = 0x00000080;
    @Generated public static final int kFontBasqueLanguage = 0x00000081;
    @Generated public static final int kFontCatalanLanguage = 0x00000082;
    @Generated public static final int kFontLatinLanguage = 0x00000083;
    @Generated public static final int kFontQuechuaLanguage = 0x00000084;
    @Generated public static final int kFontGuaraniLanguage = 0x00000085;
    @Generated public static final int kFontAymaraLanguage = 0x00000086;
    @Generated public static final int kFontTatarLanguage = 0x00000087;
    @Generated public static final int kFontUighurLanguage = 0x00000088;
    @Generated public static final int kFontDzongkhaLanguage = 0x00000089;
    @Generated public static final int kFontJavaneseRomLanguage = 0x0000008A;
    @Generated public static final int kFontSundaneseRomLanguage = 0x0000008B;
    /**
     * 'kerx'
     */
    @Generated public static final int kKERXTag = 0x6B657278;
    @Generated public static final int kKERXCurrentVersion = 0x00020000;
    /**
     * set if this table has vertical kerning information
     */
    @Generated public static final int kKERXVertical = 0x80000000;
    /**
     * this value in a cross-stream table means reset to zero
     */
    @Generated public static final int kKERXResetCrossStream = 0x00008000;
    /**
     * set if this table contains cross-stream kerning values
     */
    @Generated public static final int kKERXCrossStream = 0x40000000;
    /**
     * set if this table contains variation kerning values
     */
    @Generated public static final int kKERXVariation = 0x20000000;
    @Generated public static final int kKERXDescending = 0x10000000;
    /**
     * UNUSED, MUST BE ZERO
     */
    @Generated public static final int kKERXUnusedBits = 0x0FFFFF00;
    /**
     * format of this subtable
     */
    @Generated public static final int kKERXFormatMask = 0x000000FF;
    @Generated public static final int kNormalPositionSelector = 0x00000000;
    @Generated public static final int kSuperiorsSelector = 0x00000001;
    @Generated public static final int kInferiorsSelector = 0x00000002;
    @Generated public static final int kOrdinalsSelector = 0x00000003;
    @Generated public static final int kScientificInferiorsSelector = 0x00000004;
    @Generated public static final int kDefaultLowerCaseSelector = 0x00000000;
    @Generated public static final int kLowerCaseSmallCapsSelector = 0x00000001;
    @Generated public static final int kLowerCasePetiteCapsSelector = 0x00000002;
    /**
     * 'morx'
     */
    @Generated public static final int kMORXTag = 0x6D6F7278;
    /**
     * version number for current 'morx' table
     */
    @Generated public static final int kMORXCurrentVersion = 0x00020000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORXCoverVertical = 0x80000000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORXCoverDescending = 0x40000000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORXCoverIgnoreVertical = 0x20000000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORXCoverLogicalOrder = 0x10000000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORXCoverTypeMask = 0x000000FF;
    /**
     * 'opbd'
     */
    @Generated public static final int kOPBDTag = 0x6F706264;
    @Generated public static final int kOPBDCurrentVersion = 0x00010000;
    @Generated public static final int kOPBDDistanceFormat = 0x00000000;
    @Generated public static final int kOPBDControlPointFormat = 0x00000001;
    /**
     * Left-to-Right
     */
    @Generated public static final int kPROPLDirectionClass = 0x00000000;
    /**
     * Right-to-Left
     */
    @Generated public static final int kPROPRDirectionClass = 0x00000001;
    /**
     * Right-to-Left Arabic Letter
     */
    @Generated public static final int kPROPALDirectionClass = 0x00000002;
    /**
     * European Number
     */
    @Generated public static final int kPROPENDirectionClass = 0x00000003;
    /**
     * European Number Separator
     */
    @Generated public static final int kPROPESDirectionClass = 0x00000004;
    /**
     * European Number Terminator
     */
    @Generated public static final int kPROPETDirectionClass = 0x00000005;
    /**
     * Arabic Number
     */
    @Generated public static final int kPROPANDirectionClass = 0x00000006;
    /**
     * Common Number Separator
     */
    @Generated public static final int kPROPCSDirectionClass = 0x00000007;
    /**
     * Paragraph Separator (also referred to as Block Separator)
     */
    @Generated public static final int kPROPPSDirectionClass = 0x00000008;
    /**
     * Segment Separator
     */
    @Generated public static final int kPROPSDirectionClass = 0x00000009;
    /**
     * Whitespace
     */
    @Generated public static final int kPROPWSDirectionClass = 0x0000000A;
    /**
     * Other Neutral
     */
    @Generated public static final int kPROPONDirectionClass = 0x0000000B;
    /**
     * Special European Number (not a Unicode class)
     */
    @Generated public static final int kPROPSENDirectionClass = 0x0000000C;
    /**
     * Left-to-Right Embedding
     */
    @Generated public static final int kPROPLREDirectionClass = 0x0000000D;
    /**
     * Left-to-Right Override
     */
    @Generated public static final int kPROPLRODirectionClass = 0x0000000E;
    /**
     * Right-to-Left Embedding
     */
    @Generated public static final int kPROPRLEDirectionClass = 0x0000000F;
    /**
     * Right-to-Left Override
     */
    @Generated public static final int kPROPRLODirectionClass = 0x00000010;
    /**
     * Pop Directional Format
     */
    @Generated public static final int kPROPPDFDirectionClass = 0x00000011;
    /**
     * Non-Spacing Mark
     */
    @Generated public static final int kPROPNSMDirectionClass = 0x00000012;
    /**
     * Boundary Neutral
     */
    @Generated public static final int kPROPBNDirectionClass = 0x00000013;
    /**
     * Number of Unicode directional types + Special European Number
     */
    @Generated public static final int kPROPNumDirectionClasses = 0x00000014;
    @Generated public static final int kFontCustom8BitScript = 0x00000000;
    @Generated public static final int kFontCustom816BitScript = 0x00000001;
    @Generated public static final int kFontCustom16BitScript = 0x00000002;
    @Generated public static final int nameFontTableTag = 0x6E616D65;
    @Generated public static final int kDesignLevel1Selector = 0x00000000;
    @Generated public static final int kDesignLevel2Selector = 0x00000001;
    @Generated public static final int kDesignLevel3Selector = 0x00000002;
    @Generated public static final int kDesignLevel4Selector = 0x00000003;
    @Generated public static final int kDesignLevel5Selector = 0x00000004;
    @Generated public static final int kMonospacedNumbersSelector = 0x00000000;
    @Generated public static final int kProportionalNumbersSelector = 0x00000001;
    @Generated public static final int kThirdWidthNumbersSelector = 0x00000002;
    @Generated public static final int kQuarterWidthNumbersSelector = 0x00000003;
    @Generated public static final int kFontNoPlatformCode = 0xFFFFFFFF;
    @Generated public static final int kFontNoScriptCode = 0xFFFFFFFF;
    @Generated public static final int kFontNoLanguageCode = 0xFFFFFFFF;
    @Generated public static final int sizeof_sfntCMapEncoding = 0x00000008;
    @Generated public static final int kAlternateHorizKanaOnSelector = 0x00000000;
    @Generated public static final int kAlternateHorizKanaOffSelector = 0x00000001;
    @Generated public static final int kAlternateVertKanaOnSelector = 0x00000002;
    @Generated public static final int kAlternateVertKanaOffSelector = 0x00000003;
    @Generated public static final int kFullWidthKanaSelector = 0x00000000;
    @Generated public static final int kProportionalKanaSelector = 0x00000001;
    /**
     * a simple array indexed by glyph code
     */
    @Generated public static final int kSFNTLookupSimpleArray = 0x00000000;
    /**
     * segment mapping to single value
     */
    @Generated public static final int kSFNTLookupSegmentSingle = 0x00000002;
    /**
     * segment mapping to lookup array
     */
    @Generated public static final int kSFNTLookupSegmentArray = 0x00000004;
    /**
     * sorted list of glyph, value pairs
     */
    @Generated public static final int kSFNTLookupSingleTable = 0x00000006;
    /**
     * a simple trimmed array indexed by glyph code
     */
    @Generated public static final int kSFNTLookupTrimmedArray = 0x00000008;
    /**
     * a simple trimmed vector indexed by glyph code
     */
    @Generated public static final int kSFNTLookupVector = 0x0000000A;
    @Generated public static final int kShowDiacriticsSelector = 0x00000000;
    @Generated public static final int kHideDiacriticsSelector = 0x00000001;
    @Generated public static final int kDecomposeDiacriticsSelector = 0x00000002;
    @Generated public static final int kCTFontPrioritySystem = 0x00002710;
    @Generated public static final int kCTFontPriorityNetwork = 0x00004E20;
    @Generated public static final int kCTFontPriorityComputer = 0x00007530;
    @Generated public static final int kCTFontPriorityUser = 0x00009C40;
    @Generated public static final int kCTFontPriorityDynamic = 0x0000C350;
    @Generated public static final int kCTFontPriorityProcess = 0x0000EA60;
    @Generated public static final int kNoCJKSymbolAlternativesSelector = 0x00000000;
    @Generated public static final int kCJKSymbolAltOneSelector = 0x00000001;
    @Generated public static final int kCJKSymbolAltTwoSelector = 0x00000002;
    @Generated public static final int kCJKSymbolAltThreeSelector = 0x00000003;
    @Generated public static final int kCJKSymbolAltFourSelector = 0x00000004;
    @Generated public static final int kCJKSymbolAltFiveSelector = 0x00000005;
    @Generated public static final int kTraditionalCharactersSelector = 0x00000000;
    @Generated public static final int kSimplifiedCharactersSelector = 0x00000001;
    @Generated public static final int kJIS1978CharactersSelector = 0x00000002;
    @Generated public static final int kJIS1983CharactersSelector = 0x00000003;
    @Generated public static final int kJIS1990CharactersSelector = 0x00000004;
    @Generated public static final int kTraditionalAltOneSelector = 0x00000005;
    @Generated public static final int kTraditionalAltTwoSelector = 0x00000006;
    @Generated public static final int kTraditionalAltThreeSelector = 0x00000007;
    @Generated public static final int kTraditionalAltFourSelector = 0x00000008;
    @Generated public static final int kTraditionalAltFiveSelector = 0x00000009;
    @Generated public static final int kExpertCharactersSelector = 0x0000000A;
    @Generated public static final int kJIS2004CharactersSelector = 0x0000000B;
    @Generated public static final int kHojoCharactersSelector = 0x0000000C;
    @Generated public static final int kNLCCharactersSelector = 0x0000000D;
    @Generated public static final int kTraditionalNamesCharactersSelector = 0x0000000E;
    @Generated public static final int variationFontTableTag = 0x66766172;
    @Generated public static final int kANKRCurrentVersion = 0x00000000;
    /**
     * Baseline data
     */
    @Generated public static final int kCTFontTableBASE = 0x42415345;
    /**
     * Compact Font Format 1.0
     */
    @Generated public static final int kCTFontTableCFF = 0x43464620;
    /**
     * Digital signature
     */
    @Generated public static final int kCTFontTableDSIG = 0x44534947;
    /**
     * Embedded bitmap data
     */
    @Generated public static final int kCTFontTableEBDT = 0x45424454;
    /**
     * Embedded bitmap location data
     */
    @Generated public static final int kCTFontTableEBLC = 0x45424C43;
    /**
     * Embedded bitmap scaling data
     */
    @Generated public static final int kCTFontTableEBSC = 0x45425343;
    /**
     * Glyph definition data
     */
    @Generated public static final int kCTFontTableGDEF = 0x47444546;
    /**
     * Glyph positioning data
     */
    @Generated public static final int kCTFontTableGPOS = 0x47504F53;
    /**
     * Glyph substitution data
     */
    @Generated public static final int kCTFontTableGSUB = 0x47535542;
    /**
     * Justification data
     */
    @Generated public static final int kCTFontTableJSTF = 0x4A535446;
    /**
     * Linear threshold data
     */
    @Generated public static final int kCTFontTableLTSH = 0x4C545348;
    /**
     * Math layout data
     */
    @Generated public static final int kCTFontTableMATH = 0x4D415448;
    /**
     * OS/2 and Windows specific metrics
     */
    @Generated public static final int kCTFontTableOS2 = 0x4F532F32;
    /**
     * PCL 5 data
     */
    @Generated public static final int kCTFontTablePCLT = 0x50434C54;
    /**
     * Vertical device metrics
     */
    @Generated public static final int kCTFontTableVDMX = 0x56444D58;
    /**
     * Vertical origin
     */
    @Generated public static final int kCTFontTableVORG = 0x564F5247;
    /**
     * Glyph reference
     */
    @Generated public static final int kCTFontTableZapf = 0x5A617066;
    /**
     * Accent attachment
     */
    @Generated public static final int kCTFontTableAcnt = 0x61636E74;
    /**
     * Anchor points
     */
    @Generated public static final int kCTFontTableAnkr = 0x616E6B72;
    /**
     * Axis variations
     */
    @Generated public static final int kCTFontTableAvar = 0x61766172;
    /**
     * Bitmap data
     */
    @Generated public static final int kCTFontTableBdat = 0x62646174;
    /**
     * Bitmap font header
     */
    @Generated public static final int kCTFontTableBhed = 0x62686564;
    /**
     * Bitmap location
     */
    @Generated public static final int kCTFontTableBloc = 0x626C6F63;
    /**
     * Baseline
     */
    @Generated public static final int kCTFontTableBsln = 0x62736C6E;
    /**
     * Character to glyph mapping
     */
    @Generated public static final int kCTFontTableCmap = 0x636D6170;
    /**
     * CVT variations
     */
    @Generated public static final int kCTFontTableCvar = 0x63766172;
    /**
     * Control value table
     */
    @Generated public static final int kCTFontTableCvt = 0x63767420;
    /**
     * Font descriptor
     */
    @Generated public static final int kCTFontTableFdsc = 0x66647363;
    /**
     * Layout feature
     */
    @Generated public static final int kCTFontTableFeat = 0x66656174;
    /**
     * Font metrics
     */
    @Generated public static final int kCTFontTableFmtx = 0x666D7478;
    /**
     * Font program
     */
    @Generated public static final int kCTFontTableFpgm = 0x6670676D;
    /**
     * Font variations
     */
    @Generated public static final int kCTFontTableFvar = 0x66766172;
    /**
     * Grid-fitting/scan-conversion
     */
    @Generated public static final int kCTFontTableGasp = 0x67617370;
    /**
     * Glyph data
     */
    @Generated public static final int kCTFontTableGlyf = 0x676C7966;
    /**
     * Glyph variations
     */
    @Generated public static final int kCTFontTableGvar = 0x67766172;
    /**
     * Horizontal device metrics
     */
    @Generated public static final int kCTFontTableHdmx = 0x68646D78;
    /**
     * Font header
     */
    @Generated public static final int kCTFontTableHead = 0x68656164;
    /**
     * Horizontal header
     */
    @Generated public static final int kCTFontTableHhea = 0x68686561;
    /**
     * Horizontal metrics
     */
    @Generated public static final int kCTFontTableHmtx = 0x686D7478;
    /**
     * Horizontal style
     */
    @Generated public static final int kCTFontTableHsty = 0x68737479;
    /**
     * Justification
     */
    @Generated public static final int kCTFontTableJust = 0x6A757374;
    /**
     * Kerning
     */
    @Generated public static final int kCTFontTableKern = 0x6B65726E;
    /**
     * Extended kerning
     */
    @Generated public static final int kCTFontTableKerx = 0x6B657278;
    /**
     * Ligature caret
     */
    @Generated public static final int kCTFontTableLcar = 0x6C636172;
    /**
     * Language tags
     */
    @Generated public static final int kCTFontTableLtag = 0x6C746167;
    /**
     * Index to location
     */
    @Generated public static final int kCTFontTableLoca = 0x6C6F6361;
    /**
     * Maximum profile
     */
    @Generated public static final int kCTFontTableMaxp = 0x6D617870;
    /**
     * Morph
     */
    @Generated public static final int kCTFontTableMort = 0x6D6F7274;
    /**
     * Extended morph
     */
    @Generated public static final int kCTFontTableMorx = 0x6D6F7278;
    /**
     * Naming table
     */
    @Generated public static final int kCTFontTableName = 0x6E616D65;
    /**
     * Optical bounds
     */
    @Generated public static final int kCTFontTableOpbd = 0x6F706264;
    /**
     * PostScript information
     */
    @Generated public static final int kCTFontTablePost = 0x706F7374;
    /**
     * CVT program
     */
    @Generated public static final int kCTFontTablePrep = 0x70726570;
    /**
     * Properties
     */
    @Generated public static final int kCTFontTableProp = 0x70726F70;
    /**
     * Bitmap data
     */
    @Generated public static final int kCTFontTableSbit = 0x73626974;
    /**
     * Standard bitmap graphics
     */
    @Generated public static final int kCTFontTableSbix = 0x73626978;
    /**
     * Tracking
     */
    @Generated public static final int kCTFontTableTrak = 0x7472616B;
    /**
     * Vertical header
     */
    @Generated public static final int kCTFontTableVhea = 0x76686561;
    /**
     * Vertical metrics
     */
    @Generated public static final int kCTFontTableVmtx = 0x766D7478;
    @Generated public static final int kJUSTKashidaPriority = 0x00000000;
    @Generated public static final int kJUSTSpacePriority = 0x00000001;
    @Generated public static final int kJUSTLetterPriority = 0x00000002;
    @Generated public static final int kJUSTNullPriority = 0x00000003;
    @Generated public static final int kJUSTPriorityCount = 0x00000004;
    @Generated public static final int kLTAGCurrentVersion = 0x00000001;
    @Generated public static final int descriptorFontTableTag = 0x66647363;
    @Generated public static final int sizeof_sfntInstance = 0x00000004;
    @Generated public static final int kRequiredLigaturesOnSelector = 0x00000000;
    @Generated public static final int kRequiredLigaturesOffSelector = 0x00000001;
    @Generated public static final int kCommonLigaturesOnSelector = 0x00000002;
    @Generated public static final int kCommonLigaturesOffSelector = 0x00000003;
    @Generated public static final int kRareLigaturesOnSelector = 0x00000004;
    @Generated public static final int kRareLigaturesOffSelector = 0x00000005;
    @Generated public static final int kLogosOnSelector = 0x00000006;
    @Generated public static final int kLogosOffSelector = 0x00000007;
    @Generated public static final int kRebusPicturesOnSelector = 0x00000008;
    @Generated public static final int kRebusPicturesOffSelector = 0x00000009;
    @Generated public static final int kDiphthongLigaturesOnSelector = 0x0000000A;
    @Generated public static final int kDiphthongLigaturesOffSelector = 0x0000000B;
    @Generated public static final int kSquaredLigaturesOnSelector = 0x0000000C;
    @Generated public static final int kSquaredLigaturesOffSelector = 0x0000000D;
    @Generated public static final int kAbbrevSquaredLigaturesOnSelector = 0x0000000E;
    @Generated public static final int kAbbrevSquaredLigaturesOffSelector = 0x0000000F;
    @Generated public static final int kSymbolLigaturesOnSelector = 0x00000010;
    @Generated public static final int kSymbolLigaturesOffSelector = 0x00000011;
    @Generated public static final int kContextualLigaturesOnSelector = 0x00000012;
    @Generated public static final int kContextualLigaturesOffSelector = 0x00000013;
    @Generated public static final int kHistoricalLigaturesOnSelector = 0x00000014;
    @Generated public static final int kHistoricalLigaturesOffSelector = 0x00000015;
    @Generated public static final int kNoStyleOptionsSelector = 0x00000000;
    @Generated public static final int kDisplayTextSelector = 0x00000001;
    @Generated public static final int kEngravedTextSelector = 0x00000002;
    @Generated public static final int kIlluminatedCapsSelector = 0x00000003;
    @Generated public static final int kTitlingCapsSelector = 0x00000004;
    @Generated public static final int kTallCapsSelector = 0x00000005;
    @Generated public static final int kNoOrnamentsSelector = 0x00000000;
    @Generated public static final int kDingbatsSelector = 0x00000001;
    @Generated public static final int kPiCharactersSelector = 0x00000002;
    @Generated public static final int kFleuronsSelector = 0x00000003;
    @Generated public static final int kDecorativeBordersSelector = 0x00000004;
    @Generated public static final int kInternationalSymbolsSelector = 0x00000005;
    @Generated public static final int kMathSymbolsSelector = 0x00000006;
    /**
     * deprecated - use kRubyKanaOffSelector instead
     */
    @Generated public static final int kNoRubyKanaSelector = 0x00000000;
    /**
     * deprecated - use kRubyKanaOnSelector instead
     */
    @Generated public static final int kRubyKanaSelector = 0x00000001;
    @Generated public static final int kRubyKanaOnSelector = 0x00000002;
    @Generated public static final int kRubyKanaOffSelector = 0x00000003;
    /**
     * 'bsln'
     */
    @Generated public static final int kBSLNTag = 0x62736C6E;
    /**
     * current version number for 'bsln' table
     */
    @Generated public static final int kBSLNCurrentVersion = 0x00010000;
    @Generated public static final int kBSLNDistanceFormatNoMap = 0x00000000;
    @Generated public static final int kBSLNDistanceFormatWithMap = 0x00000001;
    @Generated public static final int kBSLNControlPointFormatNoMap = 0x00000002;
    @Generated public static final int kBSLNControlPointFormatWithMap = 0x00000003;
    /**
     * deprecated - use kCJKItalicRomanOffSelector instead
     */
    @Generated public static final int kNoCJKItalicRomanSelector = 0x00000000;
    /**
     * deprecated - use kCJKItalicRomanOnSelector instead
     */
    @Generated public static final int kCJKItalicRomanSelector = 0x00000001;
    @Generated public static final int kCJKItalicRomanOnSelector = 0x00000002;
    @Generated public static final int kCJKItalicRomanOffSelector = 0x00000003;
    /**
     * 'lcar'
     */
    @Generated public static final int kLCARTag = 0x6C636172;
    /**
     * current version number for 'lcar' table
     */
    @Generated public static final int kLCARCurrentVersion = 0x00010000;
    @Generated public static final int kLCARLinearFormat = 0x00000000;
    @Generated public static final int kLCARCtlPointFormat = 0x00000001;
    @Generated public static final int sizeof_sfntCMapSubHeader = 0x00000006;
    /**
     * 'mort'
     */
    @Generated public static final int kMORTTag = 0x6D6F7274;
    /**
     * current version number for 'mort' table
     */
    @Generated public static final int kMORTCurrentVersion = 0x00010000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORTCoverVertical = 0x00008000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORTCoverDescending = 0x00004000;
    /**
     * Coverage masks
     */
    @Generated public static final int kMORTCoverIgnoreVertical = 0x00002000;
    /**
     * Subtable types
     */
    @Generated public static final int kMORTCoverTypeMask = 0x0000000F;
    @Generated public static final int kMORTRearrangementType = 0x00000000;
    @Generated public static final int kMORTContextualType = 0x00000001;
    @Generated public static final int kMORTLigatureType = 0x00000002;
    @Generated public static final int kMORTSwashType = 0x00000004;
    /**
     * Ligature subtable constants
     */
    @Generated public static final int kMORTInsertionType = 0x00000005;
    @Generated public static final int kMORTLigLastAction = 0x80000000;
    @Generated public static final int kMORTLigStoreLigature = 0x40000000;
    @Generated public static final int kMORTLigFormOffsetMask = 0x3FFFFFFF;
    /**
     * Rearrangement subtable actions
     */
    @Generated public static final int kMORTLigFormOffsetShift = 0x00000002;
    /**
     * no action
     */
    @Generated public static final int kMORTraNoAction = 0x00000000;
    /**
     * Ax => xA
     */
    @Generated public static final int kMORTraxA = 0x00000001;
    /**
     * xD => Dx
     */
    @Generated public static final int kMORTraDx = 0x00000002;
    /**
     * AxD => DxA
     */
    @Generated public static final int kMORTraDxA = 0x00000003;
    /**
     * ABx => xAB
     */
    @Generated public static final int kMORTraxAB = 0x00000004;
    /**
     * ABx => xBA
     */
    @Generated public static final int kMORTraxBA = 0x00000005;
    /**
     * xCD => CDx
     */
    @Generated public static final int kMORTraCDx = 0x00000006;
    /**
     * xCD => DCx
     */
    @Generated public static final int kMORTraDCx = 0x00000007;
    /**
     * AxCD => CDxA
     */
    @Generated public static final int kMORTraCDxA = 0x00000008;
    /**
     * AxCD => DCxA
     */
    @Generated public static final int kMORTraDCxA = 0x00000009;
    /**
     * ABxD => DxAB
     */
    @Generated public static final int kMORTraDxAB = 0x0000000A;
    /**
     * ABxD => DxBA
     */
    @Generated public static final int kMORTraDxBA = 0x0000000B;
    /**
     * ABxCD => CDxAB
     */
    @Generated public static final int kMORTraCDxAB = 0x0000000C;
    /**
     * ABxCD => CDxBA
     */
    @Generated public static final int kMORTraCDxBA = 0x0000000D;
    /**
     * ABxCD => DCxAB
     */
    @Generated public static final int kMORTraDCxAB = 0x0000000E;
    /**
     * ABxCD => DCxBA
     * Insertion subtable constants
     */
    @Generated public static final int kMORTraDCxBA = 0x0000000F;
    @Generated public static final int kMORTDoInsertionsBefore = 0x00000080;
    @Generated public static final int kMORTIsSplitVowelPiece = 0x00000040;
    @Generated public static final int kMORTInsertionsCountMask = 0x0000003F;
    @Generated public static final int kMORTCurrInsertKashidaLike = 0x00002000;
    @Generated public static final int kMORTMarkInsertKashidaLike = 0x00001000;
    @Generated public static final int kMORTCurrInsertBefore = 0x00000800;
    @Generated public static final int kMORTMarkInsertBefore = 0x00000400;
    @Generated public static final int kMORTMarkJustTableCountMask = 0x00003F80;
    /**
     * JustTableIndex for marked character
     */
    @Generated public static final int kMORTMarkJustTableCountShift = 0x00000007;
    @Generated public static final int kMORTCurrJustTableCountMask = 0x0000007F;
    /**
     * JustTableIndex for current character
     */
    @Generated public static final int kMORTCurrJustTableCountShift = 0x00000000;
    @Generated public static final int kMORTCurrInsertCountMask = 0x000003E0;
    /**
     * count to insert after current glyphRec
     */
    @Generated public static final int kMORTCurrInsertCountShift = 0x00000005;
    @Generated public static final int kMORTMarkInsertCountMask = 0x0000001F;
    /**
     * count to insert after marked glyphRec
     */
    @Generated public static final int kMORTMarkInsertCountShift = 0x00000000;
    @Generated public static final int kAllTypographicFeaturesType = 0x00000000;
    @Generated public static final int kLigaturesType = 0x00000001;
    @Generated public static final int kCursiveConnectionType = 0x00000002;
    /**
     * deprecated - use kLowerCaseType or kUpperCaseType instead
     */
    @Generated public static final int kLetterCaseType = 0x00000003;
    @Generated public static final int kVerticalSubstitutionType = 0x00000004;
    @Generated public static final int kLinguisticRearrangementType = 0x00000005;
    @Generated public static final int kNumberSpacingType = 0x00000006;
    @Generated public static final int kSmartSwashType = 0x00000008;
    @Generated public static final int kDiacriticsType = 0x00000009;
    @Generated public static final int kVerticalPositionType = 0x0000000A;
    @Generated public static final int kFractionsType = 0x0000000B;
    @Generated public static final int kOverlappingCharactersType = 0x0000000D;
    @Generated public static final int kTypographicExtrasType = 0x0000000E;
    @Generated public static final int kMathematicalExtrasType = 0x0000000F;
    @Generated public static final int kOrnamentSetsType = 0x00000010;
    @Generated public static final int kCharacterAlternativesType = 0x00000011;
    @Generated public static final int kDesignComplexityType = 0x00000012;
    @Generated public static final int kStyleOptionsType = 0x00000013;
    @Generated public static final int kCharacterShapeType = 0x00000014;
    @Generated public static final int kNumberCaseType = 0x00000015;
    @Generated public static final int kTextSpacingType = 0x00000016;
    @Generated public static final int kTransliterationType = 0x00000017;
    @Generated public static final int kAnnotationType = 0x00000018;
    @Generated public static final int kKanaSpacingType = 0x00000019;
    @Generated public static final int kIdeographicSpacingType = 0x0000001A;
    @Generated public static final int kUnicodeDecompositionType = 0x0000001B;
    @Generated public static final int kRubyKanaType = 0x0000001C;
    @Generated public static final int kCJKSymbolAlternativesType = 0x0000001D;
    @Generated public static final int kIdeographicAlternativesType = 0x0000001E;
    @Generated public static final int kCJKVerticalRomanPlacementType = 0x0000001F;
    @Generated public static final int kItalicCJKRomanType = 0x00000020;
    @Generated public static final int kCaseSensitiveLayoutType = 0x00000021;
    @Generated public static final int kAlternateKanaType = 0x00000022;
    @Generated public static final int kStylisticAlternativesType = 0x00000023;
    @Generated public static final int kContextualAlternatesType = 0x00000024;
    @Generated public static final int kLowerCaseType = 0x00000025;
    @Generated public static final int kUpperCaseType = 0x00000026;
    @Generated public static final int kLanguageTagType = 0x00000027;
    @Generated public static final int kCJKRomanSpacingType = 0x00000067;
    @Generated public static final int kLastFeatureType = 0xFFFFFFFF;
    /**
     * Mask to extract action type
     */
    @Generated public static final int kKERXActionTypeMask = 0xC0000000;
    /**
     * Actions have control point numbers
     */
    @Generated public static final int kKERXActionTypeControlPoints = 0x00000000;
    /**
     * Actions have anchor point numbers
     */
    @Generated public static final int kKERXActionTypeAnchorPoints = 0x40000000;
    /**
     * Actions have control point coordinates
     */
    @Generated public static final int kKERXActionTypeCoordinates = 0x80000000;
    /**
     * Unused, must be zero
     */
    @Generated public static final int kKERXUnusedFlags = 0x3F000000;
    /**
     * Mask to extract offset to action table
     */
    @Generated public static final int kKERXActionOffsetMask = 0x00FFFFFF;
    @Generated public static final int kSubstituteVerticalFormsOnSelector = 0x00000000;
    @Generated public static final int kSubstituteVerticalFormsOffSelector = 0x00000001;
    @Generated public static final int kCTFontClassMaskShift = 0x0000001C;
    @Generated public static final int kSTXHasLigAction = 0x00002000;
    @Generated public static final int kNoAlternatesSelector = 0x00000000;
    @Generated public static final int kLinguisticRearrangementOnSelector = 0x00000000;
    @Generated public static final int kLinguisticRearrangementOffSelector = 0x00000001;
    @Generated public static final int nonGlyphID = 0x0000FFFF;
    @Generated public static final int kAllTypeFeaturesOnSelector = 0x00000000;
    @Generated public static final int kAllTypeFeaturesOffSelector = 0x00000001;
    @Generated public static final int kHalfWidthCJKRomanSelector = 0x00000000;
    @Generated public static final int kProportionalCJKRomanSelector = 0x00000001;
    @Generated public static final int kDefaultCJKRomanSelector = 0x00000002;
    @Generated public static final int kFullWidthCJKRomanSelector = 0x00000003;
    @Generated public static final int kBSLNRomanBaseline = 0x00000000;
    @Generated public static final int kBSLNIdeographicCenterBaseline = 0x00000001;
    @Generated public static final int kBSLNIdeographicLowBaseline = 0x00000002;
    @Generated public static final int kBSLNHangingBaseline = 0x00000003;
    @Generated public static final int kBSLNMathBaseline = 0x00000004;
    @Generated public static final int kBSLNIdeographicHighBaseline = 0x00000005;
    @Generated public static final int kBSLNLastBaseline = 0x0000001F;
    @Generated public static final int kBSLNNumBaselineClasses = 0x00000020;
    @Generated public static final int kBSLNNoBaseline = 0x000000FF;
    @Generated public static final int kBSLNNoBaselineOverride = 0x000000FF;
    @Generated public static final int kProportionalTextSelector = 0x00000000;
    @Generated public static final int kMonospacedTextSelector = 0x00000001;
    @Generated public static final int kHalfWidthTextSelector = 0x00000002;
    @Generated public static final int kThirdWidthTextSelector = 0x00000003;
    @Generated public static final int kQuarterWidthTextSelector = 0x00000004;
    @Generated public static final int kAltProportionalTextSelector = 0x00000005;
    @Generated public static final int kAltHalfWidthTextSelector = 0x00000006;
    @Generated public static final int kNoStylisticAlternatesSelector = 0x00000000;
    @Generated public static final int kStylisticAltOneOnSelector = 0x00000002;
    @Generated public static final int kStylisticAltOneOffSelector = 0x00000003;
    @Generated public static final int kStylisticAltTwoOnSelector = 0x00000004;
    @Generated public static final int kStylisticAltTwoOffSelector = 0x00000005;
    @Generated public static final int kStylisticAltThreeOnSelector = 0x00000006;
    @Generated public static final int kStylisticAltThreeOffSelector = 0x00000007;
    @Generated public static final int kStylisticAltFourOnSelector = 0x00000008;
    @Generated public static final int kStylisticAltFourOffSelector = 0x00000009;
    @Generated public static final int kStylisticAltFiveOnSelector = 0x0000000A;
    @Generated public static final int kStylisticAltFiveOffSelector = 0x0000000B;
    @Generated public static final int kStylisticAltSixOnSelector = 0x0000000C;
    @Generated public static final int kStylisticAltSixOffSelector = 0x0000000D;
    @Generated public static final int kStylisticAltSevenOnSelector = 0x0000000E;
    @Generated public static final int kStylisticAltSevenOffSelector = 0x0000000F;
    @Generated public static final int kStylisticAltEightOnSelector = 0x00000010;
    @Generated public static final int kStylisticAltEightOffSelector = 0x00000011;
    @Generated public static final int kStylisticAltNineOnSelector = 0x00000012;
    @Generated public static final int kStylisticAltNineOffSelector = 0x00000013;
    @Generated public static final int kStylisticAltTenOnSelector = 0x00000014;
    @Generated public static final int kStylisticAltTenOffSelector = 0x00000015;
    @Generated public static final int kStylisticAltElevenOnSelector = 0x00000016;
    @Generated public static final int kStylisticAltElevenOffSelector = 0x00000017;
    @Generated public static final int kStylisticAltTwelveOnSelector = 0x00000018;
    @Generated public static final int kStylisticAltTwelveOffSelector = 0x00000019;
    @Generated public static final int kStylisticAltThirteenOnSelector = 0x0000001A;
    @Generated public static final int kStylisticAltThirteenOffSelector = 0x0000001B;
    @Generated public static final int kStylisticAltFourteenOnSelector = 0x0000001C;
    @Generated public static final int kStylisticAltFourteenOffSelector = 0x0000001D;
    @Generated public static final int kStylisticAltFifteenOnSelector = 0x0000001E;
    @Generated public static final int kStylisticAltFifteenOffSelector = 0x0000001F;
    @Generated public static final int kStylisticAltSixteenOnSelector = 0x00000020;
    @Generated public static final int kStylisticAltSixteenOffSelector = 0x00000021;
    @Generated public static final int kStylisticAltSeventeenOnSelector = 0x00000022;
    @Generated public static final int kStylisticAltSeventeenOffSelector = 0x00000023;
    @Generated public static final int kStylisticAltEighteenOnSelector = 0x00000024;
    @Generated public static final int kStylisticAltEighteenOffSelector = 0x00000025;
    @Generated public static final int kStylisticAltNineteenOnSelector = 0x00000026;
    @Generated public static final int kStylisticAltNineteenOffSelector = 0x00000027;
    @Generated public static final int kStylisticAltTwentyOnSelector = 0x00000028;
    @Generated public static final int kStylisticAltTwentyOffSelector = 0x00000029;
    @Generated public static final int kFontUnicodePlatform = 0x00000000;
    @Generated public static final int kFontMacintoshPlatform = 0x00000001;
    @Generated public static final int kFontReservedPlatform = 0x00000002;
    @Generated public static final int kFontMicrosoftPlatform = 0x00000003;
    @Generated public static final int kFontCustomPlatform = 0x00000004;
    @Generated public static final int cmapFontTableTag = 0x636D6170;
    @Generated public static final int kSTClassEndOfText = 0x00000000;
    @Generated public static final int kSTClassOutOfBounds = 0x00000001;
    @Generated public static final int kSTClassDeletedGlyph = 0x00000002;
    @Generated public static final int kSTClassEndOfLine = 0x00000003;
    @Generated public static final int kSTSetMark = 0x00008000;
    @Generated public static final int kSTNoAdvance = 0x00004000;
    @Generated public static final int kSTMarkEnd = 0x00002000;
    @Generated public static final int kSTLigActionMask = 0x00003FFF;
    @Generated public static final int kSTRearrVerbMask = 0x0000000F;
    /**
     * ordered list of kerning pairs
     */
    @Generated public static final int kKERXOrderedList = 0x00000000;
    /**
     * state table for n-way contextual kerning
     */
    @Generated public static final int kKERXStateTable = 0x00000001;
    /**
     * simple n X m array of kerning values
     */
    @Generated public static final int kKERXSimpleArray = 0x00000002;
    /**
     * state table for control point positioning
     */
    @Generated public static final int kKERXControlPoint = 0x00000004;
    /**
     * index-based n X m array of kerning values
     */
    @Generated public static final int kKERXIndexArray = 0x00000006;
    @Generated public static final int sizeof_sfntCMapExtendedSubHeader = 0x0000000C;
    @Generated public static final int sizeof_sfntDescriptorHeader = 0x00000008;
    @Generated public static final int kWordInitialSwashesOnSelector = 0x00000000;
    @Generated public static final int kWordInitialSwashesOffSelector = 0x00000001;
    @Generated public static final int kWordFinalSwashesOnSelector = 0x00000002;
    @Generated public static final int kWordFinalSwashesOffSelector = 0x00000003;
    @Generated public static final int kLineInitialSwashesOnSelector = 0x00000004;
    @Generated public static final int kLineInitialSwashesOffSelector = 0x00000005;
    @Generated public static final int kLineFinalSwashesOnSelector = 0x00000006;
    @Generated public static final int kLineFinalSwashesOffSelector = 0x00000007;
    @Generated public static final int kNonFinalSwashesOnSelector = 0x00000008;
    @Generated public static final int kNonFinalSwashesOffSelector = 0x00000009;
    /**
     * Array of glyphs starts a line
     */
    @Generated public static final int kKERNLineStart = 0x00000001;
    /**
     * Array of glyphs ends a line
     */
    @Generated public static final int kKERNLineEndKerning = 0x00000002;
    /**
     * Prohibit cross kerning
     */
    @Generated public static final int kKERNNoCrossKerning = 0x00000004;
    /**
     * Caller wants kerning notes
     */
    @Generated public static final int kKERNNotesRequested = 0x00000008;
    /**
     * Indicates a glyph was involved in a kerning pair/group
     */
    @Generated public static final int kKERNNoStakeNote = 0x00000001;
    /**
     * Indicates a return-to-baseline in cross-stream kerning
     */
    @Generated public static final int kKERNCrossStreamResetNote = 0x00000002;
    /**
     * All kerning values were zero, kerning call had no effect
     */
    @Generated public static final int kKERNNotApplied = 0x00000001;
    @Generated public static final int kNoTransliterationSelector = 0x00000000;
    @Generated public static final int kHanjaToHangulSelector = 0x00000001;
    @Generated public static final int kHiraganaToKatakanaSelector = 0x00000002;
    @Generated public static final int kKatakanaToHiraganaSelector = 0x00000003;
    @Generated public static final int kKanaToRomanizationSelector = 0x00000004;
    @Generated public static final int kRomanizationToHiraganaSelector = 0x00000005;
    @Generated public static final int kRomanizationToKatakanaSelector = 0x00000006;
    @Generated public static final int kHanjaToHangulAltOneSelector = 0x00000007;
    @Generated public static final int kHanjaToHangulAltTwoSelector = 0x00000008;
    @Generated public static final int kHanjaToHangulAltThreeSelector = 0x00000009;
    @Generated public static final int kLowerCaseNumbersSelector = 0x00000000;
    @Generated public static final int kUpperCaseNumbersSelector = 0x00000001;
    /**
     * deprecated
     */
    @Generated public static final int kUpperAndLowerCaseSelector = 0x00000000;
    /**
     * deprecated
     */
    @Generated public static final int kAllCapsSelector = 0x00000001;
    /**
     * deprecated
     */
    @Generated public static final int kAllLowerCaseSelector = 0x00000002;
    /**
     * deprecated
     */
    @Generated public static final int kSmallCapsSelector = 0x00000003;
    /**
     * deprecated
     */
    @Generated public static final int kInitialCapsSelector = 0x00000004;
    /**
     * deprecated
     */
    @Generated public static final int kInitialCapsAndSmallCapsSelector = 0x00000005;
    /**
     * 'trak'
     */
    @Generated public static final int kTRAKTag = 0x7472616B;
    /**
     * current version number for 'trak' table
     */
    @Generated public static final int kTRAKCurrentVersion = 0x00010000;
    /**
     * kTRAKPerGlyphFormat         = 2
     */
    @Generated public static final int kTRAKUniformFormat = 0x00000000;
    @Generated public static final int kDefaultUpperCaseSelector = 0x00000000;
    @Generated public static final int kUpperCaseSmallCapsSelector = 0x00000001;
    @Generated public static final int kUpperCasePetiteCapsSelector = 0x00000002;
    /**
     * Array of glyphs starts a line
     */
    @Generated public static final int kKERXLineStart = 0x00000001;
    /**
     * Array of glyphs ends a line
     */
    @Generated public static final int kKERXLineEndKerning = 0x00000002;
    /**
     * Prohibit cross kerning
     */
    @Generated public static final int kKERXNoCrossKerning = 0x00000004;
    /**
     * Caller wants kerning notes
     */
    @Generated public static final int kKERXNotesRequested = 0x00000008;
    /**
     * Indicates a glyph was involved in a kerning pair/group
     */
    @Generated public static final int kKERXNoStakeNote = 0x00000001;
    /**
     * Indicates a return-to-baseline in cross-stream kerning
     */
    @Generated public static final int kKERXCrossStreamResetNote = 0x00000002;
    /**
     * All kerning values were zero, kerning call had no effect
     */
    @Generated public static final int kKERXNotApplied = 0x00000001;
    @Generated public static final int sizeof_sfntNameHeader = 0x00000006;
    @Generated public static final int kHyphenToMinusOnSelector = 0x00000000;
    @Generated public static final int kHyphenToMinusOffSelector = 0x00000001;
    @Generated public static final int kAsteriskToMultiplyOnSelector = 0x00000002;
    @Generated public static final int kAsteriskToMultiplyOffSelector = 0x00000003;
    @Generated public static final int kSlashToDivideOnSelector = 0x00000004;
    @Generated public static final int kSlashToDivideOffSelector = 0x00000005;
    @Generated public static final int kInequalityLigaturesOnSelector = 0x00000006;
    @Generated public static final int kInequalityLigaturesOffSelector = 0x00000007;
    @Generated public static final int kExponentsOnSelector = 0x00000008;
    @Generated public static final int kExponentsOffSelector = 0x00000009;
    @Generated public static final int kMathematicalGreekOnSelector = 0x0000000A;
    @Generated public static final int kMathematicalGreekOffSelector = 0x0000000B;
    @Generated public static final int featureFontTableTag = 0x66656174;
    @Generated public static final int kFullWidthIdeographsSelector = 0x00000000;
    @Generated public static final int kProportionalIdeographsSelector = 0x00000001;
    @Generated public static final int kHalfWidthIdeographsSelector = 0x00000002;
    @Generated public static final int kCJKVerticalRomanCenteredSelector = 0x00000000;
    @Generated public static final int kCJKVerticalRomanHBaselineSelector = 0x00000001;
    @Generated public static final int kFontNoNameCode = 0xFFFFFFFF;
    @Generated public static final int sizeof_sfntVariationAxis = 0x00000014;
    @Generated public static final int kCTWritingDirectionEmbedding = 0x00000000;
    @Generated public static final int kCTWritingDirectionOverride = 0x00000002;
    /**
     * 'just'
     */
    @Generated public static final int kJUSTTag = 0x6A757374;
    @Generated public static final int kJUSTCurrentVersion = 0x00010000;
    @Generated public static final int kJUSTStandardFormat = 0x00000000;
    /**
     * used in a pcConditionalAddAction
     */
    @Generated public static final int kJUSTnoGlyphcode = 0x0000FFFF;
    @Generated public static final int kJUSTpcDecompositionAction = 0x00000000;
    @Generated public static final int kJUSTpcUnconditionalAddAction = 0x00000001;
    @Generated public static final int kJUSTpcConditionalAddAction = 0x00000002;
    @Generated public static final int kJUSTpcGlyphStretchAction = 0x00000003;
    @Generated public static final int kJUSTpcDuctilityAction = 0x00000004;
    @Generated public static final int kJUSTpcGlyphRepeatAddAction = 0x00000005;
    @Generated public static final int kFontCopyrightName = 0x00000000;
    @Generated public static final int kFontFamilyName = 0x00000001;
    @Generated public static final int kFontStyleName = 0x00000002;
    @Generated public static final int kFontUniqueName = 0x00000003;
    @Generated public static final int kFontFullName = 0x00000004;
    @Generated public static final int kFontVersionName = 0x00000005;
    @Generated public static final int kFontPostscriptName = 0x00000006;
    @Generated public static final int kFontTrademarkName = 0x00000007;
    @Generated public static final int kFontManufacturerName = 0x00000008;
    @Generated public static final int kFontDesignerName = 0x00000009;
    @Generated public static final int kFontDescriptionName = 0x0000000A;
    @Generated public static final int kFontVendorURLName = 0x0000000B;
    @Generated public static final int kFontDesignerURLName = 0x0000000C;
    @Generated public static final int kFontLicenseDescriptionName = 0x0000000D;
    @Generated public static final int kFontLicenseInfoURLName = 0x0000000E;
    @Generated public static final int kFontPreferredFamilyName = 0x00000010;
    @Generated public static final int kFontPreferredSubfamilyName = 0x00000011;
    @Generated public static final int kFontMacCompatibleFullName = 0x00000012;
    @Generated public static final int kFontSampleTextName = 0x00000013;
    @Generated public static final int kFontPostScriptCIDName = 0x00000014;
    @Generated public static final int kFontLastReservedName = 0x000000FF;
    @Generated public static final int kUnconnectedSelector = 0x00000000;
    @Generated public static final int kPartiallyConnectedSelector = 0x00000001;
    @Generated public static final int kCursiveSelector = 0x00000002;
    @Generated public static final int kKERXValuesAreLong = 0x00000001;
    @Generated public static final int kCTRunDelegateVersion1 = 0x00000001;
    @Generated public static final int kCTRunDelegateCurrentVersion = 0x00000001;
    /**
     * 'prop'
     */
    @Generated public static final int kPROPTag = 0x70726F70;
    /**
     * current version number for 'prop' table
     */
    @Generated public static final int kPROPCurrentVersion = 0x00030000;
    @Generated public static final int kPROPPairOffsetShift = 0x00000008;
    @Generated public static final int kPROPPairOffsetSign = 0x00000007;
    /**
     * glyph is floater
     */
    @Generated public static final int kPROPIsFloaterMask = 0x00008000;
    /**
     * glyph can hang left/top
     */
    @Generated public static final int kPROPCanHangLTMask = 0x00004000;
    /**
     * glyph can hang right/bottom
     */
    @Generated public static final int kPROPCanHangRBMask = 0x00002000;
    /**
     * if glyph lands in RL streak, use paired glyph
     */
    @Generated public static final int kPROPUseRLPairMask = 0x00001000;
    /**
     * 4-bit signed offset to other pair member
     */
    @Generated public static final int kPROPPairOffsetMask = 0x00000F00;
    /**
     * glyph connects to glyph on right
     */
    @Generated public static final int kPROPRightConnectMask = 0x00000080;
    /**
     * must be zero
     */
    @Generated public static final int kPROPZeroReserved = 0x00000060;
    /**
     * direction bits
     */
    @Generated public static final int kPROPDirectionMask = 0x0000001F;
    @Generated public static final int kPreventOverlapOnSelector = 0x00000000;
    @Generated public static final int kPreventOverlapOffSelector = 0x00000001;
    @Generated public static final int kFontMicrosoftSymbolScript = 0x00000000;
    @Generated public static final int kFontMicrosoftStandardScript = 0x00000001;
    @Generated public static final int kFontMicrosoftUCS4Script = 0x0000000A;
    @Generated public static final int kCanonicalCompositionOnSelector = 0x00000000;
    @Generated public static final int kCanonicalCompositionOffSelector = 0x00000001;
    @Generated public static final int kCompatibilityCompositionOnSelector = 0x00000002;
    @Generated public static final int kCompatibilityCompositionOffSelector = 0x00000003;
    @Generated public static final int kTranscodingCompositionOnSelector = 0x00000004;
    @Generated public static final int kTranscodingCompositionOffSelector = 0x00000005;
    @Generated public static final int kNoFractionsSelector = 0x00000000;
    @Generated public static final int kVerticalFractionsSelector = 0x00000001;
    @Generated public static final int kDiagonalFractionsSelector = 0x00000002;
    @Generated public static final int kNoAnnotationSelector = 0x00000000;
    @Generated public static final int kBoxAnnotationSelector = 0x00000001;
    @Generated public static final int kRoundedBoxAnnotationSelector = 0x00000002;
    @Generated public static final int kCircleAnnotationSelector = 0x00000003;
    @Generated public static final int kInvertedCircleAnnotationSelector = 0x00000004;
    @Generated public static final int kParenthesisAnnotationSelector = 0x00000005;
    @Generated public static final int kPeriodAnnotationSelector = 0x00000006;
    @Generated public static final int kRomanNumeralAnnotationSelector = 0x00000007;
    @Generated public static final int kDiamondAnnotationSelector = 0x00000008;
    @Generated public static final int kInvertedBoxAnnotationSelector = 0x00000009;
    @Generated public static final int kInvertedRoundedBoxAnnotationSelector = 0x0000000A;
    /**
     * 'kern'
     */
    @Generated public static final int kKERNTag = 0x6B65726E;
    @Generated public static final int kKERNCurrentVersion = 0x00010000;
    /**
     * set if this table has vertical kerning information
     */
    @Generated public static final int kKERNVertical = 0x00008000;
    /**
     * this value in a cross-stream table means reset to zero
     */
    @Generated public static final int kKERNResetCrossStream = 0x00008000;
    /**
     * set if this table contains cross-stream kerning values
     */
    @Generated public static final int kKERNCrossStream = 0x00004000;
    /**
     * set if this table contains variation kerning values
     */
    @Generated public static final int kKERNVariation = 0x00002000;
    /**
     * UNUSED, MUST BE ZERO
     */
    @Generated public static final int kKERNUnusedBits = 0x00001F00;
    /**
     * format of this subtable
     */
    @Generated public static final int kKERNFormatMask = 0x000000FF;
    @Generated public static final int kContextualAlternatesOnSelector = 0x00000000;
    @Generated public static final int kContextualAlternatesOffSelector = 0x00000001;
    @Generated public static final int kSwashAlternatesOnSelector = 0x00000002;
    @Generated public static final int kSwashAlternatesOffSelector = 0x00000003;
    @Generated public static final int kContextualSwashAlternatesOnSelector = 0x00000004;
    @Generated public static final int kContextualSwashAlternatesOffSelector = 0x00000005;
    @Generated public static final int kFontRomanScript = 0x00000000;
    @Generated public static final int kFontJapaneseScript = 0x00000001;
    @Generated public static final int kFontTraditionalChineseScript = 0x00000002;
    @Generated public static final int kFontChineseScript = 0x00000002;
    @Generated public static final int kFontKoreanScript = 0x00000003;
    @Generated public static final int kFontArabicScript = 0x00000004;
    @Generated public static final int kFontHebrewScript = 0x00000005;
    @Generated public static final int kFontGreekScript = 0x00000006;
    @Generated public static final int kFontCyrillicScript = 0x00000007;
    @Generated public static final int kFontRussian = 0x00000007;
    @Generated public static final int kFontRSymbolScript = 0x00000008;
    @Generated public static final int kFontDevanagariScript = 0x00000009;
    @Generated public static final int kFontGurmukhiScript = 0x0000000A;
    @Generated public static final int kFontGujaratiScript = 0x0000000B;
    @Generated public static final int kFontOriyaScript = 0x0000000C;
    @Generated public static final int kFontBengaliScript = 0x0000000D;
    @Generated public static final int kFontTamilScript = 0x0000000E;
    @Generated public static final int kFontTeluguScript = 0x0000000F;
    @Generated public static final int kFontKannadaScript = 0x00000010;
    @Generated public static final int kFontMalayalamScript = 0x00000011;
    @Generated public static final int kFontSinhaleseScript = 0x00000012;
    @Generated public static final int kFontBurmeseScript = 0x00000013;
    @Generated public static final int kFontKhmerScript = 0x00000014;
    @Generated public static final int kFontThaiScript = 0x00000015;
    @Generated public static final int kFontLaotianScript = 0x00000016;
    @Generated public static final int kFontGeorgianScript = 0x00000017;
    @Generated public static final int kFontArmenianScript = 0x00000018;
    @Generated public static final int kFontSimpleChineseScript = 0x00000019;
    @Generated public static final int kFontTibetanScript = 0x0000001A;
    @Generated public static final int kFontMongolianScript = 0x0000001B;
    @Generated public static final int kFontGeezScript = 0x0000001C;
    @Generated public static final int kFontEthiopicScript = 0x0000001C;
    @Generated public static final int kFontAmharicScript = 0x0000001C;
    @Generated public static final int kFontSlavicScript = 0x0000001D;
    @Generated public static final int kFontEastEuropeanRomanScript = 0x0000001D;
    @Generated public static final int kFontVietnameseScript = 0x0000001E;
    @Generated public static final int kFontExtendedArabicScript = 0x0000001F;
    @Generated public static final int kFontSindhiScript = 0x0000001F;
    @Generated public static final int kFontUninterpretedScript = 0x00000020;
    @Generated public static final int sizeof_sfntCMapHeader = 0x00000004;
    @Generated public static final int sizeof_sfntVariationHeader = 0x00000010;
    @Generated public static final int kNoIdeographicAlternativesSelector = 0x00000000;
    @Generated public static final int kIdeographicAltOneSelector = 0x00000001;
    @Generated public static final int kIdeographicAltTwoSelector = 0x00000002;
    @Generated public static final int kIdeographicAltThreeSelector = 0x00000003;
    @Generated public static final int kIdeographicAltFourSelector = 0x00000004;
    @Generated public static final int kIdeographicAltFiveSelector = 0x00000005;
    @Generated public static final int kFontUnicodeDefaultSemantics = 0x00000000;
    @Generated public static final int kFontUnicodeV1_1Semantics = 0x00000001;
    @Generated public static final int kFontISO10646_1993Semantics = 0x00000002;
    @Generated public static final int kFontUnicodeV2_0BMPOnlySemantics = 0x00000003;
    @Generated public static final int kFontUnicodeV2_0FullCoverageSemantics = 0x00000004;
    @Generated public static final int kFontUnicodeV4_0VariationSequenceSemantics = 0x00000005;
    @Generated public static final int kFontUnicode_FullRepertoire = 0x00000006;
    @Generated public static final int os2FontTableTag = 0x4F532F32;
    @Generated public static final int kSTKCrossStreamReset = 0x00002000;
    @Generated public static final int sizeof_sfntNameRecord = 0x0000000C;
    @Generated public static final int kCaseSensitiveLayoutOnSelector = 0x00000000;
    @Generated public static final int kCaseSensitiveLayoutOffSelector = 0x00000001;
    @Generated public static final int kCaseSensitiveSpacingOnSelector = 0x00000002;
    @Generated public static final int kCaseSensitiveSpacingOffSelector = 0x00000003;
    @Generated public static final int sizeof_sfntDirectory = 0x0000000C;
    @Generated public static final int kHyphensToEmDashOnSelector = 0x00000000;
    @Generated public static final int kHyphensToEmDashOffSelector = 0x00000001;
    @Generated public static final int kHyphenToEnDashOnSelector = 0x00000002;
    @Generated public static final int kHyphenToEnDashOffSelector = 0x00000003;
    @Generated public static final int kSlashedZeroOnSelector = 0x00000004;
    @Generated public static final int kSlashedZeroOffSelector = 0x00000005;
    @Generated public static final int kFormInterrobangOnSelector = 0x00000006;
    @Generated public static final int kFormInterrobangOffSelector = 0x00000007;
    @Generated public static final int kSmartQuotesOnSelector = 0x00000008;
    @Generated public static final int kSmartQuotesOffSelector = 0x00000009;
    @Generated public static final int kPeriodsToEllipsisOnSelector = 0x0000000A;
    @Generated public static final int kPeriodsToEllipsisOffSelector = 0x0000000B;

    @Generated
    private Enums() {
    }

    /**
     * Color bitmap data
     */
    @Generated public static final int kCTFontTableCBDT = 0x43424454;
    /**
     * Color bitmap location data
     */
    @Generated public static final int kCTFontTableCBLC = 0x43424C43;
    /**
     * Compact Font Format 2.0
     */
    @Generated public static final int kCTFontTableCFF2 = 0x43464632;
    /**
     * Color table
     */
    @Generated public static final int kCTFontTableCOLR = 0x434F4C52;
    /**
     * Color palette table
     */
    @Generated public static final int kCTFontTableCPAL = 0x4350414C;
    /**
     * Horizontal metrics variations
     */
    @Generated public static final int kCTFontTableHVAR = 0x48564152;
    /**
     * Merge
     */
    @Generated public static final int kCTFontTableMERG = 0x4D455247;
    /**
     * Metrics variations
     */
    @Generated public static final int kCTFontTableMVAR = 0x4D564152;
    /**
     * Style attributes
     */
    @Generated public static final int kCTFontTableSTAT = 0x53544154;
    /**
     * Scalable vector graphics
     */
    @Generated public static final int kCTFontTableSVG = 0x53564720;
    /**
     * Vertical metrics variations
     */
    @Generated public static final int kCTFontTableVVAR = 0x56564152;
    /**
     * CID to glyph mapping
     */
    @Generated public static final int kCTFontTableCidg = 0x63696467;
    /**
     * 'FOND' and 'NFNT' data
     */
    @Generated public static final int kCTFontTableFond = 0x666F6E64;
    /**
     * Metadata
     */
    @Generated public static final int kCTFontTableMeta = 0x6D657461;
    /**
     * Cross-reference
     */
    @Generated public static final int kCTFontTableXref = 0x78726566;
}
