/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.foundation.enums;

import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.NUInt;

@Generated
public final class NSMatchingOptions {
    /**
     * Call the block periodically during long-running match operations.
     */
    @Generated @NUInt public static final long ReportProgress = 0x0000000000000001L;
    /**
     * Call the block once after the completion of any matching.
     */
    @Generated @NUInt public static final long ReportCompletion = 0x0000000000000002L;
    /**
     * Limit matches to those at the start of the search range.
     */
    @Generated @NUInt public static final long Anchored = 0x0000000000000004L;
    /**
     * Allow matching to look beyond the bounds of the search range.
     */
    @Generated @NUInt public static final long WithTransparentBounds = 0x0000000000000008L;
    /**
     * Prevent ^ and $ from automatically matching the beginning and end of the search range.
     */
    @Generated @NUInt public static final long WithoutAnchoringBounds = 0x0000000000000010L;

    @Generated
    private NSMatchingOptions() {
    }
}
