/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.healthkit.enums;

import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.NUInt;

/**
 * [@enum]          HKWorkoutActivityType
 * 
 * Represents a particular type of workout or exercise
 */
@Generated
public final class HKWorkoutActivityType {
    @Generated @NUInt public static final long AmericanFootball = 0x0000000000000001L;
    @Generated @NUInt public static final long Archery = 0x0000000000000002L;
    @Generated @NUInt public static final long AustralianFootball = 0x0000000000000003L;
    @Generated @NUInt public static final long Badminton = 0x0000000000000004L;
    @Generated @NUInt public static final long Baseball = 0x0000000000000005L;
    @Generated @NUInt public static final long Basketball = 0x0000000000000006L;
    @Generated @NUInt public static final long Bowling = 0x0000000000000007L;
    /**
     * See also HKWorkoutActivityTypeKickboxing.
     */
    @Generated @NUInt public static final long Boxing = 0x0000000000000008L;
    @Generated @NUInt public static final long Climbing = 0x0000000000000009L;
    @Generated @NUInt public static final long Cricket = 0x000000000000000AL;
    /**
     * Any mix of cardio and/or strength training. See also HKWorkoutActivityTypeCoreTraining and HKWorkoutActivityTypeFlexibility.
     */
    @Generated @NUInt public static final long CrossTraining = 0x000000000000000BL;
    @Generated @NUInt public static final long Curling = 0x000000000000000CL;
    @Generated @NUInt public static final long Cycling = 0x000000000000000DL;
    /**
     * This enum remains available to access older data.
     */
    @Generated @NUInt public static final long Dance = 0x000000000000000EL;
    /**
     * This enum remains available to access older data.
     */
    @Generated @NUInt public static final long DanceInspiredTraining = 0x000000000000000FL;
    @Generated @NUInt public static final long Elliptical = 0x0000000000000010L;
    /**
     * Polo, Horse Racing, Horse Riding, etc.
     */
    @Generated @NUInt public static final long EquestrianSports = 0x0000000000000011L;
    @Generated @NUInt public static final long Fencing = 0x0000000000000012L;
    @Generated @NUInt public static final long Fishing = 0x0000000000000013L;
    /**
     * Primarily free weights and/or body weight and/or accessories
     */
    @Generated @NUInt public static final long FunctionalStrengthTraining = 0x0000000000000014L;
    @Generated @NUInt public static final long Golf = 0x0000000000000015L;
    @Generated @NUInt public static final long Gymnastics = 0x0000000000000016L;
    @Generated @NUInt public static final long Handball = 0x0000000000000017L;
    @Generated @NUInt public static final long Hiking = 0x0000000000000018L;
    /**
     * Ice Hockey, Field Hockey, etc.
     */
    @Generated @NUInt public static final long Hockey = 0x0000000000000019L;
    @Generated @NUInt public static final long Hunting = 0x000000000000001AL;
    @Generated @NUInt public static final long Lacrosse = 0x000000000000001BL;
    @Generated @NUInt public static final long MartialArts = 0x000000000000001CL;
    /**
     * Qigong, meditation, etc.
     */
    @Generated @NUInt public static final long MindAndBody = 0x000000000000001DL;
    /**
     * This enum remains available to access older data.
     */
    @Generated @NUInt public static final long MixedMetabolicCardioTraining = 0x000000000000001EL;
    /**
     * Canoeing, Kayaking, Outrigger, Stand Up Paddle Board, etc.
     */
    @Generated @NUInt public static final long PaddleSports = 0x000000000000001FL;
    /**
     * Dodge Ball, Hopscotch, Tetherball, Jungle Gym, etc.
     */
    @Generated @NUInt public static final long Play = 0x0000000000000020L;
    /**
     * Therapeutic activities like foam rolling, self massage and flexibility moves.
     */
    @Generated @NUInt public static final long PreparationAndRecovery = 0x0000000000000021L;
    @Generated @NUInt public static final long Racquetball = 0x0000000000000022L;
    @Generated @NUInt public static final long Rowing = 0x0000000000000023L;
    @Generated @NUInt public static final long Rugby = 0x0000000000000024L;
    @Generated @NUInt public static final long Running = 0x0000000000000025L;
    @Generated @NUInt public static final long Sailing = 0x0000000000000026L;
    /**
     * Ice Skating, Speed Skating, Inline Skating, Skateboarding, etc.
     */
    @Generated @NUInt public static final long SkatingSports = 0x0000000000000027L;
    /**
     * Sledding, Snowmobiling, Building a Snowman, etc. See also HKWorkoutActivityTypeCrossCountrySkiing, HKWorkoutActivityTypeSnowboarding, and HKWorkoutActivityTypeDownhillSkiing.
     */
    @Generated @NUInt public static final long SnowSports = 0x0000000000000028L;
    @Generated @NUInt public static final long Soccer = 0x0000000000000029L;
    @Generated @NUInt public static final long Softball = 0x000000000000002AL;
    @Generated @NUInt public static final long Squash = 0x000000000000002BL;
    /**
     * See also HKWorkoutActivityTypeStairs and HKWorkoutActivityTypeStepTraining.
     */
    @Generated @NUInt public static final long StairClimbing = 0x000000000000002CL;
    /**
     * Traditional Surfing, Kite Surfing, Wind Surfing, etc.
     */
    @Generated @NUInt public static final long SurfingSports = 0x000000000000002DL;
    @Generated @NUInt public static final long Swimming = 0x000000000000002EL;
    @Generated @NUInt public static final long TableTennis = 0x000000000000002FL;
    @Generated @NUInt public static final long Tennis = 0x0000000000000030L;
    /**
     * Shot Put, Javelin, Pole Vaulting, etc.
     */
    @Generated @NUInt public static final long TrackAndField = 0x0000000000000031L;
    /**
     * Primarily machines and/or free weights
     */
    @Generated @NUInt public static final long TraditionalStrengthTraining = 0x0000000000000032L;
    @Generated @NUInt public static final long Volleyball = 0x0000000000000033L;
    @Generated @NUInt public static final long Walking = 0x0000000000000034L;
    @Generated @NUInt public static final long WaterFitness = 0x0000000000000035L;
    @Generated @NUInt public static final long WaterPolo = 0x0000000000000036L;
    /**
     * Water Skiing, Wake Boarding, etc.
     */
    @Generated @NUInt public static final long WaterSports = 0x0000000000000037L;
    @Generated @NUInt public static final long Wrestling = 0x0000000000000038L;
    @Generated @NUInt public static final long Yoga = 0x0000000000000039L;
    /**
     * HKWorkoutActivityTypeDanceInspiredTraining
     */
    @Generated @NUInt public static final long Barre = 0x000000000000003AL;
    @Generated @NUInt public static final long CoreTraining = 0x000000000000003BL;
    @Generated @NUInt public static final long CrossCountrySkiing = 0x000000000000003CL;
    @Generated @NUInt public static final long DownhillSkiing = 0x000000000000003DL;
    @Generated @NUInt public static final long Flexibility = 0x000000000000003EL;
    @Generated @NUInt public static final long HighIntensityIntervalTraining = 0x000000000000003FL;
    @Generated @NUInt public static final long JumpRope = 0x0000000000000040L;
    @Generated @NUInt public static final long Kickboxing = 0x0000000000000041L;
    /**
     * HKWorkoutActivityTypeDanceInspiredTraining
     */
    @Generated @NUInt public static final long Pilates = 0x0000000000000042L;
    @Generated @NUInt public static final long Snowboarding = 0x0000000000000043L;
    @Generated @NUInt public static final long Stairs = 0x0000000000000044L;
    @Generated @NUInt public static final long StepTraining = 0x0000000000000045L;
    @Generated @NUInt public static final long WheelchairWalkPace = 0x0000000000000046L;
    @Generated @NUInt public static final long WheelchairRunPace = 0x0000000000000047L;
    @Generated @NUInt public static final long Other = 0x0000000000000BB8L;

    @Generated
    private HKWorkoutActivityType() {
    }

    @Generated @NUInt public static final long TaiChi = 0x0000000000000048L;
    /**
     * HKWorkoutActivityTypeMixedMetabolicCardioTraining
     */
    @Generated @NUInt public static final long MixedCardio = 0x0000000000000049L;
    @Generated @NUInt public static final long HandCycling = 0x000000000000004AL;
    @Generated @NUInt public static final long DiscSports = 0x000000000000004BL;
    @Generated @NUInt public static final long FitnessGaming = 0x000000000000004CL;
    @Generated @NUInt public static final long CardioDance = 0x000000000000004DL;
    /**
     * Dances done in social settings like swing, salsa and folk dances from different world regions.
     */
    @Generated @NUInt public static final long SocialDance = 0x000000000000004EL;
    @Generated @NUInt public static final long Pickleball = 0x000000000000004FL;
    /**
     * Low intensity stretching and mobility exercises following a more vigorous workout type
     */
    @Generated @NUInt public static final long Cooldown = 0x0000000000000050L;
}
