/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.iad.enums;

import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.NInt;

/**
 * [@enum] ADInterstitialPresentationPolicy
 * 
 * [@constant] ADInterstitialPresentationPolicyNone Default policy - this is effectively
 * the same as the Manual policy except that setting the Manual policy will trigger
 * the +prepareInterstitialAds logic if needed.
 * 
 * [@constant] ADInterstitialPresentationPolicyAutomatic Automatic policy - the framework
 * determines when an interstitial will be presented.
 * 
 * [@constant] ADInterstitialPresentationPolicyManual Manual policy - the application
 * determines when an interstitial should be presented and calls an API from the
 * iAdAdditions category.
 * 
 * Policy options governing how and when interstitial ads may be presented from
 * a given view controller.
 */
@Generated
public final class ADInterstitialPresentationPolicy {
    @Generated @NInt public static final long None = 0x0000000000000000L;
    @Generated @NInt public static final long Automatic = 0x0000000000000001L;
    @Generated @NInt public static final long Manual = 0x0000000000000002L;

    @Generated
    private ADInterstitialPresentationPolicy() {
    }
}
