package apple.metal;

import apple.NSObject;
import apple.foundation.NSArray;
import apple.foundation.NSMethodSignature;
import apple.foundation.NSSet;
import apple.foundation.protocol.NSCopying;
import apple.metal.protocol.MTLFunction;
import org.moe.natj.c.ann.FunctionPtr;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.Library;
import org.moe.natj.general.ann.Mapped;
import org.moe.natj.general.ann.MappedReturn;
import org.moe.natj.general.ann.NInt;
import org.moe.natj.general.ann.NUInt;
import org.moe.natj.general.ann.Owned;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.objc.Class;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.SEL;
import org.moe.natj.objc.ann.ObjCClassBinding;
import org.moe.natj.objc.ann.Selector;
import org.moe.natj.objc.map.ObjCObjectMapper;

@Generated
@Library("Metal")
@Runtime(ObjCRuntime.class)
@ObjCClassBinding
public class MTLTileRenderPipelineDescriptor extends NSObject implements NSCopying {
    static {
        NatJ.register();
    }

    @Generated
    protected MTLTileRenderPipelineDescriptor(Pointer peer) {
        super(peer);
    }

    @Generated
    @Selector("accessInstanceVariablesDirectly")
    public static native boolean accessInstanceVariablesDirectly();

    @Generated
    @Owned
    @Selector("alloc")
    public static native MTLTileRenderPipelineDescriptor alloc();

    @Generated
    @Selector("allocWithZone:")
    @MappedReturn(ObjCObjectMapper.class)
    public static native Object allocWithZone(VoidPtr zone);

    @Generated
    @Selector("automaticallyNotifiesObserversForKey:")
    public static native boolean automaticallyNotifiesObserversForKey(String key);

    @Generated
    @Selector("cancelPreviousPerformRequestsWithTarget:")
    public static native void cancelPreviousPerformRequestsWithTarget(@Mapped(ObjCObjectMapper.class) Object aTarget);

    @Generated
    @Selector("cancelPreviousPerformRequestsWithTarget:selector:object:")
    public static native void cancelPreviousPerformRequestsWithTargetSelectorObject(
            @Mapped(ObjCObjectMapper.class) Object aTarget, SEL aSelector,
            @Mapped(ObjCObjectMapper.class) Object anArgument);

    @Generated
    @Selector("classFallbacksForKeyedArchiver")
    public static native NSArray<String> classFallbacksForKeyedArchiver();

    @Generated
    @Selector("classForKeyedUnarchiver")
    public static native Class classForKeyedUnarchiver();

    @Generated
    @Selector("colorAttachments")
    public native MTLTileRenderPipelineColorAttachmentDescriptorArray colorAttachments();

    @Generated
    @Owned
    @Selector("copyWithZone:")
    @MappedReturn(ObjCObjectMapper.class)
    public native Object copyWithZone(VoidPtr zone);

    @Generated
    @Selector("debugDescription")
    public static native String debugDescription_static();

    @Generated
    @Selector("description")
    public static native String description_static();

    @Generated
    @Selector("hash")
    @NUInt
    public static native long hash_static();

    @Generated
    @Selector("init")
    public native MTLTileRenderPipelineDescriptor init();

    @Generated
    @Selector("instanceMethodForSelector:")
    @FunctionPtr(name = "call_instanceMethodForSelector_ret")
    public static native NSObject.Function_instanceMethodForSelector_ret instanceMethodForSelector(SEL aSelector);

    @Generated
    @Selector("instanceMethodSignatureForSelector:")
    public static native NSMethodSignature instanceMethodSignatureForSelector(SEL aSelector);

    @Generated
    @Selector("instancesRespondToSelector:")
    public static native boolean instancesRespondToSelector(SEL aSelector);

    @Generated
    @Selector("isSubclassOfClass:")
    public static native boolean isSubclassOfClass(Class aClass);

    @Generated
    @Selector("keyPathsForValuesAffectingValueForKey:")
    public static native NSSet<String> keyPathsForValuesAffectingValueForKey(String key);

    /**
     * [@property] label:
     * 
     * The descriptor label.
     */
    @Generated
    @Selector("label")
    public native String label();

    @Generated
    @Owned
    @Selector("new")
    @MappedReturn(ObjCObjectMapper.class)
    public static native Object new_objc();

    /**
     * Rasterization and visibility state
     */
    @Generated
    @Selector("rasterSampleCount")
    @NUInt
    public native long rasterSampleCount();

    @Generated
    @Selector("reset")
    public native void reset();

    @Generated
    @Selector("resolveClassMethod:")
    public static native boolean resolveClassMethod(SEL sel);

    @Generated
    @Selector("resolveInstanceMethod:")
    public static native boolean resolveInstanceMethod(SEL sel);

    /**
     * [@property] label:
     * 
     * The descriptor label.
     */
    @Generated
    @Selector("setLabel:")
    public native void setLabel(String value);

    /**
     * Rasterization and visibility state
     */
    @Generated
    @Selector("setRasterSampleCount:")
    public native void setRasterSampleCount(@NUInt long value);

    /**
     * [@property] threadgroupSizeMatchesTileSize:
     * 
     * Whether all threadgroups associated with this pipeline will cover tiles entirely.
     * 
     * Metal can optimize code generation for this case.
     */
    @Generated
    @Selector("setThreadgroupSizeMatchesTileSize:")
    public native void setThreadgroupSizeMatchesTileSize(boolean value);

    /**
     * [@property] tileFunction:
     * 
     * The kernel or fragment function that serves as the tile shader for this pipeline.
     * 
     * Both kernel-based and fragment-based tile pipelines dispatches will barrier against previous
     * draws and other dispatches. Kernel-based pipelines will wait until all prior access to the tile completes.
     * Fragment-based pipelines will only wait until all prior access to the fragment's location completes.
     */
    @Generated
    @Selector("setTileFunction:")
    public native void setTileFunction(@Mapped(ObjCObjectMapper.class) MTLFunction value);

    @Generated
    @Selector("setVersion:")
    public static native void setVersion_static(@NInt long aVersion);

    @Generated
    @Selector("superclass")
    public static native Class superclass_static();

    /**
     * [@property] threadgroupSizeMatchesTileSize:
     * 
     * Whether all threadgroups associated with this pipeline will cover tiles entirely.
     * 
     * Metal can optimize code generation for this case.
     */
    @Generated
    @Selector("threadgroupSizeMatchesTileSize")
    public native boolean threadgroupSizeMatchesTileSize();

    @Generated
    @Selector("tileBuffers")
    public native MTLPipelineBufferDescriptorArray tileBuffers();

    /**
     * [@property] tileFunction:
     * 
     * The kernel or fragment function that serves as the tile shader for this pipeline.
     * 
     * Both kernel-based and fragment-based tile pipelines dispatches will barrier against previous
     * draws and other dispatches. Kernel-based pipelines will wait until all prior access to the tile completes.
     * Fragment-based pipelines will only wait until all prior access to the fragment's location completes.
     */
    @Generated
    @Selector("tileFunction")
    @MappedReturn(ObjCObjectMapper.class)
    public native MTLFunction tileFunction();

    @Generated
    @Selector("version")
    @NInt
    public static native long version_static();

    /**
     * [@property] maxTotalThreadsPerThreadgroup
     * 
     * Optional property. Set the maxTotalThreadsPerThreadgroup. If it is not set, returns zero.
     */
    @Generated
    @Selector("maxTotalThreadsPerThreadgroup")
    @NUInt
    public native long maxTotalThreadsPerThreadgroup();

    /**
     * [@property] maxTotalThreadsPerThreadgroup
     * 
     * Optional property. Set the maxTotalThreadsPerThreadgroup. If it is not set, returns zero.
     */
    @Generated
    @Selector("setMaxTotalThreadsPerThreadgroup:")
    public native void setMaxTotalThreadsPerThreadgroup(@NUInt long value);

    /**
     * [@property] binaryArchives
     * 
     * The set of MTLBinaryArchive to search for compiled code when creating the pipeline state.
     * 
     * Accelerate pipeline state creation by providing archives of compiled code such that no compilation needs to happen on the fast path.
     * 
     * @see MTLBinaryArchive
     */
    @Generated
    @Selector("binaryArchives")
    public native NSArray<?> binaryArchives();

    /**
     * [@property] binaryArchives
     * 
     * The set of MTLBinaryArchive to search for compiled code when creating the pipeline state.
     * 
     * Accelerate pipeline state creation by providing archives of compiled code such that no compilation needs to happen on the fast path.
     * 
     * @see MTLBinaryArchive
     */
    @Generated
    @Selector("setBinaryArchives:")
    public native void setBinaryArchives(NSArray<?> value);
}