/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.metal.enums;

import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.NUInt;

@Generated
public final class MTLPixelFormat {
    @Generated @NUInt public static final long Invalid = 0x0000000000000000L;
    /**
     * Normal 8 bit formats
     */
    @Generated @NUInt public static final long A8Unorm = 0x0000000000000001L;
    /**
     * Normal 8 bit formats
     */
    @Generated @NUInt public static final long R8Unorm = 0x000000000000000AL;
    /**
     * Normal 8 bit formats
     */
    @Generated @NUInt public static final long R8Unorm_sRGB = 0x000000000000000BL;
    /**
     * Normal 8 bit formats
     */
    @Generated @NUInt public static final long R8Snorm = 0x000000000000000CL;
    /**
     * Normal 8 bit formats
     */
    @Generated @NUInt public static final long R8Uint = 0x000000000000000DL;
    /**
     * Normal 8 bit formats
     */
    @Generated @NUInt public static final long R8Sint = 0x000000000000000EL;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long R16Unorm = 0x0000000000000014L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long R16Snorm = 0x0000000000000016L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long R16Uint = 0x0000000000000017L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long R16Sint = 0x0000000000000018L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long R16Float = 0x0000000000000019L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long RG8Unorm = 0x000000000000001EL;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long RG8Unorm_sRGB = 0x000000000000001FL;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long RG8Snorm = 0x0000000000000020L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long RG8Uint = 0x0000000000000021L;
    /**
     * Normal 16 bit formats
     */
    @Generated @NUInt public static final long RG8Sint = 0x0000000000000022L;
    /**
     * Packed 16 bit formats
     */
    @Generated @NUInt public static final long B5G6R5Unorm = 0x0000000000000028L;
    /**
     * Packed 16 bit formats
     */
    @Generated @NUInt public static final long A1BGR5Unorm = 0x0000000000000029L;
    /**
     * Packed 16 bit formats
     */
    @Generated @NUInt public static final long ABGR4Unorm = 0x000000000000002AL;
    /**
     * Packed 16 bit formats
     */
    @Generated @NUInt public static final long BGR5A1Unorm = 0x000000000000002BL;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long R32Uint = 0x0000000000000035L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long R32Sint = 0x0000000000000036L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long R32Float = 0x0000000000000037L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RG16Unorm = 0x000000000000003CL;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RG16Snorm = 0x000000000000003EL;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RG16Uint = 0x000000000000003FL;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RG16Sint = 0x0000000000000040L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RG16Float = 0x0000000000000041L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RGBA8Unorm = 0x0000000000000046L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RGBA8Unorm_sRGB = 0x0000000000000047L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RGBA8Snorm = 0x0000000000000048L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RGBA8Uint = 0x0000000000000049L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long RGBA8Sint = 0x000000000000004AL;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long BGRA8Unorm = 0x0000000000000050L;
    /**
     * Normal 32 bit formats
     */
    @Generated @NUInt public static final long BGRA8Unorm_sRGB = 0x0000000000000051L;
    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long RGB10A2Unorm = 0x000000000000005AL;
    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long RGB10A2Uint = 0x000000000000005BL;
    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long RG11B10Float = 0x000000000000005CL;
    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long RGB9E5Float = 0x000000000000005DL;
    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long BGR10_XR = 0x000000000000022AL;
    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long BGR10_XR_sRGB = 0x000000000000022BL;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RG32Uint = 0x0000000000000067L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RG32Sint = 0x0000000000000068L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RG32Float = 0x0000000000000069L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RGBA16Unorm = 0x000000000000006EL;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RGBA16Snorm = 0x0000000000000070L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RGBA16Uint = 0x0000000000000071L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RGBA16Sint = 0x0000000000000072L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long RGBA16Float = 0x0000000000000073L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long BGRA10_XR = 0x0000000000000228L;
    /**
     * Normal 64 bit formats
     */
    @Generated @NUInt public static final long BGRA10_XR_sRGB = 0x0000000000000229L;
    /**
     * Normal 128 bit formats
     */
    @Generated @NUInt public static final long RGBA32Uint = 0x000000000000007BL;
    /**
     * Normal 128 bit formats
     */
    @Generated @NUInt public static final long RGBA32Sint = 0x000000000000007CL;
    /**
     * Normal 128 bit formats
     */
    @Generated @NUInt public static final long RGBA32Float = 0x000000000000007DL;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGB_2BPP = 0x00000000000000A0L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGB_2BPP_sRGB = 0x00000000000000A1L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGB_4BPP = 0x00000000000000A2L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGB_4BPP_sRGB = 0x00000000000000A3L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGBA_2BPP = 0x00000000000000A4L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGBA_2BPP_sRGB = 0x00000000000000A5L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGBA_4BPP = 0x00000000000000A6L;
    /**
     * PVRTC
     */
    @Generated @NUInt public static final long PVRTC_RGBA_4BPP_sRGB = 0x00000000000000A7L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long EAC_R11Unorm = 0x00000000000000AAL;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long EAC_R11Snorm = 0x00000000000000ACL;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long EAC_RG11Unorm = 0x00000000000000AEL;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long EAC_RG11Snorm = 0x00000000000000B0L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long EAC_RGBA8 = 0x00000000000000B2L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long EAC_RGBA8_sRGB = 0x00000000000000B3L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long ETC2_RGB8 = 0x00000000000000B4L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long ETC2_RGB8_sRGB = 0x00000000000000B5L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long ETC2_RGB8A1 = 0x00000000000000B6L;
    /**
     * ETC2
     */
    @Generated @NUInt public static final long ETC2_RGB8A1_sRGB = 0x00000000000000B7L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_4x4_sRGB = 0x00000000000000BAL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_5x4_sRGB = 0x00000000000000BBL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_5x5_sRGB = 0x00000000000000BCL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_6x5_sRGB = 0x00000000000000BDL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_6x6_sRGB = 0x00000000000000BEL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_8x5_sRGB = 0x00000000000000C0L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_8x6_sRGB = 0x00000000000000C1L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_8x8_sRGB = 0x00000000000000C2L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x5_sRGB = 0x00000000000000C3L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x6_sRGB = 0x00000000000000C4L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x8_sRGB = 0x00000000000000C5L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x10_sRGB = 0x00000000000000C6L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_12x10_sRGB = 0x00000000000000C7L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_12x12_sRGB = 0x00000000000000C8L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_4x4_LDR = 0x00000000000000CCL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_5x4_LDR = 0x00000000000000CDL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_5x5_LDR = 0x00000000000000CEL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_6x5_LDR = 0x00000000000000CFL;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_6x6_LDR = 0x00000000000000D0L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_8x5_LDR = 0x00000000000000D2L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_8x6_LDR = 0x00000000000000D3L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_8x8_LDR = 0x00000000000000D4L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x5_LDR = 0x00000000000000D5L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x6_LDR = 0x00000000000000D6L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x8_LDR = 0x00000000000000D7L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_10x10_LDR = 0x00000000000000D8L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_12x10_LDR = 0x00000000000000D9L;
    /**
     * ASTC
     */
    @Generated @NUInt public static final long ASTC_12x12_LDR = 0x00000000000000DAL;
    /**
     * [@constant] MTLPixelFormatGBGR422
     * 
     * A pixel format where the red and green channels are subsampled horizontally.  Two pixels are stored in 32 bits, with shared red and blue values, and unique green values.
     * 
     * This format is equivalent to YUY2, YUYV, yuvs, or GL_RGB_422_APPLE/GL_UNSIGNED_SHORT_8_8_REV_APPLE.   The component order, from lowest addressed byte to highest, is Y0, Cb, Y1, Cr.  There is no implicit colorspace conversion from YUV to RGB, the shader will receive (Cr, Y, Cb, 1).  422 textures must have a width that is a multiple of 2, and can only be used for 2D non-mipmap textures.  When sampling, ClampToEdge is the only usable wrap mode.
     */
    @Generated @NUInt public static final long GBGR422 = 0x00000000000000F0L;
    /**
     * [@constant] MTLPixelFormatBGRG422
     * 
     * A pixel format where the red and green channels are subsampled horizontally.  Two pixels are stored in 32 bits, with shared red and blue values, and unique green values.
     * 
     * This format is equivalent to UYVY, 2vuy, or GL_RGB_422_APPLE/GL_UNSIGNED_SHORT_8_8_APPLE. The component order, from lowest addressed byte to highest, is Cb, Y0, Cr, Y1.  There is no implicit colorspace conversion from YUV to RGB, the shader will receive (Cr, Y, Cb, 1).  422 textures must have a width that is a multiple of 2, and can only be used for 2D non-mipmap textures.  When sampling, ClampToEdge is the only usable wrap mode.
     */
    @Generated @NUInt public static final long BGRG422 = 0x00000000000000F1L;
    /**
     * Depth
     */
    @Generated @NUInt public static final long Depth32Float = 0x00000000000000FCL;
    /**
     * Stencil
     */
    @Generated @NUInt public static final long Stencil8 = 0x00000000000000FDL;
    /**
     * Depth Stencil
     */
    @Generated @NUInt public static final long Depth32Float_Stencil8 = 0x0000000000000104L;
    /**
     * Depth Stencil
     */
    @Generated @NUInt public static final long X32_Stencil8 = 0x0000000000000105L;

    @Generated
    private MTLPixelFormat() {
    }

    /**
     * Packed 32 bit formats
     */
    @Generated @NUInt public static final long BGR10A2Unorm = 0x000000000000005EL;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_4x4_HDR = 0x00000000000000DEL;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_5x4_HDR = 0x00000000000000DFL;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_5x5_HDR = 0x00000000000000E0L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_6x5_HDR = 0x00000000000000E1L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_6x6_HDR = 0x00000000000000E2L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_8x5_HDR = 0x00000000000000E4L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_8x6_HDR = 0x00000000000000E5L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_8x8_HDR = 0x00000000000000E6L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_10x5_HDR = 0x00000000000000E7L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_10x6_HDR = 0x00000000000000E8L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_10x8_HDR = 0x00000000000000E9L;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_10x10_HDR = 0x00000000000000EAL;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_12x10_HDR = 0x00000000000000EBL;
    /**
     * ASTC HDR (High Dynamic Range) Formats
     */
    @Generated @NUInt public static final long ASTC_12x12_HDR = 0x00000000000000ECL;
    /**
     * Depth
     */
    @Generated @NUInt public static final long Depth16Unorm = 0x00000000000000FAL;
}
