/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.metal.enums;

import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.NUInt;

/**
 * [@enum] MTLTextureUsage
 * 
 * MTLTextureUsage declares how the texture will be used over its lifetime (bitwise OR for multiple uses).
 * 
 * This information may be used by the driver to make optimization decisions.
 */
@Generated
public final class MTLTextureUsage {
    @Generated @NUInt public static final long Unknown = 0x0000000000000000L;
    @Generated @NUInt public static final long ShaderRead = 0x0000000000000001L;
    @Generated @NUInt public static final long ShaderWrite = 0x0000000000000002L;
    @Generated @NUInt public static final long RenderTarget = 0x0000000000000004L;
    @Generated @NUInt public static final long PixelFormatView = 0x0000000000000010L;

    @Generated
    private MTLTextureUsage() {
    }
}
